import hashlib
import logging
import uuid


from flask import Flask, Blueprint, jsonify, render_template, redirect, url_for, session, jsonify, flash
from flask import request
from requests.exceptions import RequestException
from sqlalchemy import text,  ForeignKey
from flask_login import login_user, current_user, logout_user, login_required
from flask_babel import gettext, lazy_gettext
# from sqlalchemy.orm import sessionmaker
from sqlalchemy.schema import Index

from .k2cfg import K2
from .k2obj import K2Obj
from .k2secur import K2Secur
from app import app, socketio


db = K2.db

class K2admin_menus(db.Model):
    __tablename__ = 'k2admin_menus'
    menuid = db.Column(db.String(75), primary_key=True)
    namemenu = db.Column(db.String(150))
    prevmenu = db.Column(db.String(150))
    ccount = db.Column(db.Integer)
    scriptrun = db.Column(db.Text)
    prevmenu_text = db.Column(db.String(150))
    module_name = db.Column(db.String(150))
    magazinsid = db.Column(db.String(75))
    active = db.Column(db.Integer)
    createuser = db.Column(db.String(75))
    createdate = db.Column(db.DateTime)
    updateuser = db.Column(db.String(75))
    updatedate = db.Column(db.DateTime)
    order_ins = db.Column(db.String(150))
    caption = db.Column(db.String(1024))
    url = db.Column(db.String(2048))
    del_ = db.Column(db.Integer, name='del')

    __table_args__ = (
        db.Index('k2admin_menus_active_idx', 'active'),
        db.Index('k2admin_menus_namemenu_idx', 'namemenu'),
        db.Index('k2admin_menus_prevmenu_idx', 'prevmenu'),
        db.Index('k2admin_menus_module_name_idx', 'module_name'),
        db.Index('k2admin_menus_magazinsid_idx', 'magazinsid'),
        db.Index('k2admin_menus_createuser_idx', 'createuser'),
        db.Index('k2admin_menus_createdate_idx', 'createdate'),
        db.Index('k2admin_menus_updateuser_idx', 'updateuser'),
        db.Index('k2admin_menus_updatedate_idx', 'updatedate'),
        db.Index('k2admin_menus_order_ins_idx', 'order_ins'),

    )

    def __init__(self, **kwargs):
        self.menuid = hashlib.md5(str(uuid.uuid4()).encode()).hexdigest()
        super(K2admin_menus, self).__init__(**kwargs)


    def __repr__(self):
        return f"{self.namemenu}')"

    @classmethod
    def get_menu_count(cls, name_menu):
        try:
            count = cls.query.filter(cls.namemenu == name_menu).count()
            return count
        except Exception as e:
            #logging.error(f"Error {str(e)}")
            return None
        finally:
            db.session.close()


    def get_menu_items_by_roles(self, roleid):
        # with sessionmaker(bind=db.engine)() as session:
        menu_items_b = (
            db.session.query(K2admin_menus.namemenu)
            .join(K2admin_Menus_Prava, K2admin_Menus_Prava.menuid == K2admin_menus.menuid)
            .filter(K2admin_Menus_Prava.roleid == roleid, K2admin_Menus_Prava.active == 1)
            .all()
        )
        menu_items = [item[0] for item in menu_items_b]
        return menu_items

class K2admin_Menus_Prava(db.Model):
    __tablename__ = 'k2admin_menus_prava'
    pravrepid = db.Column(db.String(75), primary_key=True)
    menuid = db.Column(db.String(75), db.ForeignKey('k2admin_menus.menuid'))
    username = db.Column(db.String(150))
    r = db.Column(db.Integer)
    w = db.Column(db.Integer)
    i = db.Column(db.Integer)
    d = db.Column(db.Integer)
    c = db.Column(db.Integer)
    exp = db.Column(db.Integer)
    imp = db.Column(db.Integer)
    del_ = db.Column(db.Integer, name='del')
    settable = db.Column(db.Integer)
    cutpast = db.Column(db.Integer)
    enable = db.Column(db.Integer)
    magazinsid = db.Column(db.String(75))
    active = db.Column(db.Integer)
    createuser = db.Column(db.String(75))
    createdate = db.Column(db.DateTime)
    updateuser = db.Column(db.String(75))
    updatedate = db.Column(db.DateTime)
    order_ins = db.Column(db.Integer)
    roleid = db.Column(db.String(150))


    menu = db.relationship('K2admin_menus', backref='prava')

    # Індекси
    __table_args__ = (
        db.Index('k2admin_menus_prava_menuid_idx', 'menuid'),  # Індекс для зовнішнього ключа menuid
        db.Index('k2admin_menus_prava_username_idx', 'username'),  # Індекс для пошуку за користувачем
        db.Index('k2admin_menus_prava_active_idx', 'active'),  # Індекс для активних записів
        db.Index('k2admin_menus_prava_magazinsid_idx', 'magazinsid'),  # Індекс для пошуку за ідентифікатором магазину
        db.Index('k2admin_menus_prava_createuser_idx', 'createuser'),
        # Індекс для пошуку за користувачем, який створив запис
        db.Index('k2admin_menus_prava_createdate_idx', 'createdate'),  # Індекс для пошуку за датою створення
        db.Index('k2admin_menus_prava_updateuser_idx', 'updateuser'),
        # Індекс для пошуку за користувачем, який оновив запис
        db.Index('k2admin_menus_prava_updatedate_idx', 'updatedate'),  # Індекс для пошуку за датою оновлення
        db.Index('k2admin_menus_prava_roleid_idx', 'roleid'),  # Індекс для пошуку за ідентифікатором ролі
    )

    def __init__(self, **kwargs):
        self.pravrepid = hashlib.md5(str(uuid.uuid4()).encode()).hexdigest()
        super(K2admin_Menus_Prava, self).__init__(**kwargs)



class K2Menu():
    '''меню'''

    def translation_child_superadmin_cloud(self, item, filtered_children=[]):
        for im in item['children']:
            if 'title_key' not in im:
                im['title_key'] = im['title']
            if K2.current_language and app.config['BABEL_DEFAULT_LOCALE'] != K2.current_language:
                app.config['BABEL_DEFAULT_LOCALE'] = K2.current_language
                im['title'] = gettext(im['title_key'])
            elif K2.current_language and app.config['BABEL_DEFAULT_LOCALE'] == K2.current_language:
                app.config['BABEL_DEFAULT_LOCALE'] = K2.current_language
                im['title'] = gettext(im['title_key'])
            else:
                im['title'] = gettext(im['title'])
            if 'children' in im:
                self.translation_child_superadmin_cloud(im, filtered_children=[])
        return filtered_children


    def translation_child(self, item, menu_items_list, filtered_children=[]):

        for im in item['children']:
            if 'title_key' not in im:
                im['title_key'] = im['title']
            if K2.current_language and app.config['BABEL_DEFAULT_LOCALE'] != K2.current_language:
                app.config['BABEL_DEFAULT_LOCALE'] = K2.current_language
                im['title'] = gettext(im['title_key'])
            elif K2.current_language and app.config['BABEL_DEFAULT_LOCALE'] == K2.current_language:
                app.config['BABEL_DEFAULT_LOCALE'] = K2.current_language
                im['title'] = gettext(im['title_key'])
            else:
                im['title'] = gettext(im['title'])
            if K2.namemenu(im['to']) in menu_items_list:
                filtered_children.append(im)
            if 'children' in im:
                self.translation_child(im, menu_items_list, filtered_children=[])
        return filtered_children


    def get_admin_menu(self):
        from datetime import datetime
        if current_user.is_authenticated:
            components_folder = 'components'
            k2 = K2()
            components_data = k2.ins_search_comp()
            if components_data is None:
                return jsonify([])
            # Отримати список імен компонентів
            components_names = [comp['name'] for comp in components_data['components']]
            components_names.append('k2')
            if 'k2site' in components_names:
                role_id = current_user.get_role_id()
                # Збираємо пункти меню
                response = []
                try:
                    data = []
                    # for subclass in K2Obj.__subclasses__():
                    #     if (request.blueprint == subclass.__name__.lower() or request.blueprint == 'components') and \
                    #             hasattr(subclass, 'adm_menu_items') and subclass.__name__.lower() in components_names:

                    subclass_name = request.blueprint
                    if request.blueprint == 'components':
                        subclass_name = 'k2'
                    subclasses = K2Obj.__subclasses__()
                    subclass = next((cls for cls in subclasses if cls.__name__.lower() == subclass_name), None)
                    if hasattr(subclass , 'adm_menu_items') and subclass.__name__.lower() in components_names:
                            menu_item = subclass.adm_menu_items
                            for item in menu_item:
                                data.append(item)

                    filter_menu = []
                    if k2.secur.is_superadmin_cloud(current_user):
                        for item in data:
                            filtered_children = self.translation_child_superadmin_cloud(item, filtered_children=[])
                        filter_menu = data
                    else:
                        menu_items_list = K2admin_menus().get_menu_items_by_roles(role_id)
                        for item in data:
                            filtered_children = self.translation_child(item, menu_items_list, filtered_children=[])
                            if filtered_children:
                                modified_item = dict(item)  # Створити копію словника item
                                modified_item['children'] = filtered_children
                                filter_menu.append(modified_item)
                    return filter_menu
                except RequestException as e:
                    logging.error(f"Error in api/main-menu {str(e)}")
                    return []
        else:
            return []

    from datetime import datetime
    def get_admin_menu_category(self):
        '''Search menu items category'''
        from datetime import datetime
        data = []
        k2 = K2()

        components_names = K2.search_comp_names()
        # components_data = k2.ins_search_comp()
        # if components_data is not None:
        #     # Отримати імена всіх компонентів
        #     components_names = [comp['name'] for comp in components_data['components'] if
        #                         comp.get('installed', True)]
        components_names.append('k2')
        #print(K2Obj.__subclasses__())
        data = [
            subclass.adm_menu_items_category[0]
            for subclass in K2Obj.__subclasses__()
            if hasattr(subclass, 'adm_menu_items_category') and subclass.__name__.lower() in components_names
        ]
        if 'k2site' in components_names:
            role_id = current_user.get_role_id()

        filtered_category = []
        if k2.secur.is_superadmin_cloud(current_user):
            # for im in data:
            #     im['title'] = gettext(im['title'])
            filtered_category = data
        else:
            menu_items_list = K2admin_menus().get_menu_items_by_roles(role_id)
            for im in data:
                if K2.namemenu(im['to']) in menu_items_list:
                    # im['title'] = gettext(im['title'])
                    filtered_category.append(im)
        # K2.menu_category = filtered_category
        # print(filtered_category)
        return filtered_category


    def get_admin_menu_url(self, data):
        '''Menu url'''
        to_values = []
        if isinstance(data, list):
            for item in data:
                to_values.extend(self.get_admin_menu_url(item))
        elif isinstance(data, dict):
            if 'to' in data:
                to_values.append(data['to'])
            for value in data.values():
                to_values.extend(self.get_admin_menu_url(value))
        return to_values


    @classmethod
    def add_menu_with_permissions_db(cls, name_menu, prev_menu, caption_menu, module_name):
        '''Add new menu items to DB'''
        # Session = sessionmaker(bind=db.engine)
        # session = Session()
        from .k2admmenu import K2admin_menus
        count = K2admin_menus.get_menu_count(name_menu)
        if count == 0:
            try:
                new_menu_element = K2admin_menus(
                    namemenu=name_menu,
                    prevmenu=prev_menu,
                    caption=caption_menu,
                    module_name=module_name,
                    active=1,
                )
                db.session.add(new_menu_element)
                db.session.commit()
                # Створення об'єкта k2admin_menus_prava
                new_prava = K2admin_Menus_Prava(
                    menuid=new_menu_element.menuid,  # Зв'язуємо зовнішній ключ з menuid нового меню
                    username=None,
                    r=1,
                    w=1,
                    i=1,
                    d=1,
                    c=1,
                    exp=1,
                    imp=1,
                    settable=1,
                    cutpast=1,
                    enable=1,
                    active=1,
                    roleid=-1
                )
                # Додавання об'єкта k2admin_menus_prava до сесії
                db.session.add(new_prava)
                db.session.commit()
            except Exception as e:
                logging.error(f"Error add_menu_with_permissions_db {str(e)}")
            # finally:
            #     session.close()

    @classmethod
    def add_to_menu_install(cls, component_name):
        try:
            for subclass in K2Obj.__subclasses__():
                if hasattr(subclass, 'adm_menu_items') and subclass.__name__.lower() == component_name:
                    menu_i = getattr(subclass, 'adm_menu_items')
                    for menu_dict in menu_i:
                        prev_menu = menu_dict['title']
                        for item in menu_dict['children']:
                            name_menu = K2.namemenu(item['to'])
                            caption_menu = gettext(item['title'])
                            module_name = subclass.__name__.lower()
                            cls.add_menu_with_permissions_db(name_menu, prev_menu, caption_menu, module_name)
                            if 'children' in item:
                                for it in item['children']:
                                    name_menu = K2.namemenu(it['to'])
                                    caption_menu = gettext(it['title'])
                                    cls.add_menu_with_permissions_db(name_menu, prev_menu, caption_menu, module_name)

        except RequestException as e:
            logging.error(f"Error in add_to_menu_install  {str(e)}")


