import logging
from logging.handlers import RotatingFileHandler
import datetime
import os
from flask import request
from k2.k2cfg import K2
import requests
from flask import g

class K2Logging():
    name = 'k2logging'


def configure_logging():
    # Перевірка, чи вже налаштовано логування
    if not logging.getLogger().handlers:
        # Налаштування рівня логування
        logging.basicConfig(level=logging.INFO)

        # Налаштування формату виводу
        log_format = "%(asctime)s - %(name)s - %(levelname)s -  %(message)s"

        formatter = logging.Formatter(log_format)

        # Шлях до загального лог-файлу
        #log_path = os.path.join("logs", "../../logs/app.log")
        log_path = os.path.join(os.path.dirname(__file__), '..', '..',  'logs', 'app.log')

        # Створення об'єкта для виводу загального логу у файл з ротацією
        file_handler = RotatingFileHandler(log_path, maxBytes=10 * 1024 * 1024, backupCount=5)  # Максимальний розмір 10 МБ, зберігаються останні 5 файлів
        file_handler.setLevel(logging.INFO)
        file_handler.setFormatter(formatter)

        # Виключення повідомлень з текстом "304"
        file_handler.addFilter(lambda record: "304" not in record.getMessage())

        # Додавання інформації про користувача до повідомлень
        #print(K2.user_agent)



        file_handler.setFormatter(logging.Formatter(log_format, datefmt='%Y-%m-%d %H:%M:%S'))
        #file_handler.addFilter(lambda record: add_user_agent_info(record))

        # Отримання кореневого логера та додавання об'єкта виводу загального логу
        logger = logging.getLogger()
        logger.addHandler(file_handler)

def configure_migration_logging():
    # Налаштування рівня логування для міграцій
    migration_logger = logging.getLogger("migration")
    migration_logger.setLevel(logging.INFO)

    # Налаштування формату виводу для міграцій
    log_format = "%(asctime)-2s - %(name)-10s - %(levelname)-10s - %(message)s"
    formatter = logging.Formatter(log_format)

    # Шлях до лог-файлу міграцій
    #log_path = os.path.join("logs", f"migrations.log")
    log_path = os.path.join(os.path.dirname(__file__), '..', '..', 'logs', 'migrations.log')
    # Створення об'єкта для виводу логу міграцій у файл
    file_handler = logging.FileHandler(log_path)
    file_handler.setLevel(logging.INFO)
    file_handler.setFormatter(formatter)


    # Додавання об'єкта виводу логу міграцій до логера міграцій
    migration_logger.addHandler(file_handler)
