#from flask_login import current_user
import logging


from .k2obj import K2Obj


class K2Secur(K2Obj):
    '''клас що відповідає за безпеку та права доступів користувачів'''
    name = 'k2secur'
    def __init__(self, *args, **kwargs):
        super().__init__()
        #self.is_superadmin = self.is_superadmin()


    def get_user_role(self, current_user):
        '''return current_user role by id'''
        if current_user:
            user_id = current_user.get_id()
            try:
                # Отримати roleid
                from components.k2site.k2site.models import K2users
                user_role = K2users.query.filter_by(user_id=user_id).first().roleid
            except Exception as ex:
                user_role = None
                print(ex)
            return user_role

        # ===== РАНГИ: менше число = вищі права =====

    @staticmethod
    def parse_role_rank(roleid) -> int | None:
        try:
            return int(str(roleid).strip())
        except Exception:
            return None

    def get_actor_rank(self, current_user) -> int | None:
        return self.parse_role_rank(self.get_user_role(current_user))

    def can_assign_role(self, actor_roleid, target_roleid, allow_equal: bool = True) -> bool:
        ar = self.parse_role_rank(actor_roleid)
        tr = self.parse_role_rank(target_roleid)
        if ar is None or tr is None:
            return False
        return ar <= tr if allow_equal else ar < tr

    def can_assign_role_by_user(self, current_user, target_roleid, allow_equal: bool = True) -> bool:
        return self.can_assign_role(self.get_user_role(current_user), target_roleid, allow_equal)

    # ==== НОВЕ: повертаємо ролі, які ЗАБОРОНЕНО призначати ====
    def disallowed_roleids_for_user(
            self,
            current_user,
            roleids: list[str | int],
            allow_equal: bool = True
    ) -> list[str]:
        """
        Повертає список roleid (рядками), які поточний користувач НЕ може призначити.
        - Нечислові roleid вважаємо забороненими (консервативно).
        - Логіка рангу: менше число = вищі права.
          Дозволено, якщо actor_rank <= target_rank (або <, якщо allow_equal=False).
        """
        ar = self.get_actor_rank(current_user)
        disallowed: list[str] = []

        # якщо актор не має валідного рангу — все заборонено
        if ar is None:
            return [str(r) for r in roleids]

        for r in roleids:
            rr = self.parse_role_rank(r)
            if rr is None:
                # нечислова роль — забороняємо
                disallowed.append(str(r))
                continue
            allowed = (ar <= rr) if allow_equal else (ar < rr)
            if not allowed:
                disallowed.append(str(r))

        return disallowed

    def disallowed_roleids_sql_where(
            self,
            current_user,
            roleids: list[str | int],
            column: str = "roleid",
            allow_equal: bool = True,
    ) -> tuple[str, dict]:
        """
        Повертає кортеж (sql_clause, params) для використання у WHERE з NOT IN.
        Приклад:
            clause, params = secur.disallowed_roleids_sql_where(current_user, roles, "r.roleid")
            # WHERE {clause}
            # params -> {"disallowed_roleids": (...)}

        Якщо заборонених ролей немає — повертає ("1=1", {}), щоб не впливати на запит.
        """
        disallowed = self.disallowed_roleids_for_user(current_user, roleids, allow_equal)
        if not disallowed:
            return "1=1", {}

        # Параметризовано, без сирих підставлень
        clause = f"{column} NOT IN :disallowed_roleids"
        params = {"disallowed_roleids": tuple(disallowed)}
        return clause, params

    def is_admin(self, current_user):
        return self.get_user_role(current_user) == '1'


    def is_superadmin(self, current_user):
        return self.get_user_role(current_user) == '-1'


    def is_superadmin_branch(self, current_user):
        return self.get_user_role(current_user) == '-50'


    def is_superadmin_root(self, current_user):
        return self.get_user_role(current_user) == '-100'


    def is_superadmin_cloud(self, current_user):
        return self.get_user_role(current_user) == '-1000'





