import zipfile
import tarfile
import shutil
import hashlib
import logging
import time
from datetime import datetime
import re
import signal
import subprocess
import sys
import os
import uuid
from urllib.parse import quote, unquote
from distutils.version import LooseVersion
import json
import traceback
from pathlib import Path

from flask import Flask, Blueprint, jsonify, render_template, redirect, url_for, session, jsonify, flash, send_from_directory, request
from flask_migrate import Migrate
from flask_socketio import SocketIO, emit
import requests
from requests.exceptions import RequestException
from flask import current_app
import yaml
from functools import wraps
from sqlalchemy import text
import psutil
from flask_jwt_extended import get_jwt_identity, jwt_required
from flask_login import login_user, current_user, logout_user, login_required
from flask_babel import gettext
import platform
from sqlalchemy.exc import SQLAlchemyError
from sqlalchemy import create_engine, MetaData, Table, select, insert
from sqlalchemy.dialects.postgresql import insert

from flask import flash

from k2.k2cfg import K2
from k2.k2obj import K2Obj
from k2.k2admmenu import K2Menu
from k2.k2secur import K2Secur
from app import app, socketio

components_bp = Blueprint('components', __name__, template_folder='templates', static_url_path='static')
db = K2.db

#### func ####


def reload_app_configs(name):
    from routes import register_components
    from app import app
    components = []
    components.append(name)
    register_components(app, components)
    return redirect(url_for('components.dashboards'))


def reload_app_configs_del(name):
    from routes import unregister_component
    from app import app
    components = []
    components.append(name)
    unregister_component(app, components)
    return redirect(url_for('components.dashboards'))


class K2Upd(K2Obj):
    project_folder = 'components'  # Шлях до корневої папки проектів
    result_status = {}

    def __init__(self, *args, **kwargs):
        super().__init__()


    @classmethod
    def get_k2update_components(cls):
        '''api запит до сервера оновлень для отримання списку компонент stable версій'''
        # додаємо токен
        jwt_token = str(K2.update_token)
        # Передаємо  JWT токен у заголовку Authorization
        headers = {'Authorization': f'Bearer {jwt_token}'}
        response = requests.get(f'{K2.update_domain}k2update/api/components-new', headers=headers)
        json_data = response.json()
        return json_data

    @classmethod
    def get_k2update_components_old(cls):
        '''api запит до сервера оновлень для отримання списку компонент stable версій'''
        # додаємо токен
        jwt_token = str(K2.update_token)
        # Передаємо  JWT токен у заголовку Authorization
        headers = {'Authorization': f'Bearer {jwt_token}'}
        response = requests.get(f'{K2.update_domain}k2update/api/components', headers=headers)
        json_data = response.json()
        return json_data

    @classmethod
    def get_k2update_license_key_avaibility(cls, key):
        '''api запит до сервера оновлень для отримання списку компонент stable версій'''
        # додаємо токен
        '''api запит до сервера оновлень для отримання статусу ліцензії'''
        # додаємо токен
        jwt_token = key
        # Передаємо  JWT токен у заголовку Authorization
        headers = {'Authorization': f'Bearer {jwt_token}'}
        response = requests.get(f'{K2.update_domain}k2update/api/components-update-accessibility-by-key', headers=headers)
        json_data = response.json()
        return json_data


    @classmethod
    def get_k2update_components_update_avaibility(cls):
        '''api запит до сервера оновлень для отримання статусу ліцензії'''
        # додаємо токен
        token = str(K2.update_token)
        # Передаємо  JWT токен у заголовку Authorization
        headers = {'Authorization': f'Bearer {token}'}
        response = requests.get(f'{K2.update_domain}k2update/api/components-update-accessibility-by-key', headers=headers)
        json_data = response.json()
        return json_data

    @classmethod
    def get_k2update_components_update_avaibility_old(cls):
        '''api запит до сервера оновлень для отримання статусу ліцензії через jwt токен'''
        # додаємо токен
        jwt_token = str(K2.update_token)
        # Передаємо  JWT токен у заголовку Authorization
        headers = {'Authorization': f'Bearer {jwt_token}'}
        response = requests.get(f'{K2.update_domain}k2update/api/components-update-avaibility', headers=headers)
        json_data = response.json()
        return json_data

    @classmethod
    def get_k2update_license_key_avaibility_old(cls, key):
        '''api запит до сервера оновлень для отримання статусу ліцензії'''
        # додаємо токен
        jwt_token = key
        # Передаємо  JWT токен у заголовку Authorization
        headers = {'Authorization': f'Bearer {jwt_token}'}
        response = requests.get(f'{K2.update_domain}k2update/api/components-update-avaibility', headers=headers)
        json_data = response.json()
        return json_data

    @staticmethod
    def get_license_key_from_file(component_name):
        '''Універсальний метод для зчитування ліцензійного ключа з файлу'''
        file_path = os.path.join(os.path.dirname(__file__), '..', '..', 'cfg', 'k2', 'license', f'{component_name}.yml')

        # Перевірка, чи існує файл
        if os.path.exists(file_path):
            with open(file_path, 'r') as file:
                data = yaml.safe_load(file)
                # Повертаємо ключ, якщо він є в файлі
                return data.get('license_key', None)
        return None

    @staticmethod
    def get_syncfusion_license_key():
        '''Метод для отримання ліцензійного ключа Syncfusion'''
        return K2Upd.get_license_key_from_file('syncfusion')

    @staticmethod
    def get_stimulsoft_license_key():
        '''Метод для отримання ліцензійного ключа Stimulsoft'''
        return K2Upd.get_license_key_from_file('stimulsoft')

    @staticmethod
    def get_aggrid_license_key():
        '''Метод для отримання ліцензійного ключа AgGrid'''
        return K2Upd.get_license_key_from_file('aggrid')

    @staticmethod
    def save_license_key(component_name, license_key):
        '''Функція для збереження ліцензійного ключа у файл'''
        file_path = os.path.join(os.path.dirname(__file__), '..', '..', 'cfg', K2.proj_config, 'license', f'{component_name}.yml')
        os.makedirs(os.path.dirname(file_path), exist_ok=True)
        with open(file_path, 'w') as file:
            yaml.dump({'license_key': license_key}, file)

    @classmethod
    def get_k2update_components_beta(cls):
        '''api запит до сервера оновлень для отримання списку компонент beta версій'''
        response = requests.get(f'{K2.update_domain}k2update/api/components-beta')
        json_data = response.json()
        return json_data

    @classmethod
    def get_k2update_components_options(cls):
        '''api запит до сервера оновлень для отримання опцій компонент'''
        response = requests.get(f'{K2.update_domain}k2update/api/components-options')
        json_data = response.json()
        return json_data

    @classmethod
    def get_k2update_metadata(cls):
        '''api запит до сервера оновлень для отримання метаданих компонент'''
        response = requests.get(f'{K2.update_domain}k2update/api/components-metadata')
        # response = requests.get(f'http://127.0.0.1:7654/k2update/api/components-metadata')
        json_data = response.json()
        return json_data

    @classmethod
    def get_components_data_yml(cls):
        '''Отримуємо дані компонент з yml файлу '''
        try:

            # Зчитати вміст файлу YAML
            with open(f"{cls.project_folder}/components.yml", 'r') as file:
                components_data = yaml.safe_load(file)
            return components_data
        except FileNotFoundError as e:
            logging.error(f"Not found  {str(e)}")
            return None

    @classmethod
    def save_components_data_yml(cls, components_data):
        '''Записати оновлений вміст у файл YAML'''
        with open(f"{cls.project_folder}/components.yml", 'w', encoding='utf-8') as file:
            yaml.dump(components_data, file)

    @classmethod
    def del_compomemts_data_yml(cls, component_name):
        '''видалення  компоненти'''
        # Зчитати вміст файлу YAML
        with open(f"{cls.project_folder}/components.yml", 'r') as file:
            components_data = yaml.safe_load(file)

        if components_data is None:
            logging.error(f"Components not found ")
            return False
        # Знайти компоненту за ID
        # component = None
        for comp in components_data['components']:
            if comp['name'] == component_name:
                component_id = comp['id']
                break

        # Видалити компоненту зі списку
        components_data['components'] = [comp for comp in components_data['components'] if
                                         comp['id'] != component_id]

        # Записати оновлений вміст у файл YAML
        with open(f"{cls.project_folder}/components.yml", 'w') as file:
            yaml.dump(components_data, file)
        reload_app_configs_del(component_name)
        reload_app()
        K2().search_menu_items()
        K2().search_menu_items_category()
        event = f"Uninstall component {component_name} "
        write_to_log_file(event)
        # logging.info(f"{component['name']} removed successfully")
        flash('t_remove_component_msg', 'error')
        return True

    # @classmethod
    # def get_archive_data(cls, archive_url):
    #     '''Завантажуємо і розпаковуєм архів компоненти'''
    #     # Створити шлях до папки компоненти згідно назви та версії
    #     component_folder = os.path.join(cls.project_folder)
    #     os.makedirs(component_folder, exist_ok=True)
    #     # Завантажити архів компоненти
    #     response = requests.get(archive_url, stream=True)
    #     response.raise_for_status()
    #     # Шлях до завантаженого архіву
    #     archive_path = os.path.join(component_folder, f"{selected_component['name']}.zip")
    #     # Зберегти архів на диск
    #     with open(archive_path, "wb") as file:
    #         for chunk in response.iter_content(chunk_size=8192):
    #             file.write(chunk)
    #     # Розпакувати архів
    #     with zipfile.ZipFile(archive_path, "r") as zip_ref:
    #         zip_ref.extractall(component_folder)
    #     # Видалити архів
    #     os.remove(archive_path)
    #     # перейменувати якщо git
    #     component_name = selected_component['name']
    #     old_folder_path = os.path.join(component_folder, component_name + ".git")
    #     new_folder_path = os.path.join(component_folder, component_name)
    #     # Перевірка наявності папки зі старою назвою
    #     if os.path.exists(old_folder_path) and os.path.isdir(old_folder_path):
    #         # Перейменування папки зі старою назвою на нову назву
    #         os.rename(old_folder_path, new_folder_path)

    @classmethod
    def get_dependencies_from_archive(cls, file_path):
        dependencies = []
        if os.path.isfile(file_path):  # Перевірка наявності файлу
            try:
                with open(file_path, 'r') as file:
                    dependencies = file.readlines()
                    dependencies = [dep.strip() for dep in dependencies]
                    dependencies = ', '.join(dependencies)
                return dependencies
            except Exception as e:
                logging.error(f"{file_path} Not found   {str(e)}")
                dependencies = []
        else:
            dependencies = []

    @classmethod
    def move_folder(cls, source_path, destination_path):
        """
        Переміщує папку з однієї директорії в іншу.

        :param source_path: Шлях до джерела (папка, яку треба перемістити)
        :param destination_path: Шлях до місця призначення (директорія, куди перемістити)
        """
        try:
            shutil.move(source_path, destination_path)
        except Exception as e:
            logging.error(f"Error move folder {e}")

    @classmethod
    def extract_archive(cls, archive_path, extract_path="."):
        """
        Розпаковує архів у вказаний каталог.

        :param archive_path: Шлях до архіву
        :param extract_path: Каталог для розпаковки (за замовчуванням - поточний каталог)
        """
        # Визначаємо формат архіву за розширенням
        try:
            if archive_path.endswith(".zip"):
                with zipfile.ZipFile(archive_path, 'r') as zip_ref:
                    zip_ref.extractall(extract_path)
            elif archive_path.endswith(".tar.gz") or archive_path.endswith(".tgz"):
                with tarfile.open(archive_path, 'r:gz') as tar_ref:
                    tar_ref.extractall(extract_path)
            elif archive_path.endswith(".tar"):
                with tarfile.open(archive_path, 'r:') as tar_ref:
                    tar_ref.extractall(extract_path)
            else:
                logging.error(f"Unnsupported archive format")
        except Exception as e:
            logging.error(f"Error unzip archive {e}")

    @classmethod
    def install_components(cls, component_id, component_name):
        '''встановлення  комаоненти'''
        try:
            try:
                check_status = True
                # Отримати дані компонент з сервера оновлень
                json_data = K2Upd.get_k2update_components()
                # вибіо компоненти по id
                selected_component = next((component for component in json_data if component['id'] == component_id),
                                          None)
                if selected_component is None:
                    return 'Component not found'
                # selected_component_name = selected_component['name']
                archive_url = selected_component['latest_component_data']
                version = selected_component['latest_version']
            except Exception as e:
                logging.error(f"Update server is not avaible {e}")
                check_status = False
                cls.result_status['status'] = False
                cls.result_status['error'] = str(e)

            if check_status:
                try:
                    # Створити шлях до папки компоненти згідно назви та версії
                    project_folder = 'components'
                    component_folder = os.path.join(project_folder)
                    os.makedirs(component_folder, exist_ok=True)
                    # Завантажити архів компоненти
                    response = requests.get(archive_url, stream=True)
                    response.raise_for_status()
                except Exception as e:
                    logging.error(f"{e}")
                    check_status = False
                    cls.result_status['status'] = False
                    cls.result_status['error'] = str(e)

            if check_status:
                try:
                    # Шлях до завантаженого архіву
                    archive_path = os.path.join(component_folder, f"{component_name}.zip")
                    # Зберегти архів на диск
                    with open(archive_path, "wb") as file:
                        for chunk in response.iter_content(chunk_size=4096):
                            file.write(chunk)
                        # Розпакувати архів
                    with zipfile.ZipFile(archive_path, "r") as zip_ref:
                        zip_ref.extractall(component_folder)
                    # Видалити архів
                    os.remove(archive_path)
                    # перейменувати якщо git
                    # component_name = selected_component['name']
                    old_folder_path = os.path.join(component_folder, component_name + ".git")
                    new_folder_path = os.path.join(component_folder, component_name)
                    # Перевірка наявності папки зі старою назвою
                    if os.path.exists(old_folder_path) and os.path.isdir(old_folder_path):
                        # Перейменування папки зі старою назвою на нову назву
                        os.rename(old_folder_path, new_folder_path)
                except Exception as e:
                    logging.error(f"ChunkedEncodingError {e}")
                    check_status = False
            if check_status:
                components_data = cls.get_components_data_yml()
                if components_data == None:
                    components_data = {'components': []}
                # Перевірити унікальність імен компонентів
                existing_component = next(
                    (c for c in components_data['components'] if c['name'] == component_name),
                    None)
                if existing_component:
                    # Оновити існуючий компонент
                    existing_component['id'] = generate_id()
                    existing_component['version'] = version
                    # existing_component['dependencies'] = dependencies
                    existing_component['installed'] = True
                else:
                    # Додати новий компонент до списку
                    components_data['components'].append({
                        'id': generate_id(),
                        'name': component_name,
                        'version': version,
                        # 'dependencies': dependencies,
                        'installed': True
                    })
                cls.save_components_data_yml(components_data)
                reload_app_configs(component_name)
                reload_app()
                K2.search_babel_translation_directories()
                if 'babel' in app.extensions:
                    app.extensions.pop('babel')
                from app import babel
                K2.load_babel_translation_directories()
                app.config['BABEL_TRANSLATION_DIRECTORIES'] = K2.babel_translation_directories
                app.config['BABEL_LANGUAGES'] = K2.languages
                app.config['BABEL_DEFAULT_TIMEZONE'] = K2.timezone
                babel.init_app(app, locale_selector=K2.get_locale,
                               default_translation_directories=K2.babel_translation_directories)
                K2Menu.add_to_menu_install('k2')
                K2Menu.add_to_menu_install(component_name)
                K2().search_menu_items()
                K2().search_menu_items_category()
                K2().search_class_dict()
                logging.info(f"Copying component files is successful: {component_name} v{version}")
                event = f"Install component {component_name} "
                write_to_log_file(event)
                logging.info(f"Copying component files is successful: {component_name} v{version}")
                cls.result_status['status'] = True
        except Exception as e:
            # requests.get(f"{K2.domain_loc}/remove-component/{component_id}")
            logging.error(f"Error in module install_components {component_name}: {str(e)}")
            cls.result_status['status'] = False
            cls.result_status['error'] = str(e)

    @classmethod
    def install_components_beta(cls, component_id, component_name):
        '''встановлення  комаоненти'''
        try:
            try:
                check_status = True
                # Отримати дані компонент з сервера оновлень
                json_data = K2Upd.get_k2update_components_beta()
                # вибіо компоненти по id
                selected_component = next((component for component in json_data if component['id'] == component_id),
                                          None)
                if selected_component is None:
                    return 'Component not found'
                # selected_component_name = selected_component['name']
                archive_url = selected_component['latest_component_data']
                version = selected_component['latest_version']
            except Exception as e:
                logging.error(f"Update server is not avaible {e}")
                check_status = False
                cls.result_status['status'] = False
                cls.result_status['error'] = str(e)

            if check_status:
                try:
                    # Створити шлях до папки компоненти згідно назви та версії
                    project_folder = 'components'
                    component_folder = os.path.join(project_folder)
                    os.makedirs(component_folder, exist_ok=True)
                    # Завантажити архів компоненти
                    response = requests.get(archive_url, stream=True)
                    response.raise_for_status()
                except Exception as e:
                    logging.error(f"{e}")
                    check_status = False
                    cls.result_status['status'] = False
                    cls.result_status['error'] = str(e)

            if check_status:
                try:
                    # Шлях до завантаженого архіву
                    archive_path = os.path.join(component_folder, f"{component_name}.zip")
                    # Зберегти архів на диск
                    with open(archive_path, "wb") as file:
                        for chunk in response.iter_content(chunk_size=4096):
                            file.write(chunk)
                        # Розпакувати архів
                    with zipfile.ZipFile(archive_path, "r") as zip_ref:
                        zip_ref.extractall(component_folder)
                    # Видалити архів
                    os.remove(archive_path)
                    # перейменувати якщо git
                    # component_name = selected_component['name']
                    old_folder_path = os.path.join(component_folder, component_name + ".git")
                    new_folder_path = os.path.join(component_folder, component_name)
                    # Перевірка наявності папки зі старою назвою
                    if os.path.exists(old_folder_path) and os.path.isdir(old_folder_path):
                        # Перейменування папки зі старою назвою на нову назву
                        os.rename(old_folder_path, new_folder_path)
                except Exception as e:
                    logging.error(f"ChunkedEncodingError {e}")
                    check_status = False
            if check_status:
                components_data = cls.get_components_data_yml()
                if components_data == None:
                    components_data = {'components': []}
                # Перевірити унікальність імен компонентів
                existing_component = next(
                    (c for c in components_data['components'] if c['name'] == component_name),
                    None)
                if existing_component:
                    # Оновити існуючий компонент
                    existing_component['id'] = generate_id()
                    existing_component['version'] = version
                    # existing_component['dependencies'] = dependencies
                    existing_component['installed'] = True
                else:
                    # Додати новий компонент до списку
                    components_data['components'].append({
                        'id': generate_id(),
                        'name': component_name,
                        'version': version,
                        # 'dependencies': dependencies,
                        'installed': True
                    })
                cls.save_components_data_yml(components_data)
                reload_app_configs(component_name)
                reload_app()
                K2.search_babel_translation_directories()
                if 'babel' in app.extensions:
                    app.extensions.pop('babel')
                from app import babel
                K2.load_babel_translation_directories()
                app.config['BABEL_TRANSLATION_DIRECTORIES'] = K2.babel_translation_directories
                app.config['BABEL_LANGUAGES'] = K2.languages
                app.config['BABEL_DEFAULT_TIMEZONE'] = K2.timezone
                babel.init_app(app, locale_selector=K2.get_locale,
                               default_translation_directories=K2.babel_translation_directories)
                K2Menu.add_to_menu_install('k2')
                K2Menu.add_to_menu_install(component_name)
                K2().search_menu_items()
                K2().search_menu_items_category()
                K2().search_class_dict()
                logging.info(f"Copying component files is successful: {component_name} v{version}")
                event = f"Install component {component_name} "
                write_to_log_file(event)
                logging.info(f"Copying component files is successful: {component_name} v{version}")
                cls.result_status['status'] = True
        except Exception as e:
            # requests.get(f"{K2.domain_loc}/remove-component/{component_id}")
            logging.error(f"Error in module install_components {component_name}: {str(e)}")
            cls.result_status['status'] = False
            cls.result_status['error'] = str(e)


    @classmethod
    def install_components_php(cls, component_id, component_name):
        try:
            try:
                check_status = True
                # Отримати дані компонент з сервера оновлень
                json_data = K2Upd.get_k2update_components()
                # вибіо компоненти по id
                selected_component = next((component for component in json_data if component['id'] == component_id),
                                          None)
                if selected_component is None:
                    return 'Component not found'
                # selected_component_name = selected_component['name']
                archive_url = selected_component['latest_component_data']
                version = selected_component['latest_version']
            except Exception as e:
                logging.error(f"Update server is not avaible {e}")
                check_status = False
                cls.result_status['status'] = False
                cls.result_status['error'] = str(e)

            if check_status:
                try:
                    # Створити шлях до папки компоненти згідно назви та версії
                    project_folder = 'components'
                    project_folder_php = f'../web/{component_name}'
                    component_folder = os.path.join(project_folder)
                    os.makedirs(component_folder, exist_ok=True)
                    # # Завантажити архів компоненти
                    # response = requests.get(archive_url, stream=True)
                    # response.raise_for_status()
                except Exception as e:
                    logging.error(f"{e}")
                    check_status = False
                    cls.result_status['status'] = False
                    cls.result_status['error'] = str(e)

            if check_status:
                try:
                    if os.path.exists(os.path.join(project_folder, component_name)):
                        shutil.rmtree(os.path.join(project_folder, component_name))
                    cls.move_folder(project_folder_php, project_folder)
                except Exception as e:
                    logging.error(f"{e}")
                    check_status = False
                    cls.result_status['status'] = False
                    cls.result_status['error'] = str(e)

            if check_status:
                components_data = cls.get_components_data_yml()
                if components_data == None:
                    components_data = {'components': []}
                # Перевірити унікальність імен компонентів
                existing_component = next(
                    (c for c in components_data['components'] if c['name'] == component_name),
                    None)
                if existing_component:
                    # Оновити існуючий компонент
                    existing_component['id'] = generate_id()
                    existing_component['version'] = version
                    # existing_component['dependencies'] = dependencies
                    existing_component['installed'] = True
                else:
                    # Додати новий компонент до списку
                    components_data['components'].append({
                        'id': generate_id(),
                        'name': component_name,
                        'version': version,
                        # 'dependencies': dependencies,
                        'installed': True
                    })
                cls.save_components_data_yml(components_data)
                reload_app_configs(component_name)
                reload_app()
                K2.search_babel_translation_directories()
                if 'babel' in app.extensions:
                    app.extensions.pop('babel')
                from app import babel
                K2.load_babel_translation_directories()
                app.config['BABEL_TRANSLATION_DIRECTORIES'] = K2.babel_translation_directories
                app.config['BABEL_LANGUAGES'] = K2.languages
                app.config['BABEL_DEFAULT_TIMEZONE'] = K2.timezone
                babel.init_app(app, locale_selector=K2.get_locale,
                               default_translation_directories=K2.babel_translation_directories)
                K2Menu.add_to_menu_install(component_name)
                K2().search_menu_items()
                K2().search_menu_items_category()
                logging.info(f"Copying component files is successful: {component_name} v{version}")
                event = f"Install component {component_name} "
                write_to_log_file(event)
                logging.info(f"Copying component files is successful: {component_name} v{version}")
                cls.result_status['status'] = True
        except Exception as e:
            # requests.get(f"{K2.domain_loc}/remove-component/{component_id}")
            logging.error(f"Error in module install_components_php  {component_name}: {str(e)}")
            cls.result_status['status'] = False
            cls.result_status['error'] = str(e)

    @classmethod
    def install_requirments(cls, component_name: str):
        """Встановлення Python-залежностей для компонента (кросплатформенно, без жорстких шляхів)."""
        try:
            # Визначаємо корінь проекту (каталог із run.sh / requirements.txt)
            # Якщо файл цього класу лежить у K2CloudERP/k2/..., то:
            project_root = Path(__file__).resolve().parents[1]  # K2CloudERP/
            # Якщо інша структура — підкоригуй: print(project_root) і перевір.

            # Шлях до requirements:
            if component_name == 'k2root':
                requirements_file = project_root / 'requirements.txt'
            else:
                requirements_file = project_root / 'components' / component_name / 'requirements.txt'

            if not requirements_file.is_file():
                logging.info(f"Requirements file not found for {component_name}: {requirements_file}")
                cls.result_status['status'] = True  # нічого ставити — це не помилка
                return

            # Використовуємо саме поточний інтерпретатор (у venv це буде .../venv/bin/python)
            py = sys.executable
            cmd = [py, "-m", "pip", "install", "--no-cache-dir", "-r", str(requirements_file)]
            logging.info("Running: %s", " ".join(cmd))
            subprocess.run(cmd, check=True)

            cls.result_status['status'] = True
            logging.info(f"Requirements for {component_name} installed successfully")

        except subprocess.CalledProcessError as e:
            logging.error("Error installing requirements (%s): %s", component_name, e)
            cls.result_status['status'] = False
            cls.result_status['error'] = str(e)
        except Exception as e:
            logging.error("Unexpected error installing requirements (%s): %s", component_name, e)
            cls.result_status['status'] = False
            cls.result_status['error'] = str(e)

    @classmethod
    def write_migrations_to_log_file(cls, event):
        # log_file = '../../logs/migrations-logs.txt'
        log_file = os.path.join(os.path.dirname(__file__), '..', '..', 'logs', 'migrations-logs.txt')
        with open(log_file, 'w') as file:
            file.write(str(datetime.now()) + '---' + event)

    @classmethod
    def show_migrations_stderr(cls):
        log_file = os.path.join(os.path.dirname(__file__), '..', '..', 'logs', 'migrations-logs.txt')
        with open(log_file, 'r') as file:
            file_content = file.read()
        return file_content

    @classmethod
    def save_sync_log_data(cls,
                           component_data_id=None,
                           component_data_type_id=None,
                           component_data_file=None,
                           sync_status=None,
                           sync_error=None,
                           type_sync=None):
        try:
            from components.k2site.k2site.models import K2log_sync
            # user_id = current_user.get_id()
            # user = K2users.query.get(user_id)
            # db.session.refresh(user)
            # if user:
            #     user_name = user.login
            try:
                res = K2log_sync(
                    log_sync_id=K2.generate_id(),
                    # user_id=user_id,
                    # user_name=user_name,
                    component_data_id=component_data_id,
                    component_data_type_id=component_data_type_id,
                    component_data_file=component_data_file,
                    sync_date=datetime.now(K2.timezone),
                    sync_status=sync_status,
                    sync_error=sync_error,
                    type_sync=type_sync
                )
                if res:
                    db.session.add(res)
                    db.session.commit()
            except Exception as e:
                logging.error(f'Error in save_sync_log_data {e}')
            finally:
                db.session.close()
        except Exception as e:
            logging.error(f'Error in save_sync_log_data {e}')

    # @classmethod
    # def make_migrations(cls, component_name):
    #     '''роут Створення міграцій'''
    #     session_id = request.sid
    #     if K2.platform == 'Windows':
    #         venv_bin_path = os.path.join(os.path.dirname(sys.prefix), 'venv/Scripts')
    #     elif K2.platform == 'Linux':
    #         venv_bin_path = os.path.join(os.path.dirname(sys.prefix), 'venv/bin')
    #     original_stderr = sys.stderr
    #     #logging.info(f'-----------{venv_bin_path}')
    #     # Визначаємо власний потік або файл для stdout
    #     custom_stderr_file = os.path.join(os.path.dirname(__file__), '..', '..', 'logs', 'install_error_log.txt')
    #     custom_stderr = open(custom_stderr_file, 'w')
    #     custom_stderr.truncate(0)
    #     sys.stderr = custom_stderr
    #     app = current_app
    #     reload_app_configs(component_name)
    #     reload_app()
    #     try:
    #         migrations_dir = os.path.join(app.root_path, 'migrations')
    # 
    #         if not os.path.exists(migrations_dir):
    #             init_command = f'{venv_bin_path}/python -m flask db init'
    #             init_result = subprocess.run(init_command, shell=True, check=True, stdout=subprocess.PIPE,
    #                                          stderr=subprocess.PIPE)
    #             log_migration_output(init_result.stdout)  # Запис повідомлень про міграцію у лог
    #             log_migration_output(init_result.stderr)  # Запис повідомлень про помилки у лог
    # 
    #         migrate_command = f"{venv_bin_path}/python -m flask db migrate -m '{component_name}'"
    #         migrate_result = subprocess.run(migrate_command, shell=True, stdout=subprocess.PIPE,
    #                                         stderr=subprocess.PIPE)
    #         log_migration_output(migrate_result.stdout)  # Запис повідомлень про міграцію у лог
    #         write_migrations_to_log_file(str(migrate_result.stdout))
    #         log_migration_output(migrate_result.stderr)  # Запис повідомлень про помилки у лог
    #         cls.write_migrations_to_log_file(str(migrate_result.stderr))
    #         socketio.emit('update_progress', {'progress': 88,
    #                                           'message': f"Оновлення {component_name} 88%",
    #                                           'install_message': f'Виконання міграцій бази даних компоненти {component_name}...{migrate_result.stdout}'},
    #                       room=session_id)
    # 
    #         # Перевірка коду помилки після виконання команди
    #         if migrate_result.returncode != 0:
    #             cls.result_status['status'] = False
    #             raise Exception(f"Migrate command failed with exit code {migrate_result.returncode}")
    # 
    #         upgrade_command = f'{venv_bin_path}/python -m flask db upgrade'
    #         upgrade_result = subprocess.run(upgrade_command, shell=True, stdout=subprocess.PIPE,
    #                                         stderr=subprocess.PIPE)
    #         log_migration_output(upgrade_result.stdout)  # Запис повідомлень про міграцію у лог
    #         cls.write_migrations_to_log_file(str(migrate_result.stdout))
    #         socketio.emit('update_progress', {'progress': 91,
    #                                           'message': f"Оновлення {component_name}",
    #                                           'install_message': f'Виконання міграцій бази даних компоненти {component_name}...{migrate_result.stdout}'},
    #                       room=session_id)
    #         log_migration_output(upgrade_result.stderr)  # Запис повідомлень про помилки у лог
    #         cls.write_migrations_to_log_file(str(migrate_result.stderr))
    # 
    #         # Перевірка коду помилки після виконання команди
    #         if upgrade_result.returncode != 0:
    #             cls.result_status['status'] = False
    #             raise Exception(f"Upgrade command failed with exit code {upgrade_result.returncode}")
    # 
    #         requests.get(f"{K2.domain_loc}/{component_name}/data-migrations")
    #         logging.info(f"Migrations for {component_name} done successfully")
    #         cls.result_status['status'] = True
    # 
    #     except SQLAlchemyError as e:
    #         logging.error(f"Error make migrations: {str(e)}")
    #         cls.result_status['status'] = False
    #         cls.result_status['error'] = str(e)

    @classmethod
    def make_migrations(cls, component_name):
        """Створення та застосування міграцій Alembic/Flask-Migrate для компонента."""
        session_id = request.sid

        # ----- лог-файл у K2CloudERP/logs -----
        # цей файл (із методом) зазвичай у K2CloudERP/k2/... → два рівні вгору = K2CloudERP/
        project_root = Path(__file__).resolve().parents[2]
        logs_dir = project_root / "logs"
        logs_dir.mkdir(parents=True, exist_ok=True)
        custom_stderr_file = logs_dir / "install_error_log.txt"

        # підміняємо stderr на наш файл
        original_stderr = sys.stderr
        custom_stderr = open(custom_stderr_file, "w")
        custom_stderr.truncate(0)
        sys.stderr = custom_stderr

        app = current_app

        # Готуємо середовище для flask CLI
        env = os.environ.copy()
        # якщо у тебе інший модуль/фабрика, тут підкоригуй значення
        env.setdefault("FLASK_APP", "app:app")
        # переконаймося, що k2/ у PYTHONPATH
        env["PYTHONPATH"] = f"{app.root_path}{os.pathsep}{env.get('PYTHONPATH', '')}"

        def run_cli(args):
            """Запуск команди flask у каталозі додатка, з вірним env і інтерпретатором venv."""
            cmd = [sys.executable, "-m", "flask", *args]
            result = subprocess.run(
                cmd,
                cwd=app.root_path,
                env=env,
                text=True,
                stdout=subprocess.PIPE,
                stderr=subprocess.PIPE,
                check=False,  # самі перевіримо код виходу
            )
            # твої власні логери (зберіг) — якщо у тебе є ці функції
            try:
                log_migration_output(result.stdout)
            except Exception:
                pass
            try:
                log_migration_output(result.stderr)
            except Exception:
                pass
            return result

        try:
            # якщо треба — підвантажити конфіги/додаток
            reload_app_configs(component_name)
            reload_app()

            migrations_dir = Path(app.root_path) / "migrations"
            if not migrations_dir.exists():
                init_res = run_cli(["db", "init"])
                if init_res.returncode != 0:
                    cls.result_status["status"] = False
                    raise Exception(f"'flask db init' failed: {init_res.stderr.strip()}")

            migrate_res = run_cli(["db", "migrate", "-m", component_name])
            # лог в твій файл/канал
            write_migrations_to_log_file(str(migrate_res.stdout))
            cls.write_migrations_to_log_file(str(migrate_res.stderr))
            socketio.emit(
                "update_progress",
                {
                    "progress": 88,
                    "message": f"Оновлення {component_name} 88%",
                    "install_message": f"Виконання міграцій БД {component_name}...{migrate_res.stdout}",
                },
                room=session_id,
            )
            if migrate_res.returncode != 0:
                cls.result_status["status"] = False
                raise Exception(f"'flask db migrate' failed: {migrate_res.stderr.strip()}")

            upgrade_res = run_cli(["db", "upgrade"])
            # повторно пишемо у логи
            cls.write_migrations_to_log_file(str(upgrade_res.stdout))
            cls.write_migrations_to_log_file(str(upgrade_res.stderr))
            socketio.emit(
                "update_progress",
                {
                    "progress": 91,
                    "message": f"Оновлення {component_name}",
                    "install_message": f"Виконання міграцій БД {component_name}...{upgrade_res.stdout}",
                },
                room=session_id,
            )
            if upgrade_res.returncode != 0:
                cls.result_status["status"] = False
                raise Exception(f"'flask db upgrade' failed: {upgrade_res.stderr.strip()}")

            # пост-міграційні дані
            try:
                requests.get(f"{K2.domain_loc}/{component_name}/data-migrations", timeout=30)
            except Exception as _:
                # не валимо процес, просто залогуємо
                logging.warning("data-migrations request failed for %s", component_name)

            logging.info("Migrations for %s done successfully", component_name)
            cls.result_status["status"] = True

        except SQLAlchemyError as e:
            logging.error("Error make migrations (SQLA): %s", e)
            cls.result_status["status"] = False
            cls.result_status["error"] = str(e)

        except Exception as e:
            logging.error("Error make migrations: %s", e)
            cls.result_status["status"] = False
            cls.result_status["error"] = str(e)

        finally:
            # повертаємо stderr
            try:
                sys.stderr = original_stderr
                custom_stderr.close()
            except Exception:
                pass

    @classmethod
    def update_k2cloud_root(cls):
        '''оновлення ядра системи'''
        check_status = True
        if check_status:
            from app import app
            app.blueprints.pop('components')
            try:
                json_data = K2Upd.get_k2update_components()
                component_server = [item for item in json_data if item['name'] == 'k2root']
            except Exception as e:
                component_server = None
                logging.error("Сервер оновлень недоступний")
                check_status = False
                cls.result_status['status'] = False
                cls.result_status['error'] = str(e)

        if check_status:
            project_folder = ''
            archive_url = component_server[0]['latest_component_data']
            version = component_server[0]['latest_version']
            try:
                response = requests.get(archive_url, stream=True)
                response.raise_for_status()

                archive_filename = "k2root.zip"
                archive_path = os.path.join(project_folder, archive_filename)

                with open(archive_path, "wb") as file:
                    for chunk in response.iter_content(chunk_size=8192):
                        file.write(chunk)
                with zipfile.ZipFile(archive_path, "r") as zip_ref:
                    # Витягування файлів без зміни шляху
                    zip_ref.extractall(project_folder)

                os.remove(archive_path)

                logging.info(f"Успішно скопійовано файли компоненти: {component_server[0]['name']} v{version}")
                event = f"Оновлення {component_server[0]['name']}"
                write_to_log_file(event)
                # reload_app_configs_del('components_bp')

                reload_app()
                K2.search_babel_translation_directories()
                if 'babel' in app.extensions:
                    app.extensions.pop('babel')
                from app import babel
                K2.load_babel_translation_directories()
                app.config['BABEL_TRANSLATION_DIRECTORIES'] = K2.babel_translation_directories
                app.config['BABEL_LANGUAGES'] = K2.languages
                app.config['BABEL_DEFAULT_TIMEZONE'] = K2.timezone
                babel.init_app(app, locale_selector=K2.get_locale,
                               default_translation_directories=K2.babel_translation_directories)
                app.register_blueprint(components_bp)
                K2Menu.add_to_menu_install('k2')
                K2().search_menu_items()
                K2().search_menu_items_category()
                K2().search_class_dict()
            except Exception as e:
                cls.result_status['status'] = False
                cls.result_status['error'] = str(e)


@socketio.on('install_components_pr')
def install_components_pr(data):
    '''встановлення компоненти'''
    # отримуємо з клієнта дані про компоненту через сокети
    session_id = request.sid
    component_id = data.get('component_id')
    component_name = data.get('component_name')
    make_migration_value = data.get('make_migration_value')
    # session_id = request.sid
    socketio.emit('update_progress', {'progress': 1, 'message': f"Встановлення {component_name} 1%",
                                      'install_message': 'Підготовка встановлення...'},  room=session_id)

    check_status = True
    try:

        socketio.emit('update_progress', {'progress': 4, 'message': f"Встановлення {component_name} 4%",
                                          'install_message': 'Отримання даних з сервера оновлення...'},  room=session_id)
        # Отримати дані компонент з сервера оновлень
        json_data = K2Upd.get_k2update_components()
        # вибіо компоненти по id
        selected_component = next((component for component in json_data if component['id'] == component_id), None)
        if selected_component is None:
            return 'Component not found'
        # selected_component_name = selected_component['name']
        archive_url = selected_component['latest_component_data']
        version = selected_component['latest_version']
    except Exception as e:
        logging.error(f"Update server is not avaible {e}")
        socketio.emit('update_progress', {'progress': 4, 'message': f"Встановлення {component_name}... помилка",
                                          'install_message': f'Помилка отримання даних з сервера оновлення...{e}',
                                          'error': f'{e}'},  room=session_id)
        check_status = False

    if check_status:
        try:
            # Створити шлях до папки компоненти згідно назви та версії
            project_folder = 'components'
            component_folder = os.path.join(project_folder)
            os.makedirs(component_folder, exist_ok=True)
            socketio.emit('update_progress', {'progress': 6, 'message': f"Встановлення {component_name} 6%",
                                              'install_message': f'Завантаження архіву  {component_name} з сервера оновлення...'},  room=session_id)
            # Завантажити архів компоненти
            response = requests.get(archive_url, stream=True)
            response.raise_for_status()
        except Exception as e:
            logging.error(f"{e}")
            socketio.emit('update_progress', {'progress': 6, 'message': f"Встановлення {component_name}... помилка",
                                              'install_message': f'Помилка завантаження архіву  {component_name} з сервера оновлення... {e}',
                                              'error': f'{e}'},  room=session_id)
            check_status = False

    if check_status:
        try:
            # Шлях до завантаженого архіву
            archive_path = os.path.join(component_folder, f"{component_name}.zip")
            # Зберегти архів на диск
            socketio.emit('update_progress', {'progress': 7, 'message': f"Встановлення {component_name} 7%",
                                              'install_message': f'Розпаковка архіву  компоненти {component_name}...'},  room=session_id)
            with open(archive_path, "wb") as file:
                for chunk in response.iter_content(chunk_size=4096):
                    file.write(chunk)
                # Розпакувати архів
            with zipfile.ZipFile(archive_path, "r") as zip_ref:
                zip_ref.extractall(component_folder)
            # Видалити архів
            os.remove(archive_path)
            # перейменувати якщо git
            # component_name = selected_component['name']
            old_folder_path = os.path.join(component_folder, component_name + ".git")
            new_folder_path = os.path.join(component_folder, component_name)
            # Перевірка наявності папки зі старою назвою
            if os.path.exists(old_folder_path) and os.path.isdir(old_folder_path):
                # Перейменування папки зі старою назвою на нову назву
                os.rename(old_folder_path, new_folder_path)
            socketio.emit('update_progress', {'progress': 8, 'message': f"Встановлення {component_name} 8%",
                                              'install_message': f'Розпаковка архіву компоненти {component_name}  завершено...'},  room=session_id)
        except Exception as e:
            logging.error(f"ChunkedEncodingError {e}")
            socketio.emit('update_progress', {'progress': 8, 'message': f"Встановлення {component_name}... помилка",
                                              'install_message': f'Помилка розпаковки архіву  {component_name} з сервера оновлення...{e}',
                                              'error': f'{e}'},  room=session_id)
            check_status = False

    if check_status:
        try:
            socketio.emit('update_progress', {'progress': 9, 'message': f"Встановлення {component_name} 9%",
                                              'install_message': f'Пошук залежних компонент для {component_name} ...'},  room=session_id)
            # Відкриття файлу requirements_components.txt для пошуку залежних компонент
            project_folder = 'components'
            requirements_file = f"components/{component_name}/reguirements-components.txt"
            component_ids = None
            if os.path.isfile(requirements_file):
                with open(requirements_file, 'r') as file:
                    component_ids = file.read().splitlines()

            try:
                # Зчитати вміст файлу YAML із списком встановлених компонент
                with open(f"{project_folder}/components.yml", 'r') as file:
                    components_data = yaml.safe_load(file)
            except FileNotFoundError as e:
                logging.error(f"Not found  {str(e)}")
            if components_data == None:
                components_data = {'components': []}
            # response = requests.get(f'{K2.update_domain}k2update/api/components')
            # json_data = response.json()
            # json_data = K2Upd.get_k2update_components()
        except Exception as e:
            logging.error(f"ChunkedEncodingError {e}")
            socketio.emit('update_progress', {'progress': 9, 'message': f"Встановлення {component_name}... помилка",
                                              'install_message': f'Помилка пошуку залежних компонент {component_name}... {e}',
                                              'error': f'{e}'},  room=session_id)
            check_status = False

    if check_status:
        progress_count = 10
        if component_ids:
            socketio.emit('update_progress',
                          {'progress': progress_count, 'message': f"Встановлення {component_name} 10%",
                           'install_message': f'Встановлення залежних компонент для {component_name} ...'},  room=session_id)
            count_component_ids = len(component_ids)
            average_component_ids = 50 // count_component_ids
            # пошук залежних компонент
            for component_req in component_ids:
                progress_count += average_component_ids
                json_data = K2Upd.get_k2update_components()
                pattern = r'^([^=]+)'
                match = re.search(pattern, component_req)
                component_name_req = match.group(1)
                selected_component = next(
                    (component for component in json_data if component['name'] == component_name_req),
                    None)
                if selected_component:
                    component_id_req = selected_component['id']
                    # перевіряємо чи компонента встановлена
                    existing_component = next(
                        (c for c in components_data['components'] if c['name'] == selected_component['name']),
                        None)
                    if not existing_component:
                        # встановлення залежностей залежних компонент
                        if check_status:
                            try:
                                # завантаження архіву залежної компоненти
                                json_data = K2Upd.get_k2update_components()
                                # вибіо компоненти по id
                                selected_component = next(
                                    (component for component in json_data if component['name'] == component_name_req),
                                    None)

                                # selected_component_name = selected_component['name']
                                archive_url = selected_component['latest_component_data']

                                project_folder = 'components'
                                component_folder = os.path.join(project_folder)
                                os.makedirs(component_folder, exist_ok=True)

                                # Завантажити архів компоненти
                                response = requests.get(archive_url, stream=True)
                                response.raise_for_status()

                                archive_path = os.path.join(component_folder, f"{component_name_req}.zip")
                                # Розпакувати архів
                                with open(archive_path, "wb") as file:
                                    for chunk in response.iter_content(chunk_size=4096):
                                        file.write(chunk)
                                with zipfile.ZipFile(archive_path, "r") as zip_ref:
                                    zip_ref.extractall(component_folder)
                                # Видалити архів
                                os.remove(archive_path)
                                # встановлення залежностей
                                K2Upd.install_requirments(component_name_req)
                                if K2Upd.result_status['status']:
                                    socketio.emit('update_progress', {'progress': f"{progress_count}",
                                                                      'message': f"Встановлення  {component_name} {progress_count}%",
                                                                      'install_message': f'Встановлення залежностей {component_name_req} ...'},  room=session_id)
                                else:
                                    check_status = False
                                    socketio.emit('update_progress', {'progress': f"{progress_count}",
                                                                      'message': f"Встановлення {component_name} {progress_count}%",
                                                                      'install_message': f'Помилка встановлення залежностей {component_name_req} ...',
                                                                      'error': K2Upd.result_status['error']},  room=session_id)
                            except Exception as e:
                                K2Upd.result_status['error'] = str(e)
                                K2Upd.result_status['status'] = False
                                logging.error(f"Error in module install_components_pr {component_name}: {str(e)}")
                                traceback.print_exc()
                                check_status = False
                                socketio.emit('update_progress', {'progress': progress_count,
                                                                  'message': f"Встановлення {component_name} {progress_count}%",
                                                                  'install_message': f'Помилка встановлення залежностей {component_name_req} ...  {e}',
                                                                  'error': K2Upd.result_status['error']},  room=session_id)
                        # встановлення, реєстрація залежних компонент
                        if check_status:
                            try:
                                K2Upd.install_components(component_id_req, component_name_req)
                                if K2Upd.result_status['status']:
                                    socketio.emit('update_progress', {'progress': f"{progress_count}",
                                                                      'message': f"Встановлення {component_name} {progress_count}%",
                                                                      'install_message': f'Копіювання файлів, реєстрація компоненти {component_name_req} ...'},  room=session_id)
                                else:
                                    check_status = False
                                    socketio.emit('update_progress', {'progress': f"{progress_count}",
                                                                      'message': f"Встановлення {component_name} {progress_count}%",
                                                                      'install_message': f'Помилка копіювання файлів, реєстрації компоненти {component_name_req} ...',
                                                                      'error': K2Upd.result_status['error']},  room=session_id)
                                    K2Upd.del_compomemts_data_yml(component_name)
                            except Exception as e:
                                K2Upd.result_status['error'] = str(e)
                                K2Upd.result_status['status'] = False
                                logging.error(f"Error in module install_components_pr 2 {component_name}: {str(e)}")
                                traceback.print_exc()
                                check_status = False
                                socketio.emit('update_progress', {'progress': progress_count,
                                                                  'message': f"Встановлення {component_name} {progress_count}%",
                                                                  'install_message': f'Помилка копіювання файлів, реєстрації компоненти  {component_name_req} ...  {e}',
                                                                  'error': K2Upd.result_status['error']
                                                                  },  room=session_id)
                                K2Upd.del_compomemts_data_yml(component_name)
                        # створення міграцій залежних компонент
                        if check_status and make_migration_value:
                            try:
                                K2Upd.make_migrations(component_name_req)
                                if K2Upd.result_status['status']:
                                    socketio.emit('update_progress', {'progress': f"{progress_count}",
                                                                      'message': f" Встановлення {component_name} {progress_count}%",
                                                                      'install_message': f'Створення міграцій бази даних {component_name_req} ...'},  room=session_id)
                                else:
                                    check_status = False
                                    socketio.emit('update_progress', {'progress': f"{progress_count}",
                                                                      'message': f"Встановлення {component_name} {progress_count}%",
                                                                      'install_message': f'Помилка створення міграцій {component_name_req} ...',
                                                                      'error': K2Upd.result_status['error'],
                                                                      'file': K2Upd.show_migrations_stderr()},  room=session_id)
                                    K2Upd.del_compomemts_data_yml(component_name)

                                if check_status:
                                    requests.get(f"{K2.domain_loc}/{component_name_req}/data-migrations")
                                    socketio.emit('update_progress', {'progress': 61,
                                                                      'message': f"Встановлення {component_name} 61%",
                                                                      'install_message': f'Залежна компонента {component_name_req} успішно встановлена ...', },  room=session_id)

                            except Exception as e:
                                K2Upd.result_status['error'] = str(e)
                                K2Upd.result_status['status'] = False
                                logging.error(f"Error in module install_components_pr 3 {component_name}: {str(e)}")
                                traceback.print_exc()
                                check_status = False
                                socketio.emit('update_progress', {'progress': 61,
                                                                  'message': f"Встановлення {component_name}... помилка",
                                                                  'install_message': f'Помилка встановлення  {component_name_req} ... ',
                                                                  'error': K2Upd.result_status['error'],
                                                                  'file': K2Upd.show_migrations_stderr()},  room=session_id)
                                K2Upd.del_compomemts_data_yml(component_name)
                    else:
                        socketio.emit('update_progress', {'progress': f"{progress_count}",
                                                          'message': f"Встановлення {component_name} {progress_count}%",
                                                          'install_message': f'{component_name_req} вже встановлено  ...'},  room=session_id)
                event = f"Install requirements components for {component_name}"
                write_to_log_file(event)
                reload_app_configs(component_name)

                # reload_app() #

        # встановлення залежностей основної компоненти
        if check_status:
            try:
                socketio.emit('update_progress', {'progress': 65,
                                                  'message': f"Встановлення {component_name} 65%",
                                                  'install_message': f'Встановлення залежностей {component_name}...'},  room=session_id)

                K2Upd.install_requirments(component_name)
                if K2Upd.result_status['status']:
                    socketio.emit('update_progress', {'progress': 75,
                                                      'message': f"Встановлення {component_name} 75%",
                                                      'install_message': f'Залежності {component_name} успішно встановлені...'},  room=session_id)
                else:
                    socketio.emit('update_progress',
                                  {'progress': 65, 'message': f"Встановлення {component_name}... помилка",
                                   'install_message': f'Помилка встановлення залежностей  {component_name}... ',
                                   'error': K2Upd.result_status['error']},  room=session_id)
                    check_status = False
            except Exception as e:
                logging.error(f"{e}")
                socketio.emit('update_progress',
                              {'progress': 65, 'message': f"Встановлення {component_name}... помилка",
                               'install_message': f'Помилка встановлення залежностей  {component_name}... {e}',
                               'error': f'{e}'},  room=session_id)
                traceback.print_exc()
                check_status = False

        # встановлення, реєстрація основної компоненти
        if check_status:
            try:
                socketio.emit('update_progress', {'progress': 76,
                                                  'message': f"Встановлення {component_name} 76%",
                                                  'install_message': f'Копіювання файлів, реєстрація компоненти, додавання пунктів меню {component_name}...'},  room=session_id)
                K2Upd.install_components(component_id, component_name)
                if K2Upd.result_status['status']:
                    socketio.emit('update_progress', {'progress': 85,
                                                      'message': f"Встановлення {component_name} 76%",
                                                      'install_message': f'Реєстрація {component_name} успішно виконана ...'},  room=session_id)
                else:
                    socketio.emit('update_progress',
                                  {'progress': 76, 'message': f"Встановлення {component_name}... помилка",
                                   'install_message': f"Помилка копіювання файлів {component_name}...",
                                   'error': K2Upd.result_status['error']},  room=session_id)

                    check_status = False
            except Exception as e:
                socketio.emit('update_progress',
                              {'progress': 76, 'message': f"Встановлення {component_name}... помилка",
                               'install_message': f'Помилка копіювання файлів {component_name}... {e}',
                               'error': f'{e}'},  room=session_id)
                traceback.print_exc()
                check_status = False

        # створення міграцій основної компоненти
        if check_status and make_migration_value:
            try:
                socketio.emit('update_progress', {'progress': 86,
                                                  'message': f"Встановлення {component_name} 86%",
                                                  'install_message': f'Створення міграцій бази даних компоненти {component_name}...'},  room=session_id)
                K2Upd.make_migrations(component_name)
                if K2Upd.result_status['status']:
                    socketio.emit('update_progress', {'progress': 96,
                                                      'message': f"Встановлення {component_name} 96%",
                                                      'install_message': f'Міграції бази даних компоненти {component_name} успішно виконані ...'},  room=session_id)
                else:
                    socketio.emit('update_progress',
                                  {'progress': 97, 'message': f"Встановлення {component_name}... помилка",
                                   'install_message': f'Помилка створення міграцій бази даних компоненти {component_name}...',
                                   'error': K2Upd.result_status['error'],
                                   'file': K2Upd.show_migrations_stderr()},  room=session_id)
                    check_status = False
            except Exception as e:
                socketio.emit('update_progress',
                              {'progress': 97, 'message': f"Встановлення {component_name}... помилка",
                               'install_message': f'Помилка створення міграцій бази даних компоненти  {component_name}...',
                               'error': f'{e}',
                               'file': K2Upd.show_migrations_stderr()},  room=session_id)
                traceback.print_exc()
                check_status = False

        event = f"Install component {component_name} "
        write_to_log_file(event)
        reload_app_configs(component_name)
        if check_status:
            socketio.emit('update_progress',
                          {'progress': 100, 'message': f"Встановлено {component_name} 100%",
                           'install_message': f'{component_name} встановлено...'},  room=session_id)
        else:
            socketio.emit('update_progress',
                          {'progress': 97, 'message': f"Встановлено {component_name} 97%",
                           'install_message': f'Помилка встановлення {component_name}...'},  room=session_id)


@socketio.on('install_components_php')
def install_components_php(data):
    '''встановлення компоненти'''
    # отримуємо з клієнта дані про компоненту через сокети
    session_id = request.sid
    component_id = data.get('component_id')
    component_name = data.get('component_name')
    make_migration_value = data.get('make_migration_value')
    # session_id = request.sid
    socketio.emit('update_progress', {'progress': 1, 'message': f"Встановлення {component_name} 1%",
                                      'install_message': 'Підготовка встановлення...'},  room=session_id)

    check_status = True
    try:
        # session_id = request.sid
        socketio.emit('update_progress', {'progress': 4, 'message': f"Встановлення {component_name} 4%",
                                          'install_message': 'Отримання даних з сервера оновлення...'},  room=session_id)
        # Отримати дані компонент з сервера оновлень
        json_data = K2Upd.get_k2update_components()
        # вибіо компоненти по id
        selected_component = next((component for component in json_data if component['id'] == component_id), None)
        if selected_component is None:
            return 'Component not found'
        # selected_component_name = selected_component['name']
        archive_url = selected_component['latest_component_data']
        version = selected_component['latest_version']
    except Exception as e:
        logging.error(f"Update server is not avaible {e}")
        socketio.emit('update_progress', {'progress': 4, 'message': f"Встановлення {component_name}... помилка",
                                          'install_message': f'Помилка отримання даних з сервера оновлення...{e}',
                                          'error': f'{e}'},  room=session_id)
        check_status = False

    if check_status:
        try:
            # Створити шлях до папки компоненти згідно назви
            project_folder = '../web'
            component_folder = os.path.join(project_folder)
            os.makedirs(component_folder, exist_ok=True)
            socketio.emit('update_progress', {'progress': 6, 'message': f"Встановлення {component_name} 6%",
                                              'install_message': f'Отримання архіву  {component_name} з сервера оновлення...'},  room=session_id)
            # Завантажити архів компоненти
            response = requests.get(archive_url, stream=True)
            response.raise_for_status()
        except Exception as e:
            logging.error(f"{e}")
            socketio.emit('update_progress', {'progress': 6, 'message': f"Встановлення {component_name}... помилка",
                                              'install_message': f'Помилка завантаження архіву  {component_name} з сервера оновлення... {e}',
                                              'error': f'{e}'},  room=session_id)
            check_status = False

    if check_status:
        try:
            # Шлях до завантаженого архіву
            archive_path = os.path.join(component_folder, f"{component_name}.zip")
            # Зберегти архів на диск

            # with open(archive_path, "wb") as file:
            #     for chunk in response.iter_content(chunk_size=4096):
            #         file.write(chunk)
            from tqdm import tqdm
            total_size = int(response.headers.get('content-length', 0))
            socketio.emit('update_progress', {'progress': 10,
                                              'message': f"Встановлення {component_name} 10%",
                                              'install_message': f'Завантаження архіву компоненти {component_name}...'},  room=session_id)

            with open(archive_path, "wb") as file, tqdm(
                    desc="Завантаження архіву",
                    total=total_size,
                    unit="B",
                    unit_scale=True,
                    unit_divisor=1024,
                    bar_format='{percentage:3.0f}%'

            ) as bar:
                for chunk in response.iter_content(chunk_size=4096):
                    file.write(chunk)
                    bar.update(len(chunk))
                    if bar.n % 100000 == 0:
                        socketio.emit('update_progress', {'progress': 15,
                                                          'message': f"Встановлення {component_name} 15%",
                                                          'install_message': f'Завантаження архіву компоненти {component_name}...{bar}'},  room=session_id)

            socketio.emit('update_progress', {'progress': 50, 'message': f"Встановлення {component_name} 50%",
                                              'install_message': f'Розпаковка архіву  компоненти {component_name}...'},  room=session_id)

            K2Upd.extract_archive(archive_path, component_folder)
            # Видалити архів
            os.remove(archive_path)
            # перейменувати якщо git
            # component_name = selected_component['name']
            old_folder_path = os.path.join(component_folder, component_name + ".git")
            new_folder_path = os.path.join(component_folder, component_name)
            # Перевірка наявності папки зі старою назвою
            if os.path.exists(old_folder_path) and os.path.isdir(old_folder_path):
                # Перейменування папки зі старою назвою на нову назву
                os.rename(old_folder_path, new_folder_path)
            socketio.emit('update_progress', {'progress': 52, 'message': f"Встановлення {component_name} 52%",
                                              'install_message': f'Розпаковка архіву компоненти {component_name}  завершено...'},  room=session_id)
        except Exception as e:
            logging.error(f"ChunkedEncodingError {e}")
            socketio.emit('update_progress', {'progress': 52, 'message': f"Встановлення {component_name}... помилка",
                                              'install_message': f'Помилка розпаковки архіву  {component_name} з сервера оновлення...{e}',
                                              'error': f'{e}'},  room=session_id)
            check_status = False

    # копіювання файлів php компоненти
    if check_status:
        try:
            socketio.emit('update_progress', {'progress': 52,
                                              'message': f"Встановлення {component_name} 52%",
                                              'install_message': f'Копіювання файлів, реєстрація компоненти, додавання пунктів меню {component_name}...'},  room=session_id)
            K2Upd.install_components_php(component_id, component_name)
            if K2Upd.result_status['status']:
                socketio.emit('update_progress', {'progress': 55,
                                                  'message': f"Встановлення {component_name} 55%",
                                                  'install_message': f'Реєстрація {component_name} успішно виконана ...'},  room=session_id)
            else:
                socketio.emit('update_progress',
                              {'progress': 55, 'message': f"Встановлення {component_name}... помилка",
                               'install_message': f"Помилка копіювання файлів {component_name}...",
                               'error': K2Upd.result_status['error']},  room=session_id)

                check_status = False
        except Exception as e:
            socketio.emit('update_progress',
                          {'progress': 55, 'message': f"Встановлення {component_name}... помилка",
                           'install_message': f'Помилка копіювання файлів {component_name}... {e}',
                           'error': f'{e}'},  room=session_id)
            check_status = False

    # створення міграцій php компоненти
    if check_status and make_migration_value:
        try:
            socketio.emit('update_progress', {'progress': 65,
                                              'message': f"Встановлення {component_name} 65%",
                                              'install_message': f'Створення міграцій бази даних компоненти {component_name}...'},  room=session_id)
            K2Upd.make_migrations(component_name)
            if K2Upd.result_status['status']:
                socketio.emit('update_progress', {'progress': 85,
                                                  'message': f"Встановлення {component_name} 96%",
                                                  'install_message': f'Міграції бази даних компоненти {component_name} успішно виконані ...'},  room=session_id)
            else:
                socketio.emit('update_progress',
                              {'progress': 65, 'message': f"Встановлення {component_name}... помилка",
                               'install_message': f'Помилка створення міграцій бази даних компоненти {component_name}...',
                               'error': K2Upd.result_status['error'],
                               'file': K2Upd.show_migrations_stderr()},  room=session_id)
                check_status = False
        except Exception as e:
            socketio.emit('update_progress',
                          {'progress': 65, 'message': f"Встановлення {component_name}... помилка",
                           'install_message': f'Помилка створення міграцій бази даних компоненти  {component_name}...',
                           'error': f'{e}',
                           'file': K2Upd.show_migrations_stderr()},  room=session_id)
            check_status = False

    event = f"Install component {component_name} "
    write_to_log_file(event)
    reload_app_configs(component_name)
    if check_status:
        socketio.emit('update_progress',
                      {'progress': 100, 'message': f"Встановлено {component_name} 100%",
                       'install_message': f'{component_name} встановлено...'},  room=session_id)
    else:
        socketio.emit('update_progress',
                      {'progress': 65, 'message': f"Встановлено {component_name} 97%",
                       'install_message': f'Помилка встановлення {component_name}...'},  room=session_id)


@socketio.on('update_components_pr')
def update_components_pr(data):
    '''оновлення компоненти'''
    # отримуємо з клієнта дані про компоненту через сокети
    session_id = request.sid
    component_id = data.get('component_id')
    component_name = data.get('component_name')
    make_migration_value = data.get('make_migration_value')
    socketio.emit('update_progress', {'progress': 1, 'message': f"Оновлення {component_name} 1%",
                                      'install_message': 'Підготовка оновлення...'}, room=session_id)

    check_status = True
    try:
        socketio.emit('update_progress', {'progress': 4, 'message': f"Оновлення {component_name} 4%",
                                          'install_message': 'Отримання даних з сервера оновлення...'}, room=session_id)
        # Отримати дані компонент з сервера оновлень
        json_data = K2Upd.get_k2update_components()
        # вибіо компоненти по id
        selected_component = next((component for component in json_data if component['id'] == component_id), None)
        if selected_component is None:
            return 'Component not found'
        # selected_component_name = selected_component['name']
        archive_url = selected_component['latest_component_data']
        version = selected_component['latest_version']
    except Exception as e:
        logging.error(f"Update server is not avaible {e}")
        socketio.emit('update_progress', {'progress': 4, 'message': f"Оновлення {component_name}... помилка",
                                          'install_message': f'Помилка отримання даних з сервера оновлення...{e}',
                                          'error': f'{e}'}, room=session_id)
        traceback.print_exc()
        check_status = False

    if check_status:
        try:
            # Створити шлях до папки компоненти згідно назви та версії
            project_folder = 'components'
            component_folder = os.path.join(project_folder)
            os.makedirs(component_folder, exist_ok=True)
            socketio.emit('update_progress', {'progress': 9, 'message': f"Оновлення {component_name} 9%",
                                              'install_message': f'Завантаження архіву  {component_name} з сервера оновлення...'},
                          room=session_id)
            # Завантажити архів компоненти
            response = requests.get(archive_url, stream=True)
            response.raise_for_status()
        except Exception as e:
            logging.error(f"{e}")
            socketio.emit('update_progress', {'progress': 9, 'message': f"Оновлення {component_name}... помилка",
                                              'install_message': f'Помилка завантаження архіву  {component_name} з сервера оновлення... {e}',
                                              'error': f'{e}'}, room=session_id)
            traceback.print_exc()
            check_status = False

    if check_status:
        try:
            # Шлях до завантаженого архіву
            archive_path = os.path.join(component_folder, f"{component_name}.zip")
            # Видалення всіх файлів та папок у папці static
            static_folder = os.path.join(component_folder, component_name, component_name, 'static')
            # print(static_folder)
            if os.path.exists(static_folder) and os.path.isdir(static_folder):
                try:
                    shutil.rmtree(static_folder)
                except Exception as e:
                    logging.error(f"Error deleting static folder {static_folder}: {str(e)}")

            # Зберегти архів на диск
            socketio.emit('update_progress', {'progress': 12, 'message': f"Оновлення {component_name} 12%",
                                              'install_message': f'Розпаковка архіву  компоненти {component_name}...'},
                          room=session_id)
            with open(archive_path, "wb") as file:
                for chunk in response.iter_content(chunk_size=4096):
                    file.write(chunk)
                # Розпакувати архів
            with zipfile.ZipFile(archive_path, "r") as zip_ref:
                zip_ref.extractall(component_folder)
            # Видалити архів
            os.remove(archive_path)
            # перейменувати якщо git
            # component_name = selected_component['name']
            old_folder_path = os.path.join(component_folder, component_name + ".git")
            new_folder_path = os.path.join(component_folder, component_name)
            # Перевірка наявності папки зі старою назвою
            if os.path.exists(old_folder_path) and os.path.isdir(old_folder_path):
                # Перейменування папки зі старою назвою на нову назву
                os.rename(old_folder_path, new_folder_path)
            socketio.emit('update_progress', {'progress': 14, 'message': f"Оновлення {component_name} 14%",
                                              'install_message': f'Розпаковка архіву компоненти {component_name}  завершено...'},
                          room=session_id)
        except Exception as e:
            logging.error(f"ChunkedEncodingError {e}")
            socketio.emit('update_progress', {'progress': 14, 'message': f"Оновлення {component_name}... помилка",
                                              'install_message': f'Помилка розпаковки архіву  {component_name} з сервера оновлення...{e}',
                                              'error': f'{e}'}, room=session_id)
            traceback.print_exc()
            check_status = False

    if check_status:
        try:
            socketio.emit('update_progress', {'progress': 15, 'message': f"Оновлення {component_name} 15%",
                                              'install_message': f'Пошук залежних компонент для {component_name} ...'},
                          room=session_id)
            # Відкриття файлу requirements_components.txt для пошуку залежних компонент
            project_folder = 'components'
            requirements_file = f"components/{component_name}/reguirements-components.txt"
            component_ids = None
            if os.path.isfile(requirements_file):
                with open(requirements_file, 'r') as file:
                    component_ids = file.read().splitlines()
            try:
                # Зчитати вміст файлу YAML із списком встановлених компонент
                with open(f"{project_folder}/components.yml", 'r') as file:
                    components_data = yaml.safe_load(file)
            except FileNotFoundError as e:
                logging.error(f"Not found  {str(e)}")
                traceback.print_exc()
            if components_data == None:
                components_data = {'components': []}
            # response = requests.get(f'{K2.update_domain}k2update/api/components')
            # json_data = response.json()
            # json_data = K2Upd.get_k2update_components()
        except Exception as e:
            logging.error(f"ChunkedEncodingError {e}")
            socketio.emit('update_progress', {'progress': 15, 'message': f"Оновлення {component_name}... помилка",
                                              'install_message': f'Помилка пошуку залежних компонент {component_name}... {e}',
                                              'error': f'{e}'}, room=session_id)
            traceback.print_exc()
            check_status = False

    # оновлення залежних компонент
    if check_status:
        progress_count = 16
        if component_ids:
            socketio.emit('update_progress', {'progress': progress_count, 'message': f"Оновлення {component_name} 10%",
                                              'install_message': f'Оновлення залежних компонент для {component_name} ...'},
                          room=session_id)
            count_component_ids = len(component_ids)
            average_component_ids = 50 // count_component_ids
            # пошук залежних компонент
            for component_req in component_ids:
                progress_count += average_component_ids
                json_data = K2Upd.get_k2update_components()
                pattern = r'^([^=<>]+)([=<>]+)(.+)'

                match = re.search(pattern, component_req)
                component_name_req = match.group(1)
                comparison_operator = match.group(2)
                version_req = match.group(3)

                selected_component = next(
                    (component for component in json_data if component['name'] == component_name_req),
                    None)
                if selected_component:
                    component_id_req = selected_component['id']
                    # перевіряємо чи компонента встановлена
                    try:
                        existing_component = next(
                            (c for c in components_data['components']
                             if c['name'] == selected_component['name'] and K2.compare_versions(version_req,
                                                                                                c['version']) == 1),
                            None)
                    except Exception as e:
                        existing_component = None
                        traceback.print_exc()
                        logging.error(f'Error compare_versions {e}')
                    if existing_component:
                        # Оновлення залежностей залежних компонент
                        if check_status:
                            try:
                                # завантаження архіву залежної компоненти
                                json_data = K2Upd.get_k2update_components()
                                # вибіо компоненти по id
                                selected_component = next(
                                    (component for component in json_data if component['name'] == component_name_req),
                                    None)

                                # selected_component_name = selected_component['name']
                                archive_url = selected_component['latest_component_data']

                                project_folder = 'components'
                                component_folder = os.path.join(project_folder)
                                os.makedirs(component_folder, exist_ok=True)

                                # Завантажити архів компоненти
                                response = requests.get(archive_url, stream=True)
                                response.raise_for_status()

                                archive_path = os.path.join(component_folder, f"{component_name_req}.zip")
                                # Розпакувати архів
                                with open(archive_path, "wb") as file:
                                    for chunk in response.iter_content(chunk_size=4096):
                                        file.write(chunk)
                                with zipfile.ZipFile(archive_path, "r") as zip_ref:
                                    zip_ref.extractall(component_folder)
                                # Видалити архів
                                os.remove(archive_path)
                                # встановлення залежностей
                                K2Upd.install_requirments(component_name_req)
                                if K2Upd.result_status['status']:
                                    socketio.emit('update_progress', {'progress': f"{progress_count}",
                                                                      'message': f"Оновлення  {component_name} {progress_count}%",
                                                                      'install_message': f'Оновлення залежностей {component_name_req} ...'},
                                                  room=session_id)
                                else:
                                    check_status = False
                                    socketio.emit('update_progress', {'progress': f"{progress_count}",
                                                                      'message': f"Оновлення {component_name} {progress_count}%",
                                                                      'install_message': f'Помилка оновлення залежностей {component_name_req} ...',
                                                                      'error': K2Upd.result_status['error']},
                                                  room=session_id)
                            except Exception as e:
                                K2Upd.result_status['error'] = str(e)
                                K2Upd.result_status['status'] = False
                                logging.error(f"Error inmodule install_components_pr 4 {component_name}: {str(e)}")
                                check_status = False
                                traceback.print_exc()
                                socketio.emit('update_progress', {'progress': progress_count,
                                                                  'message': f"Оновлення {component_name} {progress_count}%",
                                                                  'install_message': f'Помилка оновлення залежностей {component_name_req} ...  {e}',
                                                                  'error': K2Upd.result_status['error']},
                                              room=session_id)
                        # Оновлення, реєстрація залежних компонент
                        if check_status:
                            try:
                                K2Upd.install_components(component_id_req, component_name_req)
                                if K2Upd.result_status['status']:
                                    socketio.emit('update_progress', {'progress': f"{progress_count}",
                                                                      'message': f"Оновлення {component_name} {progress_count}%",
                                                                      'install_message': f'Копіювання файлів, оновлення компоненти {component_name_req} ...'},
                                                  room=session_id)
                                else:
                                    check_status = False
                                    socketio.emit('update_progress', {'progress': f"{progress_count}",
                                                                      'message': f"Оновлення {component_name} {progress_count}%",
                                                                      'install_message': f'Помилка копіювання файлів, реєстрації компоненти {component_name_req} ...',
                                                                      'error': K2Upd.result_status['error']},
                                                  room=session_id)
                                    K2Upd.del_compomemts_data_yml(component_name)
                            except Exception as e:
                                K2Upd.result_status['error'] = str(e)
                                K2Upd.result_status['status'] = False
                                logging.error(f"Error in module install_components_pr 5 {component_name}: {str(e)}")
                                check_status = False
                                traceback.print_exc()
                                socketio.emit('update_progress', {'progress': progress_count,
                                                                  'message': f"Оновлення {component_name} {progress_count}%",
                                                                  'install_message': f'Помилка копіювання файлів, реєстрації компоненти  {component_name_req} ...  {e}',
                                                                  'error': K2Upd.result_status['error']
                                                                  }, room=session_id)
                                K2Upd.del_compomemts_data_yml(component_name)
                        # створення міграцій залежних компонент
                        if check_status and make_migration_value:
                            try:
                                K2Upd.make_migrations(component_name_req)
                                if K2Upd.result_status['status']:
                                    socketio.emit('update_progress', {'progress': f"{progress_count}",
                                                                      'message': f" Оновлення {component_name} {progress_count}%",
                                                                      'install_message': f'Створення міграцій бази даних {component_name_req} ...'},
                                                  room=session_id)
                                else:
                                    check_status = False
                                    socketio.emit('update_progress', {'progress': f"{progress_count}",
                                                                      'message': f"Оновлення {component_name} {progress_count}%",
                                                                      'install_message': f'Помилка створення міграцій {component_name_req} ...',
                                                                      'error': K2Upd.result_status['error'],
                                                                      'file': K2Upd.show_migrations_stderr()},
                                                  room=session_id)
                                    K2Upd.del_compomemts_data_yml(component_name)

                                if check_status:
                                    requests.get(f"{K2.domain_loc}/{component_name_req}/data-migrations")
                                    socketio.emit('update_progress', {'progress': 61,
                                                                      'message': f"Встановлення {component_name} 61%",
                                                                      'install_message': f'Залежна компонента {component_name_req} успішно встановлена ...', },
                                                  room=session_id)

                            except Exception as e:
                                K2Upd.result_status['error'] = str(e)
                                K2Upd.result_status['status'] = False
                                logging.error(f"Error in module install_components_pr 6{component_name}: {str(e)}")
                                check_status = False
                                traceback.print_exc()
                                socketio.emit('update_progress', {'progress': 61,
                                                                  'message': f"Оновлення {component_name}... помилка",
                                                                  'install_message': f'Помилка оновлення  {component_name_req} ... ',
                                                                  'error': K2Upd.result_status['error'],
                                                                  'file': K2Upd.show_migrations_stderr()},
                                              room=session_id)
                                K2Upd.del_compomemts_data_yml(component_name)
                    else:
                        socketio.emit('update_progress', {'progress': f"{progress_count}",
                                                          'message': f"Оновлення {component_name} {progress_count}%",
                                                          'install_message': f'{component_name_req} вже встановлено  ...'},
                                      room=session_id)
                check_status = True
                event = f"Install requirements components for {component_name}"
                write_to_log_file(event)
                reload_app_configs(component_name)

                #reload_app()

    if check_status:

        # встановлення залежностей основної компоненти
        if check_status:
            try:
                socketio.emit('update_progress', {'progress': 65,
                                                  'message': f"Оновлення {component_name} 45%",
                                                  'install_message': f'Встановлення залежностей {component_name}...'},
                              room=session_id)

                K2Upd.install_requirments(component_name)
                if K2Upd.result_status['status']:
                    socketio.emit('update_progress', {'progress': 65,
                                                      'message': f"Оновлення {component_name} 65%",
                                                      'install_message': f'Залежності {component_name} успішно встановлені...'},
                                  room=session_id)
                else:
                    socketio.emit('update_progress',
                                  {'progress': 65, 'message': f"Оновлення {component_name}... помилка",
                                   'install_message': f'Помилка оновлення залежностей  {component_name}... ',
                                   'error': K2Upd.result_status['error']}, room=session_id)
                    K2Upd.del_compomemts_data_yml(component_name)
                    check_status = False
            except Exception as e:
                logging.error(f"{e}")
                socketio.emit('update_progress',
                              {'progress': 65, 'message': f"Оновлення {component_name}... помилка",
                               'install_message': f'Помилка оновлення залежностей  {component_name}... {e}',
                               'error': f'{e}'}, room=session_id)
                K2Upd.del_compomemts_data_yml(component_name)
                traceback.print_exc()
                check_status = False

        # встановлення, реєстрація основної компоненти
        if check_status:
            try:
                socketio.emit('update_progress', {'progress': 70,
                                                  'message': f"Оновлення {component_name} 70%",
                                                  'install_message': f'Копіювання файлів, реєстрація компоненти, додавання пунктів меню {component_name}...'},
                              room=session_id)
                K2Upd.install_components(component_id, component_name)
                if K2Upd.result_status['status']:
                    socketio.emit('update_progress', {'progress': 85,
                                                      'message': f"Оновлення {component_name} 85%",
                                                      'install_message': f'Реєстрація {component_name} успішно виконана ...'},
                                  room=session_id)
                else:
                    socketio.emit('update_progress',
                                  {'progress': 70, 'message': f"Встановлення {component_name}... помилка",
                                   'install_message': f"Помилка копіювання файлів {component_name}...",
                                   'error': K2Upd.result_status['error']}, room=session_id)
                    K2Upd.del_compomemts_data_yml(component_name)
                    check_status = False
            except Exception as e:
                socketio.emit('update_progress',
                              {'progress': 70, 'message': f"Встановлення {component_name}... помилка",
                               'install_message': f'Помилка копіювання файлів {component_name}... {e}',
                               'error': f'{e}'}, room=session_id)
                K2Upd.del_compomemts_data_yml(component_name)
                traceback.print_exc()
                check_status = False

        # створення міграцій основної компоненти
        if check_status and make_migration_value:
            try:
                socketio.emit('update_progress', {'progress': 86,
                                                  'message': f"Оновлення {component_name} 86%",
                                                  'install_message': f'Створення міграцій бази даних компоненти {component_name}...'},
                              room=session_id)
                try:
                    K2Upd.make_migrations(component_name)
                except Exception as e:
                    check_status = False

                if K2Upd.result_status['status']:
                    socketio.emit('update_progress', {'progress': 96,
                                                      'message': f"Оновлення {component_name} 96%",
                                                      'install_message': f'Міграції бази даних компоненти {component_name} успішно виконані ...'},
                                  room=session_id)
                else:
                    socketio.emit('update_progress',
                                  {'progress': 97, 'message': f"Оновлення {component_name}... помилка",
                                   'install_message': f'Помилка створення міграцій бази даних компоненти {component_name}...',
                                   'error': K2Upd.result_status['error'],
                                   'file': K2Upd.show_migrations_stderr()}, room=session_id)
                    check_status = False
                    K2Upd.del_compomemts_data_yml(component_name)
            except Exception as e:
                socketio.emit('update_progress',
                              {'progress': 97, 'message': f"Оновлення {component_name}... помилка",
                               'install_message': f'Помилка створення міграцій бази даних компоненти  {component_name}...',
                               'error': f'{e}',
                               'file': K2Upd.show_migrations_stderr()}, room=session_id)
                traceback.print_exc()
                K2Upd.del_compomemts_data_yml(component_name)
                check_status = False

        event = f"Install component {component_name} "
        write_to_log_file(event)
        reload_app_configs(component_name)
        if check_status:
            socketio.emit('update_progress',
                          {'progress': 100, 'message': f"Оновлено {component_name} 100%",
                           'install_message': f'{component_name} оновлено...'}, room=session_id)


@socketio.on('update_components_beta')
def update_components_beta(data):
    '''оновлення компоненти'''
    # отримуємо з клієнта дані про компоненту через сокети
    session_id = request.sid
    component_id = data.get('component_id')
    component_name = data.get('component_name')
    make_migration_value = data.get('make_migration_value')
    socketio.emit('update_progress', {'progress': 1, 'message': f"Оновлення {component_name} 1%",
                                      'install_message': 'Підготовка оновлення...'}, room=session_id)

    check_status = True
    try:
        socketio.emit('update_progress', {'progress': 4, 'message': f"Оновлення {component_name} 4%",
                                          'install_message': 'Отримання даних з сервера оновлення...'}, room=session_id)
        # Отримати дані компонент з сервера оновлень
        json_data = K2Upd.get_k2update_components_beta()
        # вибіо компоненти по id
        selected_component = next((component for component in json_data if component['id'] == component_id), None)
        if selected_component is None:
            return 'Component not found'
        # selected_component_name = selected_component['name']
        archive_url = selected_component['latest_component_data']
        version = selected_component['latest_version']
    except Exception as e:
        logging.error(f"Update server is not avaible {e}")
        socketio.emit('update_progress', {'progress': 4, 'message': f"Оновлення {component_name}... помилка",
                                          'install_message': f'Помилка отримання даних з сервера оновлення...{e}',
                                          'error': f'{e}'}, room=session_id)
        traceback.print_exc()
        check_status = False

    if check_status:
        try:
            # Створити шлях до папки компоненти згідно назви та версії
            project_folder = 'components'
            component_folder = os.path.join(project_folder)
            os.makedirs(component_folder, exist_ok=True)
            socketio.emit('update_progress', {'progress': 9, 'message': f"Оновлення {component_name} 9%",
                                              'install_message': f'Завантаження архіву  {component_name} з сервера оновлення...'},
                          room=session_id)
            # Завантажити архів компоненти
            response = requests.get(archive_url, stream=True)
            response.raise_for_status()
        except Exception as e:
            logging.error(f"{e}")
            socketio.emit('update_progress', {'progress': 9, 'message': f"Оновлення {component_name}... помилка",
                                              'install_message': f'Помилка завантаження архіву  {component_name} з сервера оновлення... {e}',
                                              'error': f'{e}'}, room=session_id)
            traceback.print_exc()
            check_status = False

    if check_status:
        try:
            # Шлях до завантаженого архіву
            archive_path = os.path.join(component_folder, f"{component_name}.zip")
            # Видалення всіх файлів та папок у папці static
            static_folder = os.path.join(component_folder, component_name, component_name, 'static')
            # print(static_folder)
            if os.path.exists(static_folder) and os.path.isdir(static_folder):
                try:
                    shutil.rmtree(static_folder)
                except Exception as e:
                    logging.error(f"Error deleting static folder {static_folder}: {str(e)}")

            # Зберегти архів на диск
            socketio.emit('update_progress', {'progress': 12, 'message': f"Оновлення {component_name} 12%",
                                              'install_message': f'Розпаковка архіву  компоненти {component_name}...'},
                          room=session_id)
            with open(archive_path, "wb") as file:
                for chunk in response.iter_content(chunk_size=4096):
                    file.write(chunk)
                # Розпакувати архів
            with zipfile.ZipFile(archive_path, "r") as zip_ref:
                zip_ref.extractall(component_folder)
            # Видалити архів
            os.remove(archive_path)
            # перейменувати якщо git
            # component_name = selected_component['name']
            old_folder_path = os.path.join(component_folder, component_name + ".git")
            new_folder_path = os.path.join(component_folder, component_name)
            # Перевірка наявності папки зі старою назвою
            if os.path.exists(old_folder_path) and os.path.isdir(old_folder_path):
                # Перейменування папки зі старою назвою на нову назву
                os.rename(old_folder_path, new_folder_path)
            socketio.emit('update_progress', {'progress': 14, 'message': f"Оновлення {component_name} 14%",
                                              'install_message': f'Розпаковка архіву компоненти {component_name}  завершено...'},
                          room=session_id)
        except Exception as e:
            logging.error(f"ChunkedEncodingError {e}")
            socketio.emit('update_progress', {'progress': 14, 'message': f"Оновлення {component_name}... помилка",
                                              'install_message': f'Помилка розпаковки архіву  {component_name} з сервера оновлення...{e}',
                                              'error': f'{e}'}, room=session_id)
            traceback.print_exc()
            check_status = False

    if check_status:
        try:
            socketio.emit('update_progress', {'progress': 15, 'message': f"Оновлення {component_name} 15%",
                                              'install_message': f'Пошук залежних компонент для {component_name} ...'},
                          room=session_id)
            # Відкриття файлу requirements_components.txt для пошуку залежних компонент
            project_folder = 'components'
            requirements_file = f"components/{component_name}/reguirements-components.txt"
            component_ids = None
            if os.path.isfile(requirements_file):
                with open(requirements_file, 'r') as file:
                    component_ids = file.read().splitlines()
            try:
                # Зчитати вміст файлу YAML із списком встановлених компонент
                with open(f"{project_folder}/components.yml", 'r') as file:
                    components_data = yaml.safe_load(file)
            except FileNotFoundError as e:
                logging.error(f"Not found  {str(e)}")
                traceback.print_exc()
            if components_data == None:
                components_data = {'components': []}
            # response = requests.get(f'{K2.update_domain}k2update/api/components')
            # json_data = response.json()
            # json_data = K2Upd.get_k2update_components()
        except Exception as e:
            logging.error(f"ChunkedEncodingError {e}")
            socketio.emit('update_progress', {'progress': 15, 'message': f"Оновлення {component_name}... помилка",
                                              'install_message': f'Помилка пошуку залежних компонент {component_name}... {e}',
                                              'error': f'{e}'}, room=session_id)
            traceback.print_exc()
            check_status = False

    # оновлення залежних компонент
    if check_status:
        progress_count = 16
        if component_ids:
            socketio.emit('update_progress', {'progress': progress_count, 'message': f"Оновлення {component_name} 10%",
                                              'install_message': f'Оновлення залежних компонент для {component_name} ...'},
                          room=session_id)
            count_component_ids = len(component_ids)
            average_component_ids = 50 // count_component_ids
            # пошук залежних компонент
            for component_req in component_ids:
                progress_count += average_component_ids
                json_data = K2Upd.get_k2update_components()
                pattern = r'^([^=<>]+)([=<>]+)(.+)'

                match = re.search(pattern, component_req)
                component_name_req = match.group(1)
                comparison_operator = match.group(2)
                version_req = match.group(3)

                selected_component = next(
                    (component for component in json_data if component['name'] == component_name_req),
                    None)
                if selected_component:
                    component_id_req = selected_component['id']
                    # перевіряємо чи компонента встановлена
                    try:
                        existing_component = next(
                            (c for c in components_data['components']
                             if c['name'] == selected_component['name'] and K2.compare_versions(version_req,
                                                                                                c['version']) == 1),
                            None)
                    except Exception as e:
                        existing_component = None
                        traceback.print_exc()
                        logging.error(f'Error compare_versions {e}')
                    if existing_component:
                        # Оновлення залежностей залежних компонент
                        if check_status:
                            try:
                                # завантаження архіву залежної компоненти
                                json_data = K2Upd.get_k2update_components()
                                # вибіо компоненти по id
                                selected_component = next(
                                    (component for component in json_data if component['name'] == component_name_req),
                                    None)

                                # selected_component_name = selected_component['name']
                                archive_url = selected_component['latest_component_data']

                                project_folder = 'components'
                                component_folder = os.path.join(project_folder)
                                os.makedirs(component_folder, exist_ok=True)

                                # Завантажити архів компоненти
                                response = requests.get(archive_url, stream=True)
                                response.raise_for_status()

                                archive_path = os.path.join(component_folder, f"{component_name_req}.zip")
                                # Розпакувати архів
                                with open(archive_path, "wb") as file:
                                    for chunk in response.iter_content(chunk_size=4096):
                                        file.write(chunk)
                                with zipfile.ZipFile(archive_path, "r") as zip_ref:
                                    zip_ref.extractall(component_folder)
                                # Видалити архів
                                os.remove(archive_path)
                                # встановлення залежностей
                                K2Upd.install_requirments(component_name_req)
                                if K2Upd.result_status['status']:
                                    socketio.emit('update_progress', {'progress': f"{progress_count}",
                                                                      'message': f"Оновлення  {component_name} {progress_count}%",
                                                                      'install_message': f'Оновлення залежностей {component_name_req} ...'},
                                                  room=session_id)
                                else:
                                    check_status = False
                                    socketio.emit('update_progress', {'progress': f"{progress_count}",
                                                                      'message': f"Оновлення {component_name} {progress_count}%",
                                                                      'install_message': f'Помилка оновлення залежностей {component_name_req} ...',
                                                                      'error': K2Upd.result_status['error']},
                                                  room=session_id)
                            except Exception as e:
                                K2Upd.result_status['error'] = str(e)
                                K2Upd.result_status['status'] = False
                                logging.error(f"Error inmodule install_components_pr 4 {component_name}: {str(e)}")
                                check_status = False
                                traceback.print_exc()
                                socketio.emit('update_progress', {'progress': progress_count,
                                                                  'message': f"Оновлення {component_name} {progress_count}%",
                                                                  'install_message': f'Помилка оновлення залежностей {component_name_req} ...  {e}',
                                                                  'error': K2Upd.result_status['error']},
                                              room=session_id)
                        # Оновлення, реєстрація залежних компонент
                        if check_status:
                            try:
                                K2Upd.install_components(component_id_req, component_name_req)
                                if K2Upd.result_status['status']:
                                    socketio.emit('update_progress', {'progress': f"{progress_count}",
                                                                      'message': f"Оновлення {component_name} {progress_count}%",
                                                                      'install_message': f'Копіювання файлів, оновлення компоненти {component_name_req} ...'},
                                                  room=session_id)
                                else:
                                    check_status = False
                                    socketio.emit('update_progress', {'progress': f"{progress_count}",
                                                                      'message': f"Оновлення {component_name} {progress_count}%",
                                                                      'install_message': f'Помилка копіювання файлів, реєстрації компоненти {component_name_req} ...',
                                                                      'error': K2Upd.result_status['error']},
                                                  room=session_id)
                                    K2Upd.del_compomemts_data_yml(component_name)
                            except Exception as e:
                                K2Upd.result_status['error'] = str(e)
                                K2Upd.result_status['status'] = False
                                logging.error(f"Error in module install_components_pr 5 {component_name}: {str(e)}")
                                check_status = False
                                traceback.print_exc()
                                socketio.emit('update_progress', {'progress': progress_count,
                                                                  'message': f"Оновлення {component_name} {progress_count}%",
                                                                  'install_message': f'Помилка копіювання файлів, реєстрації компоненти  {component_name_req} ...  {e}',
                                                                  'error': K2Upd.result_status['error']
                                                                  }, room=session_id)
                                K2Upd.del_compomemts_data_yml(component_name)
                        # створення міграцій залежних компонент
                        if check_status and make_migration_value:
                            try:
                                K2Upd.make_migrations(component_name_req)
                                if K2Upd.result_status['status']:
                                    socketio.emit('update_progress', {'progress': f"{progress_count}",
                                                                      'message': f" Оновлення {component_name} {progress_count}%",
                                                                      'install_message': f'Створення міграцій бази даних {component_name_req} ...'},
                                                  room=session_id)
                                else:
                                    check_status = False
                                    socketio.emit('update_progress', {'progress': f"{progress_count}",
                                                                      'message': f"Оновлення {component_name} {progress_count}%",
                                                                      'install_message': f'Помилка створення міграцій {component_name_req} ...',
                                                                      'error': K2Upd.result_status['error'],
                                                                      'file': K2Upd.show_migrations_stderr()},
                                                  room=session_id)
                                    K2Upd.del_compomemts_data_yml(component_name)

                                if check_status:
                                    requests.get(f"{K2.domain_loc}/{component_name_req}/data-migrations")
                                    socketio.emit('update_progress', {'progress': 61,
                                                                      'message': f"Встановлення {component_name} 61%",
                                                                      'install_message': f'Залежна компонента {component_name_req} успішно встановлена ...', },
                                                  room=session_id)

                            except Exception as e:
                                K2Upd.result_status['error'] = str(e)
                                K2Upd.result_status['status'] = False
                                logging.error(f"Error in module install_components_pr 6{component_name}: {str(e)}")
                                check_status = False
                                traceback.print_exc()
                                socketio.emit('update_progress', {'progress': 61,
                                                                  'message': f"Оновлення {component_name}... помилка",
                                                                  'install_message': f'Помилка оновлення  {component_name_req} ... ',
                                                                  'error': K2Upd.result_status['error'],
                                                                  'file': K2Upd.show_migrations_stderr()},
                                              room=session_id)
                                K2Upd.del_compomemts_data_yml(component_name)
                    else:
                        socketio.emit('update_progress', {'progress': f"{progress_count}",
                                                          'message': f"Оновлення {component_name} {progress_count}%",
                                                          'install_message': f'{component_name_req} вже встановлено  ...'},
                                      room=session_id)
                check_status = True
                event = f"Install requirements components for {component_name}"
                write_to_log_file(event)
                reload_app_configs(component_name)

                #reload_app()

    if check_status:

        # встановлення залежностей основної компоненти
        if check_status:
            try:
                socketio.emit('update_progress', {'progress': 65,
                                                  'message': f"Оновлення {component_name} 45%",
                                                  'install_message': f'Встановлення залежностей {component_name}...'},
                              room=session_id)

                K2Upd.install_requirments(component_name)
                if K2Upd.result_status['status']:
                    socketio.emit('update_progress', {'progress': 65,
                                                      'message': f"Оновлення {component_name} 65%",
                                                      'install_message': f'Залежності {component_name} успішно встановлені...'},
                                  room=session_id)
                else:
                    socketio.emit('update_progress',
                                  {'progress': 65, 'message': f"Оновлення {component_name}... помилка",
                                   'install_message': f'Помилка оновлення залежностей  {component_name}... ',
                                   'error': K2Upd.result_status['error']}, room=session_id)
                    K2Upd.del_compomemts_data_yml(component_name)
                    check_status = False
            except Exception as e:
                logging.error(f"{e}")
                socketio.emit('update_progress',
                              {'progress': 65, 'message': f"Оновлення {component_name}... помилка",
                               'install_message': f'Помилка оновлення залежностей  {component_name}... {e}',
                               'error': f'{e}'}, room=session_id)
                K2Upd.del_compomemts_data_yml(component_name)
                traceback.print_exc()
                check_status = False

        # встановлення, реєстрація основної компоненти
        if check_status:
            try:
                socketio.emit('update_progress', {'progress': 70,
                                                  'message': f"Оновлення {component_name} 70%",
                                                  'install_message': f'Копіювання файлів, реєстрація компоненти, додавання пунктів меню {component_name}...'},
                              room=session_id)
                K2Upd.install_components_beta(component_id, component_name)
                if K2Upd.result_status['status']:
                    socketio.emit('update_progress', {'progress': 85,
                                                      'message': f"Оновлення {component_name} 85%",
                                                      'install_message': f'Реєстрація {component_name} успішно виконана ...'},
                                  room=session_id)
                else:
                    socketio.emit('update_progress',
                                  {'progress': 70, 'message': f"Встановлення {component_name}... помилка",
                                   'install_message': f"Помилка копіювання файлів {component_name}...",
                                   'error': K2Upd.result_status['error']}, room=session_id)
                    K2Upd.del_compomemts_data_yml(component_name)
                    check_status = False
            except Exception as e:
                socketio.emit('update_progress',
                              {'progress': 70, 'message': f"Встановлення {component_name}... помилка",
                               'install_message': f'Помилка копіювання файлів {component_name}... {e}',
                               'error': f'{e}'}, room=session_id)
                K2Upd.del_compomemts_data_yml(component_name)
                traceback.print_exc()
                check_status = False

        # створення міграцій основної компоненти
        if check_status and make_migration_value:
            try:
                socketio.emit('update_progress', {'progress': 86,
                                                  'message': f"Оновлення {component_name} 86%",
                                                  'install_message': f'Створення міграцій бази даних компоненти {component_name}...'},
                              room=session_id)
                try:
                    K2Upd.make_migrations(component_name)
                except Exception as e:
                    check_status = False

                if K2Upd.result_status['status']:
                    socketio.emit('update_progress', {'progress': 96,
                                                      'message': f"Оновлення {component_name} 96%",
                                                      'install_message': f'Міграції бази даних компоненти {component_name} успішно виконані ...'},
                                  room=session_id)
                else:
                    socketio.emit('update_progress',
                                  {'progress': 97, 'message': f"Оновлення {component_name}... помилка",
                                   'install_message': f'Помилка створення міграцій бази даних компоненти {component_name}...',
                                   'error': K2Upd.result_status['error'],
                                   'file': K2Upd.show_migrations_stderr()}, room=session_id)
                    check_status = False
                    K2Upd.del_compomemts_data_yml(component_name)
            except Exception as e:
                socketio.emit('update_progress',
                              {'progress': 97, 'message': f"Оновлення {component_name}... помилка",
                               'install_message': f'Помилка створення міграцій бази даних компоненти  {component_name}...',
                               'error': f'{e}',
                               'file': K2Upd.show_migrations_stderr()}, room=session_id)
                traceback.print_exc()
                K2Upd.del_compomemts_data_yml(component_name)
                check_status = False

        event = f"Install component {component_name} "
        write_to_log_file(event)
        reload_app_configs(component_name)
        if check_status:
            socketio.emit('update_progress',
                          {'progress': 100, 'message': f"Оновлено {component_name} 100%",
                           'install_message': f'{component_name} оновлено...'}, room=session_id)


@socketio.on('update_components_all')
def update_components_all(data):
    '''оновлення компоненти'''
    # отримуємо з клієнта дані про компоненту через сокети
    component_list = data.get('component_list')
    component_id = data.get('component_id')
    component_name = data.get('component_name')

    make_migration_value = data.get('make_migration_value')
    socketio.emit('update_progress', {'progress': 1, 'message': f"Оновлення {component_name} 1%",
                                      'install_message': 'Підготовка оновлення...'})

    check_status = True
    try:
        socketio.emit('update_progress', {'progress': 4, 'message': f"Оновлення {component_name} 4%",
                                          'install_message': 'Отримання даних з сервера оновлення...'})
        # Отримати дані компонент з сервера оновлень
        json_data = K2Upd.get_k2update_components()
        # вибіо компоненти по id
        selected_component = next((component for component in json_data if component['id'] == component_id), None)
        if selected_component is None:
            return 'Component not found'
        # selected_component_name = selected_component['name']
        archive_url = selected_component['latest_component_data']
        version = selected_component['latest_version']
    except Exception as e:
        logging.error(f"Update server is not avaible {e}")
        socketio.emit('update_progress', {'progress': 4, 'message': f"Оновлення {component_name}... помилка",
                                          'install_message': f'Помилка отримання даних з сервера оновлення...{e}',
                                          'error': f'{e}'})
        check_status = False

    if check_status:
        try:
            # Створити шлях до папки компоненти згідно назви та версії
            project_folder = 'components'
            component_folder = os.path.join(project_folder)
            os.makedirs(component_folder, exist_ok=True)
            socketio.emit('update_progress', {'progress': 12, 'message': f"Оновлення {component_name} 6%",
                                              'install_message': f'Завантаження архіву  {component_name} з сервера оновлення...'})
            # Завантажити архів компоненти
            response = requests.get(archive_url, stream=True)
            response.raise_for_status()
        except Exception as e:
            logging.error(f"{e}")
            socketio.emit('update_progress', {'progress': 12, 'message': f"Оновлення {component_name}... помилка",
                                              'install_message': f'Помилка завантаження архіву  {component_name} з сервера оновлення... {e}',
                                              'error': f'{e}'})
            check_status = False

    if check_status:
        try:
            # Шлях до завантаженого архіву
            archive_path = os.path.join(component_folder, f"{component_name}.zip")
            # Зберегти архів на диск
            socketio.emit('update_progress', {'progress': 18, 'message': f"Оновлення {component_name} 7%",
                                              'install_message': f'Розпаковка архіву  компоненти {component_name}...'})
            with open(archive_path, "wb") as file:
                for chunk in response.iter_content(chunk_size=4096):
                    file.write(chunk)
                # Розпакувати архів
            with zipfile.ZipFile(archive_path, "r") as zip_ref:
                zip_ref.extractall(component_folder)
            # Видалити архів
            os.remove(archive_path)
            # перейменувати якщо git
            # component_name = selected_component['name']
            old_folder_path = os.path.join(component_folder, component_name + ".git")
            new_folder_path = os.path.join(component_folder, component_name)
            # Перевірка наявності папки зі старою назвою
            if os.path.exists(old_folder_path) and os.path.isdir(old_folder_path):
                # Перейменування папки зі старою назвою на нову назву
                os.rename(old_folder_path, new_folder_path)
            socketio.emit('update_progress', {'progress': 22, 'message': f"Оновлення {component_name} 8%",
                                              'install_message': f'Розпаковка архіву компоненти {component_name}  завершено...'})
        except Exception as e:
            logging.error(f"ChunkedEncodingError {e}")
            socketio.emit('update_progress', {'progress': 22, 'message': f"Оновлення {component_name}... помилка",
                                              'install_message': f'Помилка розпаковки архіву  {component_name} з сервера оновлення...{e}',
                                              'error': f'{e}'})
            check_status = False

    # if check_status:
    #     try:
    #         socketio.emit('update_progress', {'progress': 25, 'message': f"Оновлення {component_name} 9%",
    #                                           'install_message': f'Пошук залежних компонент для {component_name} ...'})
    #         # # Відкриття файлу requirements_components.txt для пошуку залежних компонент
    #         # project_folder = 'components'
    #         # requirements_file = f"components/{component_name}/reguirements-components.txt"
    #         # component_ids = None
    #         # if os.path.isfile(requirements_file):
    #         #     with open(requirements_file, 'r') as file:
    #         #         component_ids = file.read().splitlines()
    #
    #         try:
    #             # Зчитати вміст файлу YAML із списком встановлених компонент
    #             with open(f"{project_folder}/components.yml", 'r') as file:
    #                 components_data = yaml.safe_load(file)
    #         except FileNotFoundError as e:
    #             logging.error(f"Not found  {str(e)}")
    #         if components_data == None:
    #             components_data = {'components': []}
    #         # response = requests.get(f'{K2.update_domain}k2update/api/components')
    #         # json_data = response.json()
    #         #json_data = K2Upd.get_k2update_components()
    #     except Exception as e:
    #         logging.error(f"ChunkedEncodingError {e}")
    #         socketio.emit('update_progress', {'progress': 9, 'message': f"Оновлення {component_name}... помилка",
    #                                           'install_message': f'Помилка пошуку залежних компонент {component_name}... {e}', 'error': f'{e}'})
    #         check_status = False

    if check_status:
        # progress_count = 10

        # встановлення залежностей основної компоненти
        if check_status:
            try:
                socketio.emit('update_progress', {'progress': 45,
                                                  'message': f"Оновлення {component_name} 65%",
                                                  'install_message': f'Встановлення залежностей {component_name}...'})

                K2Upd.install_requirments(component_name)
                if K2Upd.result_status['status']:
                    socketio.emit('update_progress', {'progress': 65,
                                                      'message': f"Оновлення {component_name} 75%",
                                                      'install_message': f'Залежності {component_name} успішно встановлені...'})
                else:
                    socketio.emit('update_progress',
                                  {'progress': 55, 'message': f"Оновлення {component_name}... помилка",
                                   'install_message': f'Помилка оновлення залежностей  {component_name}... ',
                                   'error': K2Upd.result_status['error']})
                    K2Upd.del_compomemts_data_yml(component_name)
                    check_status = False
            except Exception as e:
                logging.error(f"{e}")
                socketio.emit('update_progress',
                              {'progress': 45, 'message': f"Оновлення {component_name}... помилка",
                               'install_message': f'Помилка оновлення залежностей  {component_name}... {e}',
                               'error': f'{e}'})
                K2Upd.del_compomemts_data_yml(component_name)
                check_status = False

        # встановлення, реєстрація основної компоненти
        if check_status:
            try:
                socketio.emit('update_progress', {'progress': 70,
                                                  'message': f"Оновлення {component_name} 76%",
                                                  'install_message': f'Копіювання файлів, реєстрація компоненти, додавання пунктів меню {component_name}...'})
                K2Upd.install_components(component_id, component_name)
                if K2Upd.result_status['status']:
                    socketio.emit('update_progress', {'progress': 85,
                                                      'message': f"Оновлення {component_name} 76%",
                                                      'install_message': f'Реєстрація {component_name} успішно виконана ...'})
                else:
                    socketio.emit('update_progress',
                                  {'progress': 70, 'message': f"Встановлення {component_name}... помилка",
                                   'install_message': f"Помилка копіювання файлів {component_name}...",
                                   'error': K2Upd.result_status['error']})
                    K2Upd.del_compomemts_data_yml(component_name)
                    check_status = False
            except Exception as e:
                socketio.emit('update_progress',
                              {'progress': 70, 'message': f"Встановлення {component_name}... помилка",
                               'install_message': f'Помилка копіювання файлів {component_name}... {e}',
                               'error': f'{e}'})
                K2Upd.del_compomemts_data_yml(component_name)
                check_status = False

        # створення міграцій основної компоненти
        if check_status and make_migration_value:
            try:
                socketio.emit('update_progress', {'progress': 86,
                                                  'message': f"Оновлення {component_name} 86%",
                                                  'install_message': f'Створення міграцій бази даних компоненти {component_name}...'})
                K2Upd.make_migrations(component_name)
                if K2Upd.result_status['status']:
                    socketio.emit('update_progress', {'progress': 96,
                                                      'message': f"Оновлення {component_name} 96%",
                                                      'install_message': f'Міграції бази даних компоненти {component_name} успішно виконані ...'})
                else:
                    socketio.emit('update_progress',
                                  {'progress': 97, 'message': f"Оновлення {component_name}... помилка",
                                   'install_message': f'Помилка створення міграцій бази даних компоненти {component_name}...',
                                   'error': K2Upd.result_status['error'],
                                   'file': K2Upd.show_migrations_stderr()})
                    check_status = False
                    K2Upd.del_compomemts_data_yml(component_name)
            except Exception as e:
                socketio.emit('update_progress',
                              {'progress': 97, 'message': f"Оновлення {component_name}... помилка",
                               'install_message': f'Помилка створення міграцій бази даних компоненти  {component_name}...',
                               'error': f'{e}',
                               'file': K2Upd.show_migrations_stderr()})
                K2Upd.del_compomemts_data_yml(component_name)
                check_status = False

        event = f"Install component {component_name} "
        write_to_log_file(event)
        reload_app_configs(component_name)
        if check_status:
            socketio.emit('update_progress',
                          {'progress': 100, 'message': f"Оновлено {component_name} 100%",
                           'install_message': f'{component_name} оновлено...'})


@socketio.on('update_components_k2root')
def update_components_k2root(data):
    '''оновлення компоненти'''
    # отримуємо з клієнта дані про компоненту через сокети
    # component_id = data.get('component_id')
    component_name = 'k2root'
    session_id = request.sid
    make_migration_value = data.get('make_migration_value')
    socketio.emit('update_progress', {'progress': 1, 'message': f"Оновлення {component_name} 1%",
                                      'install_message': 'Підготовка оновлення...'}, room=session_id)

    check_status = True
    try:
        socketio.emit('update_progress', {'progress': 4, 'message': f"Оновлення {component_name} 4%",
                                          'install_message': 'Отримання даних з сервера оновлення...'}, room=session_id)
        # Отримати дані компонент з сервера оновлень
        json_data = K2Upd.get_k2update_components()
        # вибіо компоненти по id
        selected_component = next((component for component in json_data if component['name'] == 'k2root'), None)
        if selected_component is None:
            return 'Component not found'
        # selected_component_name = selected_component['name']
        archive_url = selected_component['latest_component_data']
        version = selected_component['latest_version']
    except Exception as e:
        logging.error(f"Update server is not avaible {e}")
        socketio.emit('update_progress', {'progress': 4, 'message': f"Оновлення {component_name}... помилка",
                                          'install_message': f'Помилка отримання даних з сервера оновлення...{e}',
                                          'error': f'{e}'}, room=session_id)
        check_status = False

    if check_status:
        project_folder = ''
        archive_url = selected_component['latest_component_data']
        version = selected_component['latest_version']
        try:
            socketio.emit('update_progress', {'progress': 12,
                                              'message': f"Оновлення {component_name} 6%",
                                              'install_message': f'Завантаження архіву  {component_name} з сервера оновлення...'},
                          room=session_id)
            # Завантажити архів компоненти
            response = requests.get(archive_url, stream=True)
            response.raise_for_status()

            archive_filename = "k2root.zip"
            archive_path = os.path.join(project_folder, archive_filename)

            with open(archive_path, "wb") as file:
                for chunk in response.iter_content(chunk_size=8192):
                    file.write(chunk)
            with zipfile.ZipFile(archive_path, "r") as zip_ref:
                # Витягування файлів без зміни шляху
                zip_ref.extractall(project_folder)
            socketio.emit('update_progress', {'progress': 18, 'message': f"Оновлення {component_name} 18%",
                                              'install_message': f'Розпаковка архіву  компоненти {component_name}...'},
                          room=session_id)
            os.remove(archive_path)
        except Exception as e:
            logging.error(f"{e}")
            socketio.emit('update_progress', {'progress': 12, 'message': f"Оновлення {component_name}... помилка",
                                              'install_message': f'Помилка завантаження архіву  {component_name} з сервера оновлення... {e}',
                                              'error': f'{e}'},
                          room=session_id)
            check_status = False

    if check_status:
        # progress_count = 10

        # встановлення залежностей
        if check_status:
            try:
                socketio.emit('update_progress', {'progress': 45,
                                                  'message': f"Оновлення {component_name} 65%",
                                                  'install_message': f'Встановлення залежностей {component_name}...'},
                              room=session_id)

                K2Upd.install_requirments(component_name)
                if K2Upd.result_status['status']:
                    socketio.emit('update_progress', {'progress': 65,
                                                      'message': f"Оновлення {component_name} 75%",
                                                      'install_message': f'Залежності {component_name} успішно встановлені...'},
                                  room=session_id)
                else:
                    socketio.emit('update_progress',
                                  {'progress': 45, 'message': f"Оновлення {component_name}... помилка",
                                   'install_message': f'Помилка оновлення залежностей  {component_name}... ',
                                   'error': K2Upd.result_status['error']},
                                  room=session_id)
                    # K2Upd.del_compomemts_data_yml(component_name)
                    check_status = False
            except Exception as e:
                logging.error(f"{e}")
                socketio.emit('update_progress',
                              {'progress': 45, 'message': f"Оновлення {component_name}... помилка",
                               'install_message': f'Помилка оновлення залежностей  {component_name}... {e}',
                               'error': f'{e}'},
                              room=session_id)
                # K2Upd.del_compomemts_data_yml(component_name)
                check_status = False

        # встановлення, реєстрація основної компоненти
        if check_status:
            try:
                socketio.emit('update_progress', {'progress': 70,
                                                  'message': f"Оновлення {component_name} 70%",
                                                  'install_message': f'Копіювання файлів, реєстрація компоненти, додавання пунктів меню {component_name}...'},
                              room=session_id)
                K2Upd.update_k2cloud_root()
                if K2Upd.result_status['status']:
                    socketio.emit('update_progress', {'progress': 85,
                                                      'message': f"Оновлення {component_name} 85%",
                                                      'install_message': f'Реєстрація {component_name} успішно виконана ...'},
                                  room=session_id)
                else:
                    socketio.emit('update_progress',
                                  {'progress': 85, 'message': f"Встановлення {component_name}... помилка",
                                   'install_message': f"Помилка копіювання файлів {component_name}...",
                                   'error': K2Upd.result_status['error']},
                                  room=session_id)
                    # K2Upd.del_compomemts_data_yml(component_name)
                    check_status = False
            except Exception as e:
                socketio.emit('update_progress',
                              {'progress': 85, 'message': f"Встановлення {component_name}... помилка",
                               'install_message': f'Помилка копіювання файлів {component_name}... {e}',
                               'error': f'{e}'},
                              room=session_id)
                # K2Upd.del_compomemts_data_yml(component_name)
                check_status = False

        # створення міграцій основної компоненти
        if check_status and make_migration_value:
            try:
                socketio.emit('update_progress', {'progress': 86,
                                                  'message': f"Оновлення {component_name} 86%",
                                                  'install_message': f'Створення міграцій бази даних компоненти {component_name}...'},
                              room=session_id)
                K2Upd.make_migrations(component_name)
                if K2Upd.result_status['status']:
                    socketio.emit('update_progress', {'progress': 96,
                                                      'message': f"Оновлення {component_name} 96%",
                                                      'install_message': f'Міграції бази даних компоненти {component_name} успішно виконані ...'},
                                  room=session_id)
                else:
                    socketio.emit('update_progress',
                                  {'progress': 97, 'message': f"Оновлення {component_name}... помилка",
                                   'install_message': f'Помилка створення міграцій бази даних компоненти {component_name}...',
                                   'error': K2Upd.result_status['error'],
                                   'file': K2Upd.show_migrations_stderr()},
                                  room=session_id)
                    check_status = False
                    # K2Upd.del_compomemts_data_yml(component_name)
            except Exception as e:
                socketio.emit('update_progress',
                              {'progress': 97, 'message': f"Оновлення {component_name}... помилка",
                               'install_message': f'Помилка створення міграцій бази даних компоненти  {component_name}...',
                               'error': f'{e}',
                               'file': K2Upd.show_migrations_stderr()},
                              room=session_id)
                # K2Upd.del_compomemts_data_yml(component_name)
                check_status = False

        event = f"Install component {component_name} "
        write_to_log_file(event)
        reload_app_configs(component_name)
        reload_app()
        K2.create_system_settings()
        if check_status:
            socketio.emit('update_progress',
                          {'progress': 100, 'message': f"Оновлено {component_name} 100%",
                           'install_message': f'{component_name} оновлено...'},
                          room=session_id)


@socketio.on('update_components_metadata')
def update_components_metadata(data):
    pass


@socketio.on('edit_sync_status')
def edit_sync_status(data):
    component_data_id = data['component_data_id']
    status = data['status']
    sync_settings = '../data/k2_cloud_erp/import/sync_settings.json'
    with open(sync_settings, 'r') as f:
        json_data = json.load(f)

    # Пошук потрібного рядка за component_data_id і оновлення статусу
    for item in json_data:
        for meta_item in item['data']:
            if meta_item['component_data_id'] == component_data_id:
                meta_item['sync'] = status
                meta_item['edit-user'] = True
                break

    # Запис оновленого вмісту назад у файл
    with open(sync_settings, 'w') as f:
        json.dump(json_data, f, indent=4, sort_keys=True)


@socketio.on('sync_metadata')
def sync_metadata(data):
    component_name = data['component_name']
    sync_settings_path = '../data/k2_cloud_erp/import/sync_settings.json'

    try:
        # Зчитуємо дані з файлу sync_settings.json
        with open(sync_settings_path, 'r') as f:
            sync_settings = json.load(f)

        # Знаходимо елемент з іменем component_name
        component_data = next((item for item in sync_settings if item["id"] == component_name), None)
        import_path = '../data/k2_cloud_erp/import'
        if component_data:
            # Завантажуємо архів
            archive_url = component_data['component_data_archive']
            archive_filename = os.path.basename(archive_url)
            archive_path = os.path.join(import_path, archive_filename)
            response = requests.get(archive_url)
            with open(archive_path, 'wb') as archive_file:
                archive_file.write(response.content)

            # Розпаковуємо архів
            component_data_path = os.path.join(import_path, component_name)
            with zipfile.ZipFile(archive_path, 'r') as zip_ref:
                zip_ref.extractall(component_data_path)
    except Exception as e:
        logging.error(f'Error in sync_metadata {e}')
    count_success = 0
    count_error = 0
    # Цикл по data з файлу імпорту
    for item in component_data['data']:
        check_result = False
        if item['component_data_type_id'] == 'handbooks' and item['sync']:
            component_data_file = item['component_data_file']
            table_name = item['component_data_id']
            try:
                with open(f'{component_data_path}/{component_data_file}', 'r') as json_file:
                    data = json.load(json_file)
            except Exception as e:
                logging.info(e)
            try:
                metadata = MetaData()
                # Побудова об'єкта запиту

                table_data = Table(table_name, metadata, autoload_with=db.engine)
                primary_key_columns = table_data.primary_key.columns.keys()
                connection = db.engine.connect()
                try:
                    connection.execute(text(f"ALTER TABLE {table_name} DISABLE TRIGGER ALL;"))
                except:
                    pass
                value_ap = "'"
                value_ap_replace = "''"
                for row in data:
                    try:
                        columns = ', '.join(row.keys())
                        values = ', '.join(
                            [f"'{value.replace(value_ap, value_ap_replace)}'" if isinstance(value,
                                                                                            str) and value is not None else str(
                                value) for value in
                             row.values()])
                    except Exception as e:
                        logging.error(e)
                        break

                    select_query = f"SELECT {primary_key_columns[0]}  FROM {table_name} WHERE {primary_key_columns[0]} = '{(list(row.values())[0])}'"

                    result = connection.execute(text(select_query))

                    if result.fetchone() is not None:
                        for key, value in row.items():
                            update_values = ', '.join(
                                [f"{key} = '{value.replace(value_ap, value_ap_replace)}'" if isinstance(value,
                                                                                                        str) and value is not None else f"{key} = {value}"
                                 for key, value in row.items()])
                        update_values = update_values.replace("None", "NULL")
                        query = f"UPDATE {table_name} SET {update_values} WHERE {primary_key_columns[0]} = '{(list(row.values())[0])}'"
                    else:
                        values = values.replace("None", "NULL")
                        query = f'INSERT INTO {table_name} ({columns}) VALUES ({values})'
                        # print(query)

                    try:
                        connection.execute(text(query))
                        check_result = True

                    except Exception as e:
                        logging.error(e)
                        socketio.emit('done_sync_status',
                                      {'sync_status': False, 'date_sync': f'{e}',
                                       'component_data_id': table_name})
                        K2Upd.save_sync_log_data(component_data_id=table_name,
                                                 component_data_type_id='handbooks',
                                                 component_data_file=component_data_file,
                                                 sync_status='Error',
                                                 sync_error=str(e),
                                                 type_sync='import'
                                                 )
                        check_result = False

                    # finally:
                    #    logging.info(f'insert data in {table_name} status {check_result}')

                connection.commit()
                try:
                    connection.execute(text(f"ALTER TABLE {table_name} DISABLE TRIGGER ALL;"))
                except:
                    pass
                connection.close()

                K2Upd.save_sync_log_data(component_data_id=table_name,
                                         component_data_type_id='handbooks',
                                         component_data_file=component_data_file,
                                         sync_status='Success',
                                         sync_error='-',
                                         type_sync='import'
                                         )
                count_success += 1

            except SQLAlchemyError as e:
                logging.error(f'Error insert metadata {e}')
                K2Upd.save_sync_log_data(component_data_id=table_name,
                                         component_data_type_id='handbooks',
                                         component_data_file=component_data_file,
                                         sync_status='Error',
                                         sync_error=str(e),
                                         type_sync='import'
                                         )
                check_result = False
                count_error += 1
                socketio.emit('done_sync_status',
                              {'count_success': count_success, 'count_error': count_error,
                               'type_name': item['component_data_type_id']})
            if check_result:
                socketio.emit('done_sync_status',
                              {'count_success': count_success, 'count_error': count_error,
                               'type_name': item['component_data_type_id']})





        elif item['component_data_type_id'] == 'reports' and item['sync']:
            table_name = item['component_data_id']
            component_data_file = item['component_data_file']
            data_path_root = '../data/k2_cloud_erp/report'
            data_path_import = '../data/k2_cloud_erp/import/reports'
            # Перевірка існування папки data_path_root
            if not os.path.exists(data_path_root):
                os.makedirs(data_path_root)
            try:
                # shutil.copytree(data_path_import, data_path_root, dirs_exist_ok=True)
                source_path = os.path.join(data_path_import, component_data_file)
                target_path = os.path.join(data_path_root, component_data_file)
                shutil.copy(source_path, target_path)

                # Скопіювати файл
                #shutil.copy(source_path, target_path)
                check_result = True
                K2Upd.save_sync_log_data(component_data_id=table_name,
                                         component_data_type_id='reports',
                                         component_data_file=component_data_file,
                                         sync_status='Success',
                                         sync_error='-',
                                         type_sync='import'
                                         )
                count_success += 1

            except Exception as e:
                logging.error(f'Error copying reports from {data_path_import} to {data_path_root}: {e}')
                K2Upd.save_sync_log_data(component_data_id=table_name,
                                         component_data_type_id='reports',
                                         component_data_file=component_data_file,
                                         sync_status='Error',
                                         sync_error=str(e),
                                         type_sync='import'
                                         )
                check_result = False
                count_error += 1
                socketio.emit('done_sync_status',
                              {'count_success': count_success, 'count_error': count_error,
                               'type_name': item['component_data_type_id']})
            if check_result:
                socketio.emit('done_sync_status',
                              {'count_success': count_success, 'count_error': count_error,
                               'type_name': item['component_data_type_id']})


        elif item['component_data_type_id'] == 'translates' and item['sync']:
            transl_name = item['component_data_id']
            data_path_root = f"components/{item['component_data_name_lpu']}/{item['component_data_name_lpu']}/languages/"
            data_path_import = f"../data/k2_cloud_erp/import/translates/{item['component_data_name_lpu']}/languages/"
            component_data_file = item['component_data_file']
            try:
                #shutil.copytree(data_path_import, data_path_root, dirs_exist_ok=True)
                source_path_po = os.path.join(data_path_import, component_data_file)
                target_path_po = os.path.join(data_path_root, component_data_file)
                shutil.copy(source_path_po, target_path_po)
                source_path_mo = os.path.join(data_path_import, component_data_file.replace('.po', '.mo'))
                target_path_mo = os.path.join(data_path_root, component_data_file.replace('.po', '.mo'))
                shutil.copy(source_path_mo, target_path_mo)
                check_result = True
                K2Upd.save_sync_log_data(component_data_id=transl_name,
                                         component_data_type_id='translates',
                                         component_data_file=component_data_file,
                                         sync_status='Success',
                                         sync_error='-',
                                         type_sync='import'
                                         )
                count_success += 1

            except Exception as e:
                logging.error(f'Error copying reports from {data_path_import} to {data_path_root}: {e}')
                K2Upd.save_sync_log_data(component_data_id=transl_name,
                                         component_data_type_id='translates',
                                         component_data_file=component_data_file,
                                         sync_status='Error',
                                         sync_error=str(e),
                                         type_sync='import'
                                         )
                check_result = False
                count_error += 1
                socketio.emit('done_sync_status',
                              {'count_success': count_success, 'count_error': count_error,
                               'type_name': item['component_data_type_id']})
            if check_result:
                socketio.emit('done_sync_status',
                              {'count_success': count_success, 'count_error': count_error,
                               'type_name': item['component_data_type_id']})


@socketio.on('sync_metadata_all')
def sync_metadata_all(data):
    data_type_list = data['data_type_list']
    sync_settings_path = '../data/k2_cloud_erp/import/sync_settings.json'
    for component_name in data_type_list:
        try:
            # Зчитуємо дані з файлу sync_settings.json
            with open(sync_settings_path, 'r') as f:
                sync_settings = json.load(f)

            # Знаходимо елемент з іменем component_name
            component_data = next((item for item in sync_settings if item["id"] == component_name), None)
            import_path = '../data/k2_cloud_erp/import'
            if component_data:
                # Завантажуємо архів
                archive_url = component_data['component_data_archive']
                archive_filename = os.path.basename(archive_url)
                archive_path = os.path.join(import_path, archive_filename)
                response = requests.get(archive_url)
                with open(archive_path, 'wb') as archive_file:
                    archive_file.write(response.content)

                # Розпаковуємо архів
                component_data_path = os.path.join(import_path, component_name)
                with zipfile.ZipFile(archive_path, 'r') as zip_ref:
                    zip_ref.extractall(component_data_path)
        except Exception as e:
            logging.error(f'Error in sync_metadata {e}')
        count_success = 0
        count_error = 0
        # Цикл по data з файлу імпорту
        for item in component_data['data']:
            check_result = False
            if item['component_data_type_id'] == 'handbooks' and item['sync']:
                component_data_file = item['component_data_file']
                table_name = item['component_data_id']
                try:
                    with open(f'{component_data_path}/{component_data_file}', 'r') as json_file:
                        data = json.load(json_file)
                except Exception as e:
                    logging.info(e)
                try:
                    metadata = MetaData()
                    # Побудова об'єкта запиту
                    table_data = Table(table_name, metadata, autoload_with=db.engine)
                    primary_key_columns = table_data.primary_key.columns.keys()
                    connection = db.engine.connect()

                    for row in data:
                        try:
                            columns = ', '.join(row.keys())
                            values = ', '.join(
                                [f"'{value}'" if isinstance(value, str) and value is not None else str(value) for value
                                 in
                                 row.values()])
                        except Exception as e:
                            logging.error(f'{e}')
                            break

                        select_query = f"SELECT {primary_key_columns[0]}  FROM {table_name} WHERE {primary_key_columns[0]} = '{(list(row.values())[0])}'"

                        result = connection.execute(text(select_query))

                        if result.fetchone() is not None:
                            for key, value in row.items():
                                update_values = ', '.join([f"{key} = '{value}'" if isinstance(value,
                                                                                              str) and value is not None else f"{key} = {value}"
                                                           for key, value in row.items()])
                            update_values = update_values.replace("None", "NULL")
                            query = f"UPDATE {table_name} SET {update_values} WHERE {primary_key_columns[0]} = '{(list(row.values())[0])}'"
                        else:
                            values = values.replace("None", "NULL")
                            query = f'INSERT INTO {table_name} ({columns}) VALUES ({values})'
                            #print(query)

                        try:
                            connection.execute(text(query))
                            check_result = True

                        except Exception as e:
                            logging.error(e)
                            socketio.emit('done_sync_status',
                                          {'sync_status': False, 'date_sync': f'{e}',
                                           'component_data_id': table_name})
                            check_result = False
                        finally:
                            logging.info(f'insert data in {table_name} status {check_result}')

                    connection.commit()
                    connection.close()
                    K2Upd.save_sync_log_data(component_data_id=table_name,
                                             component_data_type_id='handbooks',
                                             component_data_file=component_data_file,
                                             sync_status='Success',
                                             sync_error='-',
                                             type_sync='import'
                                             )
                    count_success += 1

                except SQLAlchemyError as e:
                    logging.error(f'Error insert metadata {e}')
                    count_error += 1
                    K2Upd.save_sync_log_data(component_data_id=table_name,
                                             component_data_type_id='handbooks',
                                             component_data_file=component_data_file,
                                             sync_status='Error',
                                             sync_error=str(e),
                                             type_sync='import'
                                             )
                    check_result = False
                if check_result:
                    socketio.emit('done_sync_status',
                                  {'count_success': count_success, 'count_error': count_error,
                                   'type_name': item['component_data_type_id']})


            elif item['component_data_type_id'] == 'reports' and item['sync']:
                table_name = item['component_data_id']
                component_data_file = item['component_data_file']
                data_path_root = '../data/k2_cloud_erp/report'
                data_path_import = '../data/k2_cloud_erp/import/reports'
                # Перевірка існування папки data_path_root
                if not os.path.exists(data_path_root):
                    os.makedirs(data_path_root)
                try:
                    # shutil.copytree(data_path_import, data_path_root, dirs_exist_ok=True)
                    source_path = os.path.join(data_path_import, component_data_file)
                    target_path = os.path.join(data_path_root, component_data_file)
                    shutil.copy(source_path, target_path)

                    # Скопіювати файл
                    shutil.copy(source_path, target_path)
                    check_result = True
                    K2Upd.save_sync_log_data(component_data_id=table_name,
                                             component_data_type_id='reports',
                                             component_data_file=component_data_file,
                                             sync_status='Success',
                                             sync_error='-',
                                             type_sync='import'
                                             )
                    count_success += 1

                except Exception as e:
                    logging.error(f'Error copying reports from {data_path_import} to {data_path_root}: {e}')
                    K2Upd.save_sync_log_data(component_data_id=table_name,
                                             component_data_type_id='reports',
                                             component_data_file=component_data_file,
                                             sync_status='Error',
                                             sync_error=str(e),
                                             type_sync='import'
                                             )
                    check_result = False
                    count_error += 1
                if check_result:
                    socketio.emit('done_sync_status',
                                  {'count_success': count_success, 'count_error': count_error,
                                   'type_name': item['component_data_type_id']})


            elif item['component_data_type_id'] == 'grid_settings' and item['sync']:
                pass

        socketio.emit('done_sync_status_all')


# @components_bp.route('/install-component-progress-old/<string:component_id>')
# # @login_required
# def install_component_progress_new(component_id):
#     '''генерація сторінки з прогресбаром встановлення компоненти'''
#     try:
#         json_data = K2Upd.get_k2update_components()
#         selected_component = next((component for component in json_data if component['id'] == component_id), None)
#         if selected_component is None:
#             return 'Component not found'
#         component_name = selected_component['name']
#     except:
#         logging.error(f"Update server is not avaible")
#     return render_template('install-components-old.html',
#                            component_name=component_name,
#                            component_id=component_id)


@components_bp.route('/install-component-progress-php/<string:component_id>')
# @login_required
def install_component_progress_php(component_id):
    '''генерація сторінки з прогресбаром встановлення компоненти'''
    try:
        json_data = K2Upd.get_k2update_components()
        selected_component = next((component for component in json_data if component['id'] == component_id), None)
        if selected_component is None:
            return 'Component not found'
        component_name = selected_component['name']
    except:
        logging.error(f"Update server is not avaible")
    return render_template('install-components-php.html',
                           component_name=component_name,
                           component_id=component_id)


@components_bp.route('/update-component-progress-php/<string:component_id>')
# @login_required
def update_component_progress_php(component_id):
    '''генерація сторінки з прогресбаром встановлення компоненти'''
    try:
        json_data = K2Upd.get_k2update_components()
        selected_component = next((component for component in json_data if component['id'] == component_id), None)
        if selected_component is None:
            return 'Component not found'
        component_name = selected_component['name']
    except:
        logging.error(f"Update server is not avaible")
    return render_template('update-components-php.html',
                           component_name=component_name,
                           component_id=component_id)


@components_bp.route('/update-component-progress/<string:component_id>')
@login_required
def update_component_progress_new(component_id):
    '''генерація сторінки з прогресбаром оновлення компоненти'''
    try:
        json_data = K2Upd.get_k2update_components()
        selected_component = next((component for component in json_data if component['id'] == component_id), None)
        if selected_component is None:
            return 'Component not found'
        component_name = selected_component['name']
    except:
        logging.error(f"Update server is not avaible")
    return render_template('update-components-new.html',
                           component_name=component_name,
                           component_id=component_id)


@components_bp.route('/components-update-metadata')
@login_required
def components_update_metadata():
    try:
        component_server = []
        json_data = K2Upd.get_k2update_metadata()
        directory = '../data/k2_cloud_erp/import/'
        if not os.path.exists(directory):
            os.makedirs(directory)
        sync_settings = '../data/k2_cloud_erp/import/sync_settings.json'
        if not os.path.exists(sync_settings):
            with open(sync_settings, 'w') as f:
                initial_data = []
                json.dump(initial_data, f)

        with open(sync_settings, 'r') as f:
            json_data_from_file_load = json.load(f)

        for component_data in json_data:
            component_name = component_data['name']

            # Перевірити, чи є компонент в json_data_from_file_load
            found = False
            for existing_component_data in json_data_from_file_load:
                if existing_component_data['name'] == component_name:
                    found = True
                    # Перебрати дані компонента
                    for meta_item in component_data['data']:
                        component_id = meta_item['component_data_id']
                        existing_component_item = next(
                            (item for item in existing_component_data['data'] if
                             item['component_data_id'] == component_id),
                            None)
                        # Оновити елемент, якщо він існує
                        if existing_component_item:
                            if 'edit-user' not in existing_component_item or existing_component_item[
                                'edit-user'] == False:
                                existing_component_item.update({key: value for key, value in meta_item.items() if
                                                                key not in ['sync', 'sync_date', 'sync_status',
                                                                            'edit-user']})
                        else:
                            # Додати новий елемент, якщо він не існує
                            # Додати sync: true для нового елемента
                            meta_item['sync'] = True
                            existing_component_data['data'].append(meta_item)
                    break

            # Якщо компонент не знайдено, додати його до json_data_from_file_load
            if not found:
                for meta_item in component_data['data']:
                    # Додати sync: true для нового елемента
                    meta_item['sync'] = True
                json_data_from_file_load.append(component_data)

            # Записати оновлені дані у файл
        with open(sync_settings, 'w') as f:
            json.dump(json_data_from_file_load, f, indent=4, sort_keys=True)

        with open(sync_settings, 'r') as f:
            json_data_from_file = json.load(f)

        component_server = [item for item in json_data_from_file]
    except Exception as e:
        logging.info(f'Error in dashboard-metadata.html {e}')
    return render_template('dashboard-metadata.html', components=component_server)  # menu=menu_data)


@components_bp.route('/components-update-metadata-logs')
@login_required
def components_update_metadata_logs():
    try:
        from components.k2grid.k2grid.views import K2Grid
    except Exception as error:
        logging.error(f"{error} K2Grid is missing for correct work")

    try:
        k2grid = K2Grid(name_yml="k2log_sync")
    except Exception as e:
        logging.error(f"Error in components_update_metadata_logs {e}")

    return render_template('dashboard-metadata_sync_log.html', grid_settings=k2grid,
                           title="Лог синхронізації")  # menu=menu_data)


def reload_app():
    from flask import session as session_flask
    if K2.platform == 'Windows':
        if 'configs' not in session_flask:
            session_flask['configs'] = {}
    elif K2.platform == 'Linux':
        from flask import session as session_flask
        if 'configs' not in session_flask:
            session_flask['configs'] = {}
        reload_gunicorn()


@components_bp.route('/reload-server')
@login_required
def reload_app_route():
    '''tech reload'''
    from flask import session as session_flask
    if K2.platform == 'Windows':
        if 'configs' not in session_flask:
            session_flask['configs'] = {}
    elif K2.platform == 'Linux':
        if 'configs' not in session_flask:
            session_flask['configs'] = {}
        reload_gunicorn()
        return 'Reload server succeful!!!'


def run_hypercorn():
    subprocess.Popen(['hypercorn', 'app:app'])


def get_hypercorn_pid():
    for proc in psutil.process_iter(['pid', 'name']):
        if 'hypercorn' in proc.info['name']:
            return proc.info['pid']
    return None


def reload_hypercorn():
    pid = get_hypercorn_pid()
    if pid is not None:
        try:
            os.kill(pid, signal.SIGTERM)  # Send the SIGHUP signal to reload Hypercorn
            print("Hypercorn reloaded.")
        except Exception as e:
            print(f"Failed to reload Hypercorn. Error: {e}")
    else:
        print("Hypercorn process not found.")


def reload_app_h():
    # Запустити Hypercorn в окремому процесі
    run_hypercorn()
    # Зробити перезавантаження Hypercorn
    reload_hypercorn()
    return jsonify({"message": "Hypercorn reloaded"})


def get_gunicorn_by_port(port):
    processes = []
    for proc in psutil.process_iter(['pid', 'name']):
        if 'gunicorn' in proc.info['name']:
            processes.append(proc)
            # print(processes)
    for p in processes:
        for c in p.connections():
            print(p.info['pid'])
            print(c)
            if int(c.laddr.port) == int(port):
                current_pid = p.info['pid']
                return current_pid
    return None


def reload_gunicorn():
    try:
        pid = get_gunicorn_by_port(K2.port)  # Замість <pid> підставте ідентифікатор процесу Gunicorn
        print(pid)
        subprocess.run(['kill', '-HUP', str(pid)])

    except Exception as e:
        print(e)
        os.kill(pid, 1)


def generate_id():
    generated_id = uuid.uuid4().hex[:32]
    return ''.join([generated_id[i:i + 4] for i in range(0, len(generated_id), 4)])


def first_login_required(view_func):
    @wraps(view_func)
    def decorated_view(*args, **kwargs):
        if 'username' not in session:
            return redirect(url_for('components.first_login'))
        return view_func(*args, **kwargs)

    return decorated_view


def remove_from_yaml_file(file_path, component_name):
    with open(file_path, 'r') as f:
        existing_data = yaml.safe_load(f) or []

    updated_data = [item for item in existing_data if item.get('component_name') != component_name]

    with open(file_path, 'w') as f:
        yaml.dump(updated_data, f, default_flow_style=False)


def write_to_log_file(event):
    # log_file = '../../logs/install-logs.txt'
    log_file = os.path.join(os.path.dirname(__file__), '..', '..', 'logs', 'install-logs.txt')
    # log_file = os.path.join(os.path.dirname(__file__),  '..', 'logs', 'install-logs.txt')

    with open(log_file, 'a') as file:
        file.write(str(datetime.now()) + '---' + event + '\n')


def write_migrations_to_log_file(event):
    # log_file = '../../logs/migrations-logs.txt'
    log_file = os.path.join(os.path.dirname(__file__), '..', '..', 'logs', 'migrations-logs.txt')

    with open(log_file, 'a') as file:
        file.write(str(datetime.now()) + '---' + event + '\n')


##### routes #####
@components_bp.route('/get-user-ip', methods=['GET'])
def get_user_ip():
    ip_url = 'http://checkip.dyndns.org'
    response = requests.get(ip_url)
    user_ip = re.search(r'\b(?:\d{1,3}\.){3}\d{1,3}\b', response.text).group()
    K2.user_ip = user_ip
    return user_ip


@components_bp.route('/change_language/<lang>')
def change_language(lang):
    '''роут зміни мови'''
    from flask_login import LoginManager
    if hasattr(app, 'login_manager') and isinstance(app.login_manager,
                                                    LoginManager) and current_user.is_authenticated:

        from components.k2site.k2site.models import K2users
        user_id = current_user.get_id()
        user = K2users.query.get(user_id)
        user.locale = lang
        K2.current_language = user.locale
        session['lang'] = lang
        db.session.commit()

    else:
        K2.current_language = ''
    session['lang'] = lang
    return redirect(request.referrer)


@components_bp.route('/', methods=['GET', 'POST'])
def home():
    '''головна сторінка'''
    try:
        components_folder = 'components'
        with open(f"{components_folder}/components.yml", 'r') as file:
            components_data = yaml.safe_load(file)
        if components_data is None:
            return redirect(url_for('components.add_db_credent'))
        k2site_component = next(
            (comp for comp in components_data['components'] if
             comp['name'] == 'k2site' and comp.get('installed', False)),
            None)
        config = K2().init_db_uri()
        if config is None and k2site_component:
            return redirect(url_for('k2site.main_page_public'))
        K2.app_root_path = current_app.root_path
        # Перевіряємо наявність необхідних ключів у конфігурації
        if config is not None and all(key in config for key in ['driver', 'user', 'password', 'host', 'dbname']):
            ####
            try:
                conn = db.engine.connect()
                # connection.close()

            except SQLAlchemyError as e:
                # Помилка з'єднання, переадресувати на сторінку введення даних підключення
                flash('Database connection error. Check the correctness of the data.', 'error')
                return redirect(url_for('components.add_db_credent'))
            finally:
                conn.close()
                # db.engine.dispose()

            components_folder = 'components'
            with open(f"{components_folder}/components.yml", 'r') as file:
                components_data = yaml.safe_load(file)
            if components_data is None:
                return redirect('/dashboards')
            k2site_component = next(
                (comp for comp in components_data['components'] if
                 comp['name'] == 'k2site' and comp.get('installed', False)),
                None)
            if k2site_component:
                K2.user_agent = request.user_agent.string
                return redirect(url_for('k2site.main_page_public'))  #
            else:
                return redirect('/dashboards')

    except FileNotFoundError as e:
        logging.error(f"Error connection to db  {str(e)}")
    return redirect(url_for('components.add_db_credent'))


@components_bp.route('/add-db-credent', methods=['GET', 'POST'])
def add_db_credent():
    '''сторінка внесення підключень до бд'''
    # print(request.headers.get('User-Agent'))
    if request.method == 'POST':
        # Отримуємо дані для підключення, якщо було відправлено форму
        driver = request.form['driver']
        user = request.form['user']
        password = request.form['password']
        host = request.form['host']
        port = request.form['port']
        dbname = request.form['dbname']

        if driver == 'sqlite':
            config = None
            port = None
        elif driver == 'postgresql':
            # Зберігаємо дані у YML-файл
            config = {
                'driver': driver,
                'user': user,
                'password': password,
                'host': host,
                'port': port,
                'dbname': dbname
            }
        elif driver == 'mysql+mysqlconnector':
            # Зберігаємо дані у YML-файл
            config = {
                'driver': driver,
                'user': user,
                'password': password,
                'host': host,
                'port': port,
                'dbname': f"{dbname}?charset=utf8mb4"
            }
        K2.db_driver = driver
        # if driver != 'sqlite':
        try:
            with open(f'{K2.path_db}/db.yml', 'w') as f:
                yaml.dump(config, f)
        except FileNotFoundError as e:
            logging.error(f'Not found db.yml {str(e)}')
        try:
            # response = requests.get(f'{K2.update_domain}k2update/api/components')
            # json_data = response.json()
            json_data = K2Upd.get_k2update_components()

        except Exception as e:
            logging.error(f"Update server is not avaible")
            return f"Update server is not avaible {str(e)}<meta http-equiv='refresh' content='0;url=/dashboards'/>"

        component_name = 'k2site'
        selected_component = next((component for component in json_data if component['name'] == component_name),
                                  None)
        component_id = selected_component['id']
        try:
            # init db from form
            if 'sqlalchemy' in app.extensions:
                app.extensions.pop('sqlalchemy')
            app.config['SQLALCHEMY_DATABASE_URI'] = K2().init_db()

            db_uri = K2().init_db()
            db.init_app(app)
            K2.db = db
            engine = create_engine(db_uri)
            connection = engine.connect()
            # З'єднання успішне, переадресувати на дашборд і вивести повідомлення
            flash('Database connection successful!', 'error')
            logging.info(f'{driver} database connection successful!')
            K2.create_system_settings()
            return redirect(url_for('components.dashboards'))
        except SQLAlchemyError as e:
            # Помилка з'єднання, переадресувати на сторінку введення даних підключення
            flash('Database connection error. Check the correctness of the data.', 'error')
            logging.error(f'{driver} database connection error: %s, {str(e)}')
            return redirect(url_for('components.add_db_credent'))
        finally:
            db.session.close()
            db.engine.dispose()
    return render_template('add-db-credent.html')


@components_bp.route('/dashboards')
def dashboards():
    '''dacsboard'''
    config = K2().init_db_uri()

    # Перевіряємо наявність необхідних ключів у конфігурації
    if K2.db_driver != 'sqlite':
        if config is not None and all(key in config for key in ['driver', 'user', 'password', 'host', 'dbname']):
            ####
            try:
                db.engine.connect()
                # connection.close()

            except SQLAlchemyError as e:
                # Помилка з'єднання, переадресувати на сторінку введення даних підключення
                flash('Database connection error. Check the correctness of the data.', 'error')
                return redirect(url_for('components.add_db_credent'))
            finally:
                db.session.close_all()
                db.engine.dispose()
        else:
            return redirect(url_for('components.add_db_credent'))
    else:
        try:
            # print('db', db)
            db.engine.connect()
        except SQLAlchemyError as e:
            # Помилка з'єднання, переадресувати на сторінку введення даних підключення
            flash('Database connection error. Check the correctness of the data.', 'error')
        finally:
            db.session.close_all()
            db.engine.dispose()
    components_names = []
    components = K2.ins_search_comp()['components']
    components_names = [component['name'] for component in components]
    k2site_component = next(
        (comp for comp in components if comp['name'] == 'k2site' and comp.get('installed', False)),
        None)
    if k2site_component:
        return redirect(url_for('components.component_list_dasb'))
    else:
        # Компоненти доступні для встановлення
        # GET-запит до API
        try:
            # response = requests.get(f'{K2.update_domain}/k2update/api/components')
            # json_data = response.json()
            json_data = K2Upd.get_k2update_components()
            # Перетворення JSON-об'єкту на масив
            component_server = [item for item in json_data]
            # Встановлені компоненти
            # components = Component.query.all()
            # components_names = [component.name for component in components]
            # Отримання значення пошукового запиту з параметрів URL
            search_query = 'k2site'
            # print(search_query)
            filtered_components = []
            if search_query:
                filtered_components = [component for component in component_server if
                                       (search_query.lower() in component['name'].lower() if component[
                                           'name'] else False) or
                                       (search_query.lower() in component['description'].lower() if component[
                                           'description'] else False)]
            else:
                filtered_components = component_server
            current_language = K2.current_language

            return render_template('dashboard.html', components=components,
                                   components_names=components_names, component_server=filtered_components,
                                   search_query=search_query, language=current_language, domain=K2.domain_loc,
                                   version=K2.version)
        except Exception as e:
            logging.error(f"Update server is not avaible")
            print(f'Update server is not avaible {str(e)}')
            component_server = None
            return f'Update server is not avaible {str(e)}'


@components_bp.route('/show_components-site/<string:component_id>')
def show_components_site(component_id):
    '''генерація сторінки із інформацією про вибрану косаоненту'''
    try:
        # response = requests.get(f'{K2.update_domain}k2update/api/components')
        # json_data = K2Upd.get_k2update_components()
        json_data = K2Upd.get_k2update_components()
        selected_component = next((component for component in json_data if component['id'] == component_id), None)
        # response = requests.get(f'{K2.update_domain}k2update/api/components-options')
        # json_data = response.json()
        json_data = K2Upd.get_k2update_components_options()
        component_options = [item for item in json_data]
        title = selected_component['name']
    except:
        logging.error(f"Update server is not avaible")
        selected_component = None
        component_options = None
        title = ''
    components_data = K2.ins_search_comp()
    if components_data is None or 'components' not in components_data:
        components = []
    else:
        components = components_data['components']
    install_components_names = []
    if components != []:
        for comp in components:
            install_components_names.append(comp['name'])
        # список категорій
        if component_options:
            components_category_app = component_options[0]['components_category_app']
            components_category_theme = component_options[0]['components_category_theme']
            components_programming_languages = component_options[0]['components_programming_languages']
        else:
            components_category_app = None
            components_category_theme = None
            components_programming_languages = None
    try:
        # response = requests.get(f'{K2.update_domain}k2update/api/components-beta')
        # json_data = response.json()
        json_data = K2Upd.get_k2update_components_beta()
        selected_component_beta = [item for item in json_data if
                                   item['name'] == selected_component['name'] and item['latest_version'] >
                                   selected_component['latest_version']]
        selected_component_beta = selected_component_beta[0]


    except:
        component_server = None
        selected_component_beta = None
        logging.error(f"Update server is not avaible")

    return render_template('component-info-site.html', selected_component=selected_component,
                           selected_component_beta=selected_component_beta,
                           install_components_names=install_components_names,
                           title=title, components_category_app=components_category_app,
                           components_category_theme=components_category_theme,
                           components_programming_languages=components_programming_languages)


# @components_bp.route('/components-add')
# @login_required
# def component_add_dasb():
#     '''генерація сторінки із списком компонент доступних для встановлення'''
#     try:
#         update_avaibility = K2Upd.get_k2update_components_update_avaibility()
#         # response = requests.get(f'{K2.update_domain}k2update/api/components?token=')
#         # json_data = response.json()
#         json_data = K2Upd.get_k2update_components()
#         component_server = [item for item in json_data if item['name'] != 'k2root']
#         component_root = [item for item in json_data if item['name'] == 'k2root']
#         # response = requests.get(f'{K2.update_domain}k2update/api/components-options')
#         # json_data = response.json()
#         json_data = K2Upd.get_k2update_components_options()
#         component_options = [item for item in json_data]
#     except:
#         component_server = None
#         component_root = None
#         component_options = None
#         logging.error(f"Update server is not avaible")
#         update_avaibility = [{"update_avaible": 0, "expiry_date": None}]
#     # Отримання значення пошукового запиту з параметрів URL
#     search_query = request.args.get('search_query')
#     # print(search_query)
#     filtered_components = []
#     if component_server:
#         if search_query:
#             encoded_search_query = unquote(search_query.lower())
#             filtered_components = [component for component in component_server if
#                                    (encoded_search_query in component['name'].lower() if component['name'] else False)
#                                    or
#                                    (encoded_search_query in component['description'].lower() if component[
#                                        'description'] else False)
#                                    or (encoded_search_query in component['component_category'].lower() if component[
#                                        'component_category'] else False)
#                                    or
#                                    (encoded_search_query in component['name_lpu'].lower() if component[
#                                        'name_lpu'] else False)
#                                    or
#                                    (encoded_search_query in component['programminglanguage_name'].lower() if component[
#                                        'programminglanguage_name'] else False)
#                                    ]
#
#
#         else:
#             filtered_components = component_server
#     else:
#         filtered_components = "Error"
#
#     # список категорій
#     component_server_category = []
#     if component_server:
#         for comp_s in component_server:
#             category_name = comp_s['component_category']
#             component_server_category.append(category_name)
#     component_server_category = list(set(component_server_category))
#     if component_options:
#         components_category_app = component_options[0]['components_category_app']
#         components_category_theme = component_options[0]['components_category_theme']
#         components_programming_languages = component_options[0]['components_programming_languages']
#     else:
#         components_category_app = None
#         components_category_theme = None
#         components_programming_languages = None
#     # список версій
#     component_server_versions = []
#     if component_server:
#         for comp_s in component_server:
#             name = comp_s['name']
#             version = comp_s['latest_version']
#             component_server_versions.append({name: version})
#     project_folder = 'components'
#     # with open(f"{project_folder}/components.yml", 'r') as file:
#     #     components_data = yaml.safe_load(file)
#     components_data = K2.ins_search_comp()
#     components_names = []
#     components_version = []
#     # Отримати імена та версії компонентів з даних YAML
#     if components_data is not None:
#         for component in components_data['components']:
#             name = component['name']
#             version = component['version']
#             components_names.append(name)
#             components_version.append({name: version})
#     # print(components_version)
#     # print(component_server_versions)
#
#     # пошук компонет які потрібно оновити
#     list_for_update = []
#     for component_server in component_server_versions:
#         for key, value in component_server.items():
#             # Шукаємо відповідний елемент у components_version за ключем
#             corresponding_component = next((cmp for cmp in components_version if key in cmp), None)
#             if corresponding_component:
#                 corresponding_value = corresponding_component[key]
#                 # Порівнюємо версії та додаємо елемент у список, якщо значення більше
#                 if LooseVersion(value) > LooseVersion(corresponding_value):
#                     list_for_update.append({key: value})
#     count_update = len(list_for_update)
#
#     return render_template('dashboard-add.html',
#                            component_server=filtered_components, search_query=search_query,
#                            components_names=components_names, components_version=components_version,
#                            k2root_version=K2.version, component_root=component_root, count_update=count_update,
#                            component_server_category=component_server_category, title=gettext('t_components_shop'),
#                            components_category_app=components_category_app,
#                            components_category_theme=components_category_theme,
#                            components_programming_languages=components_programming_languages,
#                            list_for_update=list_for_update,
#                            update_avaibility=update_avaibility)


# @components_bp.route('/components-list')
# @login_required
# def component_list_dasb():
#     '''генерація сторінки із списком встановлених'''
#     # with open(f"components/components.yml", 'r') as file:
#     #     components_data = yaml.safe_load(file)
#     try:
#         update_avaibility = K2Upd.get_k2update_components_update_avaibility()
#     except:
#         update_avaibility = [{"update_avaible": 0, "expiry_date": None}]
#     components_data = K2.ins_search_comp()
#     if components_data is None or 'components' not in components_data:
#         components = []
#     else:
#         components = components_data['components']
#     try:
#         # response = requests.get(f'{K2.update_domain}k2update/api/components')
#         json_data = K2Upd.get_k2update_components()
#         # json_data = response.json()
#         component_server = [item for item in json_data]
#         # response = requests.get(f'{K2.update_domain}k2update/api/components-options')
#         # json_data = response.json()
#         json_data = K2Upd.get_k2update_components_options()
#         component_options = [item for item in json_data]
#     except:
#         component_server = None
#         component_options = None
#         logging.error(f"Update server is not avaible")
#     components_names = []
#     components_version = []
#     component_server_versions = []
#     # список категорій
#     if component_options:
#         components_category_app = component_options[0]['components_category_app']
#         components_category_theme = component_options[0]['components_category_theme']
#         components_programming_languages = component_options[0]['components_programming_languages']
#     else:
#         components_category_app = None
#         components_category_theme = None
#         components_programming_languages = None
#
#     # Отримати імена та версії компонентів з даних YAML
#     count_update = 0
#     if component_server is not None:
#         for component in component_server:
#             name = component['name']
#             version = component['latest_version']
#             components_names.append(name)
#             components_version.append({name: version})
#
#         for comp_s in component_server:
#             name = comp_s['name']
#             version = comp_s['latest_version']
#             component_server_versions.append({name: version})
#         # пошук компонет які потрібно оновити
#
#         for component in components:
#             for component_upd_ver in components_version:
#                 for key, value in component_upd_ver.items():
#                     if key == component['name'] and LooseVersion(value) > LooseVersion(component['version']):
#                         count_update += 1
#
#     return render_template('dashboard-list.html', components=components, components_names=components_names,
#                            components_version=components_version, k2root_version=K2.version, count_update=count_update,
#                            title=gettext('t_installed_components'), components_category_app=components_category_app,
#                            components_category_theme=components_category_theme,
#                            components_programming_languages=components_programming_languages,
#                            update_avaibility=update_avaibility)  # menu=menu_data)
#
#
# @components_bp.route('/components-update')
# @login_required
# def component_upd_list():
#     '''генерація сторінки із списком оновлень'''
#     try:
#         # response = requests.get(f'{K2.update_domain}k2update/api/components')
#         json_data = K2Upd.get_k2update_components()
#         response_beta = requests.get(f'{K2.update_domain}k2update/api/components-beta')
#
#         # json_data = response.json()
#         # json_data_beta = response_beta.json()
#         json_data_beta = K2Upd.get_k2update_components_beta()
#         component_server = [item for item in json_data if item['name'] != 'k2root']
#         component_server_beta = [item for item in json_data_beta if item['name'] != 'k2root']
#
#         component_root = [item for item in json_data if item['name'] == 'k2root']
#         # response = requests.get(f'{K2.update_domain}k2update/api/components-options')
#         # json_data = response.json()
#         json_data = K2Upd.get_k2update_components_options()
#         component_options = [item for item in json_data]
#     except:
#         component_server = None
#         component_server_beta = None
#         component_root = None
#         component_options = None
#         logging.error(f"Update server is not available")
#
#     # Отримання значення пошукового запиту з параметрів URL
#     search_query = request.args.get('search_query')
#     filtered_components = []
#     filtered_components_beta = []
#     # список категорій
#     if component_options:
#         components_category_app = component_options[0]['components_category_app']
#         components_category_theme = component_options[0]['components_category_theme']
#         components_programming_languages = component_options[0]['components_programming_languages']
#     else:
#         components_category_app = None
#         components_category_theme = None
#         components_programming_languages = None
#
#     if search_query:
#         filtered_components = [component for component in component_server if
#                                (search_query.lower() in component['name'].lower() if component[
#                                    'name'] else False) or
#                                (search_query.lower() in component['description'].lower() if component[
#                                    'description'] else False)]
#         filtered_components_beta = [component for component in component_server_beta if
#                                     (search_query.lower() in component['name'].lower() if component[
#                                         'name'] else False) or
#                                     (search_query.lower() in component['description'].lower() if component[
#                                         'description'] else False)]
#     else:
#         filtered_components = component_server
#         filtered_components_beta = component_server_beta
#
#     component_server_versions = []
#     component_server_versions_beta = []
#
#     if component_server is not None:
#         for comp_s in component_server:
#             name = comp_s['name']
#             version = comp_s['latest_version']
#             component_server_versions.append({name: version})
#
#     if component_server_beta is not None:
#         for comp_b in component_server_beta:
#             name = comp_b['name']
#             version = comp_b['latest_version']
#             component_server_versions_beta.append({name: version})
#
#     project_folder = 'components'
#     components_data = K2.ins_search_comp()
#     components_names = []
#     components_version = []
#
#     if components_data is not None:
#         for component in components_data['components']:
#             name = component['name']
#             version = component['version']
#             components_names.append(name)
#             components_version.append({name: version})
#
#     # пошук компонентів, для яких доступні оновлення
#     list_for_update = []
#     list_for_update_beta = []
#     list_for_update_name = []
#     list_for_update_name_beta = []
#
#     for component_server in component_server_versions:
#         for key, value in component_server.items():
#             # Шукаємо відповідний елемент у components_version за ключем
#             corresponding_component = next((cmp for cmp in components_version if key in cmp), None)
#
#             if corresponding_component:
#                 corresponding_value = corresponding_component[key]
#                 # Порівнюємо версії та додаємо елемент у список, якщо значення більше
#                 if LooseVersion(value) > LooseVersion(corresponding_value):
#                     list_for_update.append({key: value})
#                     list_for_update_name.append(key)
#
#     for component_server_beta in component_server_versions_beta:
#         for key, value in component_server_beta.items():
#             # Шукаємо відповідний елемент у components_version за ключем
#             corresponding_component = next((cmp for cmp in components_version if key in cmp), None)
#
#             if corresponding_component:
#                 corresponding_value = corresponding_component[key]
#                 # Порівнюємо версії та додаємо елемент у список, якщо значення більше
#                 if LooseVersion(value) > LooseVersion(corresponding_value):
#                     list_for_update_beta.append({key: value})
#                     list_for_update_name_beta.append(key)
#
#     count_update = len(list_for_update)
#     count_update_beta = len(list_for_update_beta)
#     update_avaibility = K2Upd.get_k2update_components_update_avaibility()
#
#     return render_template('update-components-list.html',
#                            search_query=search_query, component_server=filtered_components,
#                            component_server_beta=filtered_components_beta, components_names=components_names,
#                            components_version=components_version, k2root_version=K2.version,
#                            component_root=component_root, count_update=count_update,
#                            count_update_beta=count_update_beta, list_for_update=list_for_update,
#                            list_for_update_beta=list_for_update_beta, list_for_update_name=list_for_update_name,
#                            list_for_update_name_beta=list_for_update_name_beta, title=gettext('t_update_component'),
#                            components_category_app=components_category_app,
#                            components_category_theme=components_category_theme,
#                            components_programming_languages=components_programming_languages,
#                            update_avaibility=update_avaibility)


@components_bp.route('/components-license-key', methods=['GET', 'POST'])
@login_required
def components_license_key():
    '''генерація сторінки із формою введення ліцензійного ключа'''
    update_avaibility = K2Upd.get_k2update_components_update_avaibility()
    from components.k2site.k2site.forms import LicenseKeyForm
    form = LicenseKeyForm()
    if request.method == "POST":
        if form.validate_on_submit():
            license_key = form.license_key.data

            # Шлях до файлу
            file_path = os.path.join(os.path.dirname(__file__), '..', '..', 'cfg', 'k2', 'license', 'key.yml')

            # Перевірка чи існує директорія, якщо ні - створити її
            os.makedirs(os.path.dirname(file_path), exist_ok=True)

            # Збереження ліцензійного ключа у файл
            with open(file_path, 'w') as file:
                yaml.dump({'license_key': license_key}, file)
            flash('License key saved successfully! ')
            K2.update_token = license_key
            reload_app()
            update_avaibility = K2Upd.get_k2update_license_key_avaibility(license_key)
            return redirect(url_for('components.components_license_key', update_avaibility=update_avaibility, parent='/components-license-key'))

    return render_template('dashboard-license-key.html',
                           form=form,
                           update_avaibility=update_avaibility)


# @components_bp.route('/install-component/<string:component_id>')
# # @login_required
# def install_component(component_id):
#     '''генерація сторінки з прогресбаром встановлення компоненти'''
#     try:
#         # response = requests.get(f'{K2.update_domain}k2update/api/components')
#         json_data = K2Upd.get_k2update_components()
#         # json_data = response.json()
#         selected_component = next((component for component in json_data if component['id'] == component_id), None)
#         if selected_component is None:
#             return 'Component not found'
#         component_name = selected_component['name']
#     except:
#         logging.error(f"Update server is not avaible")
#
#     return render_template('install-components-sio.html', component_name=component_name, component_id=component_id)


#
# @components_bp.route('/install-component-progress/<string:component_id>')
# # @login_required
# def install_component_progress(component_id):
#     '''генерація сторінки з прогресбаром встановлення компоненти'''
#     try:
#         # response = requests.get(f'{K2.update_domain}k2update/api/components')
#         json_data = K2Upd.get_k2update_components()
#         # json_data = response.json()
#         selected_component = next((component for component in json_data if component['id'] == component_id), None)
#         if selected_component is None:
#             return 'Component not found'
#         component_name = selected_component['name']
#     except:
#         logging.error(f"Update server is not avaible")
#     return render_template('install-components.html', component_name=component_name, component_id=component_id)


@components_bp.route('/install-component-progress-beta/<string:component_id>')
@login_required
def install_component_progress_beta(component_id):
    '''генерація сторінки з прогресбаром встановлення тестової версії компоненти'''
    try:
        # response = requests.get(f'{K2.update_domain}k2update/api/components-beta')
        # json_data = response.json()
        json_data = K2Upd.get_k2update_components_beta()
        selected_component = next((component for component in json_data if component['id'] == component_id), None)
        if selected_component is None:
            return 'Component not found'
        component_name = selected_component['name']
    except:
        logging.error(f"Update server is not avaible")
    return render_template('install-components-beta.html', component_name=component_name, component_id=component_id)


@components_bp.route('/install-component-progress-k2site/<string:component_id>')
def install_component_progress_k2site(component_id):
    '''генерації сторінки з прогресбаром першого встановлення компоненти k2site'''
    try:
        # response = requests.get(f'{K2.update_domain}k2update/api/components')
        json_data = K2Upd.get_k2update_components()
        # json_data = response.json()
        selected_component = next((component for component in json_data if component['id'] == component_id), None)
        if selected_component is None:
            return 'Component not found'
        component_name = selected_component['name']
    except:
        logging.error(f"Update server is not avaible")
    return render_template('install-components-k2site.html', component_name=component_name, component_id=component_id)


@components_bp.route('/update-component-progress-old/<string:component_id>')
@login_required
def update_component_progress(component_id):
    '''генерація сторінки з прогресбаром оновлення компоненти'''
    try:
        # response = requests.get(f'{K2.update_domain}k2update/api/components')
        # json_data = response.json()
        json_data = K2Upd.get_k2update_components()
        selected_component = next((component for component in json_data if component['id'] == component_id), None)
        if selected_component is None:
            return 'Component not found'
        # Отримати посилання на архів компоненти та версію
        component_name = selected_component['name']
    except:
        logging.error(f"Update server is not avaible")
    return render_template('update-components_old.html', component_name=component_name, component_id=component_id)


@components_bp.route('/update-component-progress-beta/<string:component_id>')
@login_required
def update_component_progress_beta(component_id):
    '''генерація сторінки з прогресбаром оновлення тестової версії компоненти'''
    try:
        # response = requests.get(f'{K2.update_domain}k2update/api/components-beta')
        # json_data = response.json()
        json_data = K2Upd.get_k2update_components_beta()
        selected_component = next((component for component in json_data if component['id'] == component_id), None)
        if selected_component is None:
            return 'Component not found'
        # Отримати посилання на архів компоненти та версію
        component_name = selected_component['name']
    except:
        logging.error(f"Update server is not avaible")
    return render_template('update-components-beta-new.html', component_name=component_name, component_id=component_id)


@components_bp.route('/update-component-all-progress')
@login_required
def update_component_all_progress():
    '''генерація сторінки з прогресбаром оновлення всіх компонент'''
    try:
        # response = requests.get(f'{K2.update_domain}k2update/api/components')
        # json_data = response.json()
        json_data = K2Upd.get_k2update_components()
        component_server = [item for item in json_data if item['name'] != 'k2root']
        component_root = [item for item in json_data if item['name'] == 'k2root']
    except:
        component_server = None
        component_root = None
        logging.error(f"Update server is not avaible")
        # пошук компонет які потрібно оновити
    component_server_versions = []
    for comp_s in component_server:
        name = comp_s['name']
        version = comp_s['latest_version']
        component_server_versions.append({name: version})
    components_data = K2.ins_search_comp()
    components_names = []
    components_version = []
    # Отримати імена та версії компонентів з даних YAML
    if components_data is not None:
        for component in components_data['components']:
            name = component['name']
            version = component['version']
            components_names.append(name)
            components_version.append({name: version})
    # порівняємо версії і формуємо список для оновлення
    list_for_update = []
    count_update = 0
    for component_server_itm in component_server_versions:
        for key, value in component_server_itm.items():
            # Шукаємо відповідний елемент у components_version за ключем
            corresponding_component = next((cmp for cmp in components_version if key in cmp), None)
            if corresponding_component:
                corresponding_value = corresponding_component[key]
                # Порівнюємо версії та додаємо елемент у список, якщо значення більше
                if value > corresponding_value:
                    list_for_update.append({key: value})

    count_update = len(list_for_update)
    # print(list_for_update)
    # print(component_server)
    # пошук id компоненти по імені
    output_list = []
    for update_item in list_for_update:
        key, value = list(update_item.items())[0]
        for server_item in component_server:
            if server_item['name'] == key:
                output_list.append({key: server_item['id']})

    if count_update > 0:
        return render_template('update-components-all.html', update_component_list=output_list)
    else:
        return redirect('/components-list')


@components_bp.route('/update-k2cloud-system')
@login_required
def update_k2cloud_system():
    '''генерація сторінки з прогресбаром оновлення ядра системи'''

    try:
        # response = requests.get(f'{K2.update_domain}k2update/api/components')
        json_data = K2Upd.get_k2update_components()
        # json_data = response.json()
        component_server = [item for item in json_data if item['name'] == 'k2root']
    except:
        component_server = None
        logging.error(f"Update server is not avaible")
    return render_template('update-system.html', component=component_server)


@components_bp.route('/update-k2cloud-root')
def update_k2cloud_root():
    '''роут оновлення ядра системи'''
    from app import app
    app.blueprints.pop('components')
    try:
        # response = requests.get(f'{K2.update_domain}k2update/api/components')
        json_data = K2Upd.get_k2update_components()
        # json_data = response.json()
        component_server = [item for item in json_data if item['name'] == 'k2root']
    except:
        component_server = None
        logging.error("Сервер оновлень недоступний")
        return jsonify(message="Помилка отримання даних від сервера оновлень", status="error")

    if not component_server:
        return jsonify(message="Компоненту k2root не знайдено на сервері оновлень", status="error")

    project_folder = ''
    archive_url = component_server[0]['latest_component_data']
    version = component_server[0]['latest_version']

    try:
        response = requests.get(archive_url, stream=True)
        response.raise_for_status()

        archive_filename = "k2root.zip"
        archive_path = os.path.join(project_folder, archive_filename)

        with open(archive_path, "wb") as file:
            for chunk in response.iter_content(chunk_size=8192):
                file.write(chunk)
        with zipfile.ZipFile(archive_path, "r") as zip_ref:
            # Витягування файлів без зміни шляху
            zip_ref.extractall(project_folder)

        os.remove(archive_path)

        logging.info(f"Успішно скопійовано файли компоненти: {component_server[0]['name']} v{version}")
        event = f"Оновлення {component_server[0]['name']}"
        write_to_log_file(event)
        # reload_app_configs_del('components_bp')
        # reload_app()
        K2.search_babel_translation_directories()
        if 'babel' in app.extensions:
            app.extensions.pop('babel')
        from app import babel
        K2.load_babel_translation_directories()
        app.config['BABEL_TRANSLATION_DIRECTORIES'] = K2.babel_translation_directories
        app.config['BABEL_LANGUAGES'] = K2.languages
        app.config['BABEL_DEFAULT_TIMEZONE'] = K2.timezone
        babel.init_app(app, locale_selector=K2.get_locale,
                       default_translation_directories=K2.babel_translation_directories)
        app.register_blueprint(components_bp)
        K2Menu.add_to_menu_install('k2')
        K2().search_menu_items()
        K2().search_menu_items_category()
        return jsonify(
            message=f"Файли успішно оновлено...<span class='mdi mdi-check'></span> <a href='#'>детальніше</a>",
            status="success")
    except Exception as e:
        logging.error(f"Помилка оновлення k2root: {str(e)}")
        return jsonify(
            message=f"Помилка оновлення k2root...<span class='mdi mdi-check'></span> <a href='#'>детальніше</a>",
            status="error")


@components_bp.route('/install_components-one-request/<string:component_id>')
def install_component_from_archive_one_request(component_id):
    '''роут встановлення  комаоненти'''
    # Шлях до головної папки проекту
    project_folder = 'components'
    # Отримати відповідну компоненту зі списку компонент
    try:
        # response = requests.get(f'{K2.update_domain}k2update/api/components')
        json_data = K2Upd.get_k2update_components()
        # json_data = response.json()
        selected_component = next((component for component in json_data if component['id'] == component_id), None)
        if selected_component is None:
            return 'Component not found'
        # Отримати посилання на архів компоненти та версію
        archive_url = selected_component['latest_component_data']
        version = selected_component['latest_version']
    except:
        logging.error(f"Update server is not avaible")
    try:
        # Створити шлях до папки компоненти згідно назви та версії
        component_folder = os.path.join(project_folder)
        os.makedirs(component_folder, exist_ok=True)
        # Завантажити архів компоненти
        response = requests.get(archive_url, stream=True)
        response.raise_for_status()
        # Шлях до завантаженого архіву
        archive_path = os.path.join(component_folder, f"{selected_component['name']}.zip")
        # Зберегти архів на диск
        with open(archive_path, "wb") as file:
            for chunk in response.iter_content(chunk_size=8192):
                file.write(chunk)
        # Розпакувати архів
        with zipfile.ZipFile(archive_path, "r") as zip_ref:
            zip_ref.extractall(component_folder)
        # Видалити архів
        os.remove(archive_path)
        # перейменувати якщо git
        component_name = selected_component['name']
        old_folder_path = os.path.join(component_folder, component_name + ".git")
        new_folder_path = os.path.join(component_folder, component_name)
        # Перевірка наявності папки зі старою назвою
        if os.path.exists(old_folder_path) and os.path.isdir(old_folder_path):
            # Перейменування папки зі старою назвою на нову назву
            os.rename(old_folder_path, new_folder_path)

        file_path = f"{project_folder}/{selected_component['name']}/reguirements-components.txt"
        dependencies = []
        if os.path.isfile(file_path):  # Перевірка наявності файлу
            try:
                with open(file_path, 'r') as file:
                    dependencies = file.readlines()
                    dependencies = [dep.strip() for dep in dependencies]
                    dependencies = ', '.join(dependencies)
            except Exception as e:
                logging.error(f"{file_path} Not found   {str(e)}")
        else:
            pass

        try:
            # Зчитати вміст файлу YAML
            with open(f"{project_folder}/components.yml", 'r') as file:
                components_data = yaml.safe_load(file)
        except FileNotFoundError as e:
            logging.error(f"Not found  {str(e)}")
        if components_data == None:
            components_data = {'components': []}

        # Перевірити унікальність імен компонентів
        existing_component = next((c for c in components_data['components'] if c['name'] == selected_component['name']),
                                  None)
        if existing_component:
            # Оновити існуючий компонент
            existing_component['id'] = generate_id()
            existing_component['version'] = version
            existing_component['dependencies'] = dependencies
            existing_component['installed'] = True
        else:
            # Додати новий компонент до списку
            components_data['components'].append({
                'id': generate_id(),
                'name': selected_component['name'],
                'version': version,
                'dependencies': dependencies,
                'installed': True
            })

        # Записати оновлений вміст у файл YAML
        with open(f"{project_folder}/components.yml", 'w', encoding='utf-8') as file:
            yaml.dump(components_data, file)
        reload_app_configs(selected_component['name'])
        reload_app()
        K2.search_babel_translation_directories()
        if 'babel' in app.extensions:
            app.extensions.pop('babel')
        from app import babel
        K2.load_babel_translation_directories()
        app.config['BABEL_TRANSLATION_DIRECTORIES'] = K2.babel_translation_directories
        app.config['BABEL_LANGUAGES'] = K2.languages
        app.config['BABEL_DEFAULT_TIMEZONE'] = K2.timezone
        babel.init_app(app, locale_selector=K2.get_locale,
                       default_translation_directories=K2.babel_translation_directories)
        K2Menu.add_to_menu_install('k2')
        K2Menu.add_to_menu_install(selected_component['name'])
        K2().search_menu_items()
        K2().search_menu_items_category()

        logging.info(f"Copying component files is successful: {selected_component['name']} v{version}")
        event = f"Install component {selected_component['name']} "
        write_to_log_file(event)
        logging.info(f"Copying component files is successful: {selected_component['name']} v{version}")
        return jsonify(
            message=f"Файли компоненти успішно скопійовані...<span class='mdi mdi-check'></span> <a href='#'>детальніше</a>",
            status="success")
    except Exception as e:
        requests.get(f"{K2.domain_loc}/remove-component/{component_id}")
        logging.error(f"Error install component {selected_component['name']}: {str(e)}")
        return jsonify(
            message=f"Помилка копіювання файлів компоненти...<span class='mdi mdi-check'></span> <a href='#'>детальніше</a>",
            status="error")


@components_bp.route('/install_components-one-request-beta/<string:component_id>')
def install_component_from_archive_one_request_beta(component_id):
    '''роут встановлення тестової версії комаоненти'''
    # Шлях до головної папки проекту
    project_folder = 'components'
    # Отримати відповідну компоненту зі списку компонент
    try:
        # response = requests.get(f'{K2.update_domain}k2update/api/components-beta')
        # json_data = response.json()
        json_data = K2Upd.get_k2update_components_beta()
        selected_component = next((component for component in json_data if component['id'] == component_id), None)
        if selected_component is None:
            return 'Component not found'
        # Отримати посилання на архів компоненти та версію
        archive_url = selected_component['latest_component_data']
        version = selected_component['latest_version']
    except:
        logging.error(f"Update server is not avaible")
    try:
        # Створити шлях до папки компоненти згідно назви та версії
        component_folder = os.path.join(project_folder)
        os.makedirs(component_folder, exist_ok=True)
        # Завантажити архів компоненти
        response = requests.get(archive_url, stream=True)
        response.raise_for_status()
        # Шлях до завантаженого архіву
        archive_path = os.path.join(component_folder, f"{selected_component['name']}.zip")
        # Зберегти архів на диск
        with open(archive_path, "wb") as file:
            for chunk in response.iter_content(chunk_size=8192):
                file.write(chunk)
        # Розпакувати архів
        with zipfile.ZipFile(archive_path, "r") as zip_ref:
            zip_ref.extractall(component_folder)
        # Видалити архів
        os.remove(archive_path)
        # перейменувати якщо git
        component_name = selected_component['name']
        old_folder_path = os.path.join(component_folder, component_name + ".git")
        new_folder_path = os.path.join(component_folder, component_name)
        # Перевірка наявності папки зі старою назвою
        if os.path.exists(old_folder_path) and os.path.isdir(old_folder_path):
            # Перейменування папки зі старою назвою на нову назву
            os.rename(old_folder_path, new_folder_path)

        file_path = f"{project_folder}/{selected_component['name']}/reguirements-components.txt"
        dependencies = []
        if os.path.isfile(file_path):  # Перевірка наявності файлу
            try:
                with open(file_path, 'r') as file:
                    dependencies = file.readlines()
                    dependencies = [dep.strip() for dep in dependencies]
                    dependencies = ', '.join(dependencies)
            except Exception as e:
                logging.error(f"{file_path} Not found   {str(e)}")
        else:
            pass

        try:
            # Зчитати вміст файлу YAML
            with open(f"{project_folder}/components.yml", 'r') as file:
                components_data = yaml.safe_load(file)
        except FileNotFoundError as e:
            logging.error(f"Not found  {str(e)}")
        if components_data == None:
            components_data = {'components': []}

        # Перевірити унікальність імен компонентів
        existing_component = next((c for c in components_data['components'] if c['name'] == selected_component['name']),
                                  None)
        if existing_component:
            # Оновити існуючий компонент
            existing_component['id'] = generate_id()
            existing_component['version'] = version
            existing_component['dependencies'] = dependencies
            existing_component['installed'] = True
        else:
            # Додати новий компонент до списку
            components_data['components'].append({
                'id': generate_id(),
                'name': selected_component['name'],
                'version': version,
                'git_link': selected_component['git_link'],
                'dependencies': dependencies,
                'installed': True
            })

        # Записати оновлений вміст у файл YAML
        with open(f"{project_folder}/components.yml", 'w', encoding='utf-8') as file:
            yaml.dump(components_data, file)
        reload_app_configs(selected_component['name'])
        reload_app()
        K2.search_babel_translation_directories()
        if 'babel' in app.extensions:
            app.extensions.pop('babel')
        from app import babel
        K2.load_babel_translation_directories()
        app.config['BABEL_TRANSLATION_DIRECTORIES'] = K2.babel_translation_directories
        app.config['BABEL_LANGUAGES'] = K2.languages
        app.config['BABEL_DEFAULT_TIMEZONE'] = K2.timezone
        babel.init_app(app, locale_selector=K2.get_locale,
                       default_translation_directories=K2.babel_translation_directories)
        K2Menu.add_to_menu_install(selected_component['name'])
        K2().search_menu_items()
        K2().search_menu_items_category()

        logging.info(f"Copying component files is successful: {selected_component['name']} v{version}")
        event = f"Install component {selected_component['name']} "
        write_to_log_file(event)
        return jsonify(
            message=f"Файли компоненти успішно скопійовані...<span class='mdi mdi-check'></span> <a href='#'>детальніше</a>",
            status="success")
    except Exception as e:
        requests.get(f"{K2.domain_loc}/remove-component/{component_id}")
        logging.error(f"Error install component {selected_component['name']}: {str(e)}")
        return jsonify(
            message=f"Помилка копіювання файлів компоненти...<span class='mdi mdi-check'></span> <a href='#'>детальніше</a>",
            status="error")


@components_bp.route('/update_components/<string:component_id>')
def update_components_from_archive(component_id):
    '''роут оновлення компоненти'''
    # Шлях до головної папки проекту
    project_folder = 'components'
    # Отримати відповідну компоненту зі списку компонент
    try:
        # response = requests.get(f'{K2.update_domain}k2update/api/components')
        json_data = K2Upd.get_k2update_components()
        # json_data = response.json()
        selected_component = next((component for component in json_data if component['id'] == component_id), None)
        if selected_component is None:
            return 'Component not found'
        # Отримати посилання на архів компоненти та версію
        archive_url = selected_component['latest_component_data']
        version = selected_component['latest_version']
    except:
        logging.error(f"Update server is not avaible")
    try:
        reload_app_configs_del(selected_component['name'])
        # Створити шлях до папки компоненти згідно назви та версії
        component_folder = os.path.join(project_folder)
        os.makedirs(component_folder, exist_ok=True)
        # Завантажити архів компоненти
        response = requests.get(archive_url, stream=True)
        response.raise_for_status()
        # Шлях до завантаженого архіву
        archive_path = os.path.join(component_folder, f"{selected_component['name']}.zip")
        # Зберегти архів на диск
        with open(archive_path, "wb") as file:
            for chunk in response.iter_content(chunk_size=8192):
                file.write(chunk)
        # Видалення всіх файлів та папок у папці static
        static_folder = os.path.join(component_folder, selected_component['name'], selected_component['name'], 'static')
        # print(static_folder)
        if os.path.exists(static_folder) and os.path.isdir(static_folder):
            try:
                shutil.rmtree(static_folder)
            except Exception as e:
                logging.error(f"Error deleting static folder {static_folder}: {str(e)}")
        # Розпакувати архів
        with zipfile.ZipFile(archive_path, "r") as zip_ref:
            zip_ref.extractall(component_folder)
        # Видалити архів
        os.remove(archive_path)
        # перейменувати якщо git
        component_name = selected_component['name']
        old_folder_path = os.path.join(component_folder, component_name + ".git")
        new_folder_path = os.path.join(component_folder, component_name)
        # Перевірка наявності папки зі старою назвою
        if os.path.exists(old_folder_path) and os.path.isdir(old_folder_path):
            # Перейменування папки зі старою назвою на нову назву
            os.rename(old_folder_path, new_folder_path)

        try:
            # Зчитати вміст файлу YAML
            with open(f"{project_folder}/components.yml", 'r') as file:
                components_data = yaml.safe_load(file)
        except FileNotFoundError as e:
            logging.error(f"Not found  {str(e)}")
        if components_data == None:
            components_data = {'components': []}

        # Перевірити унікальність імен компонентів
        existing_component = next((c for c in components_data['components'] if c['name'] == selected_component['name']),
                                  None)
        if existing_component:
            # Оновити існуючу компоненту
            existing_component['id'] = generate_id()
            existing_component['version'] = version
            existing_component['installed'] = True
        else:
            # Додати новий компонент до списку
            components_data['components'].append({
                'id': generate_id(),
                'name': selected_component['name'],
                'version': version,
                'git_link': selected_component['git_link'],
                'installed': True
            })

        # Записати оновлений вміст у файл YAML
        with open(f"{project_folder}/components.yml", 'w') as file:
            yaml.dump(components_data, file)
        reload_app_configs(selected_component['name'])
        reload_app()
        K2.search_babel_translation_directories()
        if 'babel' in app.extensions:
            app.extensions.pop('babel')
        from app import babel
        K2.load_babel_translation_directories()
        app.config['BABEL_TRANSLATION_DIRECTORIES'] = K2.babel_translation_directories
        app.config['BABEL_LANGUAGES'] = K2.languages
        app.config['BABEL_DEFAULT_TIMEZONE'] = K2.timezone
        babel.init_app(app, locale_selector=K2.get_locale,
                       default_translation_directories=K2.babel_translation_directories)
        K2Menu.add_to_menu_install(selected_component['name'])
        K2().search_menu_items()
        K2().search_menu_items_category()

        logging.info(f"Component updated successfully: {selected_component['name']} v{version}")
        return jsonify(
            message=f"Файли компоненти успішно оновлені...<span class='mdi mdi-check'></span> <a href='#'>детальніше</a>",
            status="success")
    except Exception as e:
        # requests.get(f"{K2.domain_loc}/remove-component/{component_id}")
        logging.error(f"Error update component {selected_component['name']}: {str(e)}")
        return jsonify(
            message=f"Помилка оновлення файлів компоненти...<span class='mdi mdi-check'></span> <a href='#'>детальніше</a>",
            status="error")


@components_bp.route('/update_components-beta/<string:component_id>')
def update_components_from_archive_beta(component_id):
    '''роут оновлення тестової версії компоненти'''
    # Шлях до головної папки проекту
    project_folder = 'components'
    # Отримати відповідну компоненту зі списку компонент
    try:
        # response = requests.get(f'{K2.update_domain}k2update/api/components-beta')
        # json_data = response.json()
        json_data = K2Upd.get_k2update_components_beta()
        selected_component = next((component for component in json_data if component['id'] == component_id), None)
        if selected_component is None:
            return 'Component not found'
        # Отримати посилання на архів компоненти та версію
        archive_url = selected_component['latest_component_data']
        version = selected_component['latest_version']
    except:
        logging.error(f"Update server is not avaible")
    try:
        reload_app_configs_del(selected_component['name'])
        # Створити шлях до папки компоненти згідно назви та версії
        component_folder = os.path.join(project_folder)
        os.makedirs(component_folder, exist_ok=True)
        # Завантажити архів компоненти
        response = requests.get(archive_url, stream=True)
        response.raise_for_status()
        # Шлях до завантаженого архіву
        archive_path = os.path.join(component_folder, f"{selected_component['name']}.zip")
        # Зберегти архів на диск
        with open(archive_path, "wb") as file:
            for chunk in response.iter_content(chunk_size=8192):
                file.write(chunk)
        # Розпакувати архів
        with zipfile.ZipFile(archive_path, "r") as zip_ref:
            zip_ref.extractall(component_folder)
        # Видалити архів
        os.remove(archive_path)
        # перейменувати якщо git
        component_name = selected_component['name']
        old_folder_path = os.path.join(component_folder, component_name + ".git")
        new_folder_path = os.path.join(component_folder, component_name)
        # Перевірка наявності папки зі старою назвою
        if os.path.exists(old_folder_path) and os.path.isdir(old_folder_path):
            # Перейменування папки зі старою назвою на нову назву
            os.rename(old_folder_path, new_folder_path)

        try:
            # Зчитати вміст файлу YAML
            with open(f"{project_folder}/components.yml", 'r') as file:
                components_data = yaml.safe_load(file)
        except FileNotFoundError as e:
            logging.error(f"Not found  {str(e)}")
        if components_data == None:
            components_data = {'components': []}

        # Перевірити унікальність імен компонентів
        existing_component = next((c for c in components_data['components'] if c['name'] == selected_component['name']),
                                  None)
        if existing_component:
            # Оновити існуючий компонент
            existing_component['id'] = generate_id()
            existing_component['version'] = version
            existing_component['installed'] = True
        else:
            # Додати новий компонент до списку
            components_data['components'].append({
                'id': generate_id(),
                'name': selected_component['name'],
                'version': version,
                'git_link': selected_component['git_link'],
                'installed': True
            })

        # Записати оновлений вміст у файл YAML
        with open(f"{project_folder}/components.yml", 'w') as file:
            yaml.dump(components_data, file)
        reload_app_configs(selected_component['name'])
        reload_app()
        K2.search_babel_translation_directories()
        if 'babel' in app.extensions:
            app.extensions.pop('babel')
        from app import babel
        K2.load_babel_translation_directories()
        app.config['BABEL_TRANSLATION_DIRECTORIES'] = K2.babel_translation_directories
        app.config['BABEL_LANGUAGES'] = K2.languages
        app.config['BABEL_DEFAULT_TIMEZONE'] = K2.timezone
        babel.init_app(app, locale_selector=K2.get_locale,
                       default_translation_directories=K2.babel_translation_directories)
        K2Menu.add_to_menu_install(selected_component['name'])
        K2().search_menu_items()
        K2().search_menu_items_category()

        logging.info(f"Component updated successfully: {selected_component['name']} v{version}")
        return jsonify(
            message=f"Файли компоненти успішно оновлені...<span class='mdi mdi-check'></span> <a href='#'>детальніше</a>",
            status="success")
    except Exception as e:
        # requests.get(f"{K2.domain_loc}/remove-component/{component_id}")
        logging.error(f"Error update component {selected_component['name']}: {str(e)}")
        return jsonify(
            message=f"Помилка оновлення файлів компоненти...<span class='mdi mdi-check'></span> <a href='#'>детальніше</a>",
            status="error")


@components_bp.route('/install-requirments-one-request/<string:selected_component_name>', methods=['GET'])
def install_requirments_one_request(selected_component_name):
    '''роут встановлення Python залежностей'''
    try:
        if K2.platform == 'Windows':
            # print(K2.platform)
            # install requirements for windows
            venv_bin_path = os.path.join(os.path.dirname(sys.prefix), 'venv/Scripts')
            if selected_component_name == 'k2root':
                requirements_file = 'requirements.txt'
            else:
                requirements_file = os.path.join('components', selected_component_name, "requirements.txt")
            if os.path.isfile(requirements_file):
                pip_command = f"{venv_bin_path}/python -m pip install -r {requirements_file}"
                subprocess.run(pip_command, shell=True, check=True)
        elif K2.platform == 'Linux':
            # install requirements for linux
            venv_bin_path = os.path.join(os.path.dirname(sys.prefix), 'venv/bin')
            if selected_component_name == 'k2root':
                requirements_file = 'requirements.txt'
            else:
                requirements_file = os.path.join('components', selected_component_name, "requirements.txt")
            if os.path.isfile(requirements_file):
                try:
                    pip_command = f"{venv_bin_path}/python3 -m pip install -r {requirements_file}"
                    subprocess.run(pip_command, shell=True, check=True)
                except:
                    pip_command = f"{venv_bin_path}/python -m pip install -r {requirements_file}"
                    subprocess.run(pip_command, shell=True, check=True)
        logging.info(f"Requirements for {selected_component_name} done successfully")
        return jsonify(
            message=f"Залежності компоненти успішно встановлені...<span class='mdi mdi-check'></span> <a href='#'>детальніше</a>",
            status="success")
    except Exception as e:
        logging.error(f"Error installing requirmets: {str(e)}")
        return jsonify(
            message=f"Помилка встановлення залежностей компоненти...<span class='mdi mdi-check'></span> <a href='#'>детальніше</a>",
            status="error")


def log_migration_output(output):
    output = output.decode('utf-8').strip()
    logging.info(output)


@components_bp.route('/make-migrations-one-reguest/<string:selected_component_name>', methods=['GET'])
def make_migrations_one_reguest(selected_component_name):
    '''роут Створення міграцій'''
    app = current_app
    reload_app_configs(selected_component_name)
    reload_app()
    try:
        migrations_dir = os.path.join(app.root_path, 'migrations')

        if not os.path.exists(migrations_dir):
            init_command = 'flask db init'
            init_result = subprocess.run(init_command, shell=True, check=True, stdout=subprocess.PIPE,
                                         stderr=subprocess.PIPE)
            log_migration_output(init_result.stdout)  # Запис повідомлень про міграцію у лог
            log_migration_output(init_result.stderr)  # Запис повідомлень про помилки у лог

        migrate_command = f"flask db migrate -m '{selected_component_name}'"
        migrate_result = subprocess.run(migrate_command, shell=True, stdout=subprocess.PIPE,
                                        stderr=subprocess.PIPE)
        log_migration_output(migrate_result.stdout)  # Запис повідомлень про міграцію у лог
        write_migrations_to_log_file(str(migrate_result.stdout))
        log_migration_output(migrate_result.stderr)  # Запис повідомлень про помилки у лог
        write_migrations_to_log_file(str(migrate_result.stderr))

        # Перевірка коду помилки після виконання команди
        if migrate_result.returncode != 0:
            raise Exception(f"Migrate command failed with exit code {migrate_result.returncode}")

        upgrade_command = 'flask db upgrade'
        upgrade_result = subprocess.run(upgrade_command, shell=True, stdout=subprocess.PIPE,
                                        stderr=subprocess.PIPE)
        log_migration_output(upgrade_result.stdout)  # Запис повідомлень про міграцію у лог
        write_migrations_to_log_file(str(migrate_result.stdout))
        log_migration_output(upgrade_result.stderr)  # Запис повідомлень про помилки у лог
        write_migrations_to_log_file(str(migrate_result.stderr))

        # Перевірка коду помилки після виконання команди
        if upgrade_result.returncode != 0:
            raise Exception(f"Upgrade command failed with exit code {upgrade_result.returncode}")

        requests.get(f"{K2.domain_loc}/{selected_component_name}/data-migrations")
        logging.info(f"Migrations for {selected_component_name} done successfully")
        return jsonify(
            message=f"Міграції для компоненти успішно виконані. ...<span class='mdi mdi-check'></span> <a href='#'>детальніше</a>",
            status="success")
    except Exception as e:
        with open(f"components/components.yml", 'r') as file:
            components_data = yaml.safe_load(file)
        component_id = None
        for component in components_data.get("components", []):
            if component.get("name") == selected_component_name:
                component_id = component.get("id")
                break
        requests.get(f"{K2.domain_loc}/remove-component/{component_id}")
        logging.error(f"Error make migrations: {str(e)}")
        error_message = f"Error make migrations: {str(e)}"
        return jsonify(
            message=f"Помилка створення міграцій компоненти...<span class='mdi mdi-check'></span> <a href='#'>детальніше</a>",
            status="error")


@components_bp.route('/install-requirments-components-one-request/<string:main_component_id>')
def install_requirements_components_one_request(main_component_id):
    '''роут встановлення залежних компонент'''
    try:
        # response = requests.get(f'{K2.update_domain}k2update/api/components')
        json_data = K2Upd.get_k2update_components()
        # json_data = response.json()
        # print(json_data)
        selected_component = next((component for component in json_data if component['id'] == main_component_id), None)
        if selected_component is None:
            return 'Component not found'
        selected_component_name = selected_component['name']
        archive_url = selected_component['latest_component_data']
        version = selected_component['latest_version']
    except Exception as e:
        logging.error(f"Update server is not avaible {e}")

    # Створити шлях до папки компоненти згідно назви та версії
    project_folder = 'components'
    component_folder = os.path.join(project_folder)
    os.makedirs(component_folder, exist_ok=True)
    # Завантажити архів компоненти
    try:
        response = requests.get(archive_url, stream=True)
        response.raise_for_status()
    except Exception as e:
        logging.error(f"{e}")

    # Шлях до завантаженого архіву
    archive_path = os.path.join(component_folder, f"{selected_component['name']}.zip")
    # Зберегти архів на диск
    try:
        with open(archive_path, "wb") as file:
            for chunk in response.iter_content(chunk_size=4096):
                file.write(chunk)
    except Exception as e:
        logging.error(f"ChunkedEncodingError {e}")
    # Розпакувати архів
    with zipfile.ZipFile(archive_path, "r") as zip_ref:
        zip_ref.extractall(component_folder)
    # Видалити архів
    os.remove(archive_path)
    # перейменувати якщо git
    component_name = selected_component['name']
    old_folder_path = os.path.join(component_folder, component_name + ".git")
    new_folder_path = os.path.join(component_folder, component_name)
    # Перевірка наявності папки зі старою назвою
    if os.path.exists(old_folder_path) and os.path.isdir(old_folder_path):
        # Перейменування папки зі старою назвою на нову назву
        os.rename(old_folder_path, new_folder_path)

    # Відкриття файлу requirements_components.txt
    project_folder = 'components'
    requirements_file = f"components/{selected_component_name}/reguirements-components.txt"
    component_ids = None
    if os.path.isfile(requirements_file):
        with open(requirements_file, 'r') as file:
            component_ids = file.read().splitlines()
    try:
        # Зчитати вміст файлу YAML
        with open(f"{project_folder}/components.yml", 'r') as file:
            components_data = yaml.safe_load(file)
    except FileNotFoundError as e:
        logging.error(f"Not found  {str(e)}")
    if components_data == None:
        components_data = {'components': []}
    # response = requests.get(f'{K2.update_domain}k2update/api/components')
    # json_data = response.json()
    json_data = K2Upd.get_k2update_components()
    try:
        if component_ids:
            for component_id in component_ids:
                #
                # response = requests.get(f'{K2.update_domain}k2update/api/components')
                json_data = K2Upd.get_k2update_components()
                # json_data = response.json()
                pattern = r'^([^=]+)'
                match = re.search(pattern, component_id)
                component_name = match.group(1)
                selected_component = next((component for component in json_data if component['name'] == component_name),
                                          None)
                component_id = selected_component['id']
                existing_component = next(
                    (c for c in components_data['components'] if c['name'] == selected_component['name']),
                    None)
                if existing_component:
                    continue
                else:
                    requests.get(f"{K2.domain_loc}/install_components-one-request/{component_id}")
                    reload_app_configs(component_name)
                    requests.get(f"{K2.domain_loc}/install-requirments-one-request/{component_name}")
                    requests.get(f"{K2.domain_loc}/make-migrations-one-reguest/{component_name}")
                    requests.get(f"{K2.domain_loc}/{component_name}/data-migrations")
            event = f"Install requirements components for {selected_component_name} "
            write_to_log_file(event)
            reload_app_configs(selected_component_name)
            reload_app()
            return jsonify(
                message=f"Залежні компоненти <b>{', '.join(component_ids)}</b> встановлені...<span class='mdi mdi-check'></span> <a href='#'>детальніше</a>",
                status="success")

        else:
            event = f"Install component {selected_component_name} "
            write_to_log_file(event)
            reload_app_configs(selected_component_name)
            return jsonify(
                message=f"Залежні компоненти встановлені...<span class='mdi mdi-check'></span> <a href='#'>детальніше</a>",
                status="success")
    except Exception as e:
        requests.get(f"{K2.domain_loc}/remove-component/{main_component_id}")
        logging.error(f"Error install component {selected_component_name}: {str(e)}")
        return jsonify(
            message=f"Помилка встановлення залежних компонент... {str(e)} <span class='mdi mdi-check'></span> <a href='#'>детальніше</a>",
            status="error")


@components_bp.route('/install-requirments-components-one-request-beta/<string:main_component_id>')
def install_requirements_components_one_request_beta(main_component_id):
    '''роут встановлення залежних компонент для тестової версії'''
    try:
        # response = requests.get(f'{K2.update_domain}k2update/api/components-beta')
        # json_data = response.json()
        json_data = K2Upd.get_k2update_components_beta()
        selected_component = next((component for component in json_data if component['id'] == main_component_id), None)
        if selected_component is None:
            return 'Component not found'
        selected_component_name = selected_component['name']
        archive_url = selected_component['latest_component_data']
        version = selected_component['latest_version']
    except:
        logging.error(f"Update server is not avaible")

    # Створити шлях до папки компоненти згідно назви та версії
    project_folder = 'components'
    component_folder = os.path.join(project_folder)
    os.makedirs(component_folder, exist_ok=True)
    # Завантажити архів компоненти
    response = requests.get(archive_url, stream=True)
    response.raise_for_status()
    # Шлях до завантаженого архіву
    archive_path = os.path.join(component_folder, f"{selected_component['name']}.zip")
    # Зберегти архів на диск
    with open(archive_path, "wb") as file:
        for chunk in response.iter_content(chunk_size=8192):
            file.write(chunk)
    # Розпакувати архів
    with zipfile.ZipFile(archive_path, "r") as zip_ref:
        zip_ref.extractall(component_folder)
    # Видалити архів
    os.remove(archive_path)
    # перейменувати якщо git
    component_name = selected_component['name']
    old_folder_path = os.path.join(component_folder, component_name + ".git")
    new_folder_path = os.path.join(component_folder, component_name)
    # Перевірка наявності папки зі старою назвою
    if os.path.exists(old_folder_path) and os.path.isdir(old_folder_path):
        # Перейменування папки зі старою назвою на нову назву
        os.rename(old_folder_path, new_folder_path)

    # Відкриття файлу requirements_components.txt
    project_folder = 'components'
    requirements_file = f"components/{selected_component_name}/reguirements-components.txt"
    component_ids = None
    if os.path.isfile(requirements_file):
        with open(requirements_file, 'r') as file:
            component_ids = file.read().splitlines()
    try:
        # Зчитати вміст файлу YAML
        with open(f"{project_folder}/components.yml", 'r') as file:
            components_data = yaml.safe_load(file)
    except FileNotFoundError as e:
        logging.error(f"Not found  {str(e)}")
    if components_data == None:
        components_data = {'components': []}
    # response = requests.get(f'{K2.update_domain}k2update/api/components-beta')
    # json_data = response.json()
    json_data = K2Upd.get_k2update_components_beta()
    try:
        if component_ids:
            for component_id in component_ids:
                # response = requests.get(f'{K2.update_domain}k2update/api/components-beta')
                # json_data = response.json()
                json_data = K2Upd.get_k2update_components_beta()
                pattern = r'^([^=]+)'
                match = re.search(pattern, component_id)
                component_name = match.group(1)
                selected_component = next((component for component in json_data if component['name'] == component_name),
                                          None)
                component_id = selected_component['id']
                existing_component = next(
                    (c for c in components_data['components'] if c['name'] == selected_component['name']),
                    None)
                if existing_component:
                    continue
                else:
                    requests.get(f"{K2.domain_loc}/install_components-one-request/{component_id}")
                    reload_app_configs(component_name)
                    requests.get(f"{K2.domain_loc}/install-requirments-one-request/{component_name}")
                    requests.get(f"{K2.domain_loc}/make-migrations-one-reguest/{component_name}")
                    requests.get(f"{K2.domain_loc}/{component_name}/data-migrations")
            event = f"Install requirements components for {selected_component_name} "
            write_to_log_file(event)
            reload_app_configs(selected_component_name)
            reload_app()
            return jsonify(
                message=f"Залежні компоненти <b>{', '.join(component_ids)}</b> встановлені...<span class='mdi mdi-check'></span> <a href='#'>детальніше</a>",
                status="success")

        else:
            event = f"Install component {selected_component_name} "
            write_to_log_file(event)
            reload_app_configs(selected_component_name)
            return jsonify(
                message=f"Залежні компоненти встановлені...<span class='mdi mdi-check'></span> <a href='#'>детальніше</a>",
                status="success")
    except Exception as e:
        requests.get(f"{K2.domain_loc}/remove-component/{main_component_id}")
        logging.error(f"Error install component {selected_component_name}: {str(e)}")
        return jsonify(
            message=f"Помилка встановлення залежних компонент... {str(e)} <span class='mdi mdi-check'></span> <a href='#'>детальніше</a>",
            status="error")


@components_bp.route('/remove_dependencies/<string:component_id>', methods=['GET'])
def remove_dependencies(component_id):
    '''вимкнення компоненти'''
    # Знаходимо компоненту за її ID
    # component = Component.query.get(component_id)
    # if not component:
    #    return 'Component not found <meta http-equiv="refresh" content="1;url=/dashboard" />'
    try:
        with open(f"components/components.yml", 'r') as file:
            components_data = yaml.safe_load(file)
        if components_data is None:
            return None
        # Шукати компонент за id
        for comp in components_data['components']:
            if comp['id'] == component_id:
                component = comp
                break
        component_name = component['name']

        component['installed'] = False
        with open(f"components/components.yml", 'w') as file:
            yaml.dump(components_data, file)

        # reload_app_configs(component_name)
        K2Menu.add_to_menu_install(component_name)
        reload_app()
        K2().search_menu_items()
        K2().search_menu_items_category()
        reload_app_configs_del(component_name)
        reload_app()
        event = f"Turn of {component_name}"
        write_to_log_file(event)
        logging.info(f"{component_name} component successfully turn off!")
        flash('t_remove_dependecies_msg', 'info')
    except Exception as e:
        logging.error(f"Error turn-off component {str(e)}")
        flash(f'Помилка вимкнення компоненти {str(e)}', 'error')
    return redirect(request.referrer)


@components_bp.route('/add_dependencies/<string:component_id>', methods=['GET'])
def add_dependencies(component_id):
    '''увімкнення компоненти'''
    try:
        # Зчитати вміст файлу YAML
        with open(f"components/components.yml", 'r') as file:
            components_data = yaml.safe_load(file)

        if components_data is None:
            return 'Component not found <meta http-equiv="refresh" content="1;url=/components-list" />'

        # Знайти компоненту за ID
        component = None
        for comp in components_data['components']:
            if comp['id'] == component_id:
                component = comp
                break

        # Оновлюємо статус компоненти
        component['installed'] = True
        component_name = component['name']
        # Оновлення вмісту файлу YAML
        with open(f"components/components.yml", 'w') as file:
            yaml.dump(components_data, file)
        logging.info(f"{component_name} component successfully turn on!")
        event = f"Turn on {component_name}"
        K2Menu.add_to_menu_install(component_name)
        write_to_log_file(event)
        K2().search_menu_items()
        K2().search_menu_items_category()
        K2().search_class_dict()
        reload_app_configs(component_name)
        reload_app()
        flash('t_add_dependecies_msg', 'info')
    except Exception as e:
        logging.error(f"Error turn-on component {str(e)}")
        flash(f'Помилка увімкнення компоненти {str(e)}', 'error')
    return redirect(request.referrer)


@components_bp.route('/remove-component/<string:component_id>')
def remove_component(component_id):
    '''видалення компоненти'''
    # Шлях до папки з компонентами
    components_folder = 'components'
    try:
        # Зчитати вміст файлу YAML
        with open(f"{components_folder}/components.yml", 'r') as file:
            components_data = yaml.safe_load(file)

        if components_data is None:
            logging.error(f"Components not found ")
            return 'Component not found <meta http-equiv="refresh" content="1;url=/components-list" />'

        # Знайти компоненту за ID
        component = None
        for comp in components_data['components']:
            if comp['id'] == component_id:
                component = comp
                break
        subclasses = K2Obj.__subclasses__()
        # if f"components.{component}.{component}.views.{component}" in subclasses:
        #    subclasses.remove(subclass_to_remove)

        # for subclass in K2Obj.__subclasses__():

        reload_app_configs_del(component['name'])
        # Видалити папку репозиторія компоненти
        repository_folder = os.path.join(components_folder, component['name'])
        if os.path.exists(repository_folder):
            shutil.rmtree(repository_folder)

        # Видалити компоненту зі списку
        components_data['components'] = [comp for comp in components_data['components'] if comp['id'] != component_id]

        # Записати оновлений вміст у файл YAML
        with open(f"{components_folder}/components.yml", 'w') as file:
            yaml.dump(components_data, file)
        K2().search_menu_items()
        K2().search_menu_items_category()
        event = f"Uninstall component {component['name']} "
        write_to_log_file(event)

        logging.info(f"{component['name']} removed successfully")
        flash('t_remove_component_msg', 'info')
    except Exception as e:
        logging.error(f"Error delete component {str(e)}")
        flash(f'Помилка видалення компоненти {str(e)}', 'error')
    return redirect(request.referrer)


@components_bp.route('/mediafile/<string:date>/<string:file_path>', methods=['GET'])
def download_file(date, file_path):
    '''Завантаження файлу за його датою та ідентифікатором'''
    filename='image.jpg'
    file = K2().path.get_media_file(date, file_path, filename)
    if file:
        return K2().path.get_media_file(date, file_path, filename)
    else:
        return "404 not found"


@components_bp.route('/additionals-components-license-key', methods=['GET', 'POST'])
@login_required
def components_license_keys():
    '''генерація сторінки із формою введення ліцензійних ключів для Syncfusion, Stimulsoft і AgGrid'''
    # Отримання поточного статусу наявності ліцензійних ключів
    syncfusion_key = K2Upd.get_syncfusion_license_key()
    stimulsoft_key = K2Upd.get_stimulsoft_license_key()
    aggrid_key = K2Upd.get_aggrid_license_key()

    from components.k2site.k2site.forms import LicenseKeysForm
    form = LicenseKeysForm()

    if request.method == "POST":
        if form.validate_on_submit():
            # Отримання даних з форми
            syncfusion_key = form.syncfusion_license_key.data
            # stimulsoft_key = form.stimulsoft_license_key.data
            aggrid_key = form.aggrid_license_key.data

            # Збереження кожного ключа у відповідні файли
            K2Upd.save_license_key('syncfusion', syncfusion_key)
            # K2Upd.save_license_key('stimulsoft', stimulsoft_key)
            K2Upd.save_license_key('aggrid', aggrid_key)

            flash('License keys saved successfully!')

            # Оновлення статусів після збереження
            syncfusion_key = K2Upd.get_syncfusion_license_key()
            stimulsoft_key = ''
            aggrid_key = K2Upd.get_aggrid_license_key()

            return redirect(url_for('components.components_license_keys'))

    return render_template('dashboard-components-license-keys.html',
                           form=form,
                           syncfusion_key=syncfusion_key,
                           stimulsoft_key=stimulsoft_key,
                           aggrid_key=aggrid_key)


@components_bp.route('/api/get-stimkey', methods=['GET'])
@login_required
def stimulsoft_components_license_key():
    license_filename = 'stimulsoft.yml'
    LICENSE_DIR = K2.file_lic_stimulsoft_path.replace(license_filename,'')
    license_path = os.path.join(LICENSE_DIR, license_filename)

    if not os.path.exists(license_path):
        return "File not found", 404

    return send_from_directory(LICENSE_DIR, license_filename, mimetype='text/plain')

# @contextmanager
# def get_db_connection():
#     connection = engine.connect()
#     try:
#         # Передаємо з'єднання через yield
#         yield connection
#         #Блок with завершився, робимо commit
#         connection.commit()
#
#     except Exception as e:
#         # (або) Сталася помилка, робимо rollback
#         connection.rollback()
#         raise
#     finally:
#         # Закриваємо з'єднання"
#         connection.close()


@components_bp.route('/components-add')
@login_required
def component_add_dasb():
    '''генерація сторінки із списком компонент доступних для встановлення'''
    # Ініціалізація змінних
    component_server = None
    component_root = None
    component_options = None
    update_avaibility = [{"update_avaible": 0, "expiry_date": None}]
    components_data = None

    try:
        # Отримання даних з сервера оновлень
        update_avaibility = K2Upd.get_k2update_components_update_avaibility()
        all_components = K2Upd.get_k2update_components()

        # Розділення компонентів на root та серверні
        component_root = [item for item in all_components if item['name'] == 'k2root']
        component_server = [item for item in all_components if item['name'] != 'k2root']

        # Отримання опцій компонентів
        component_options = K2Upd.get_k2update_components_options()
    except Exception as e:
        logging.error(f"Update server is not available: {str(e)}")

    # Обробка пошукового запиту
    search_query = request.args.get('search_query')
    filtered_components = []

    if component_server and search_query:
        encoded_search_query = unquote(search_query.lower())
        filtered_components = [
            component for component in component_server
            if any(
                encoded_search_query in (component.get(field) or '').lower()
                for field in ['name', 'description', 'component_category', 'name_lpu', 'programminglanguage_name']
            )
        ]
    else:
        filtered_components = component_server if component_server else "Error"

    # Підготовка категорій
    component_server_category = list({
        comp['component_category']
        for comp in component_server or []
        if comp.get('component_category')
    })

    # Отримання опцій категорій
    components_category_app = component_options[0]['components_category_app'] if component_options else None
    components_category_theme = component_options[0]['components_category_theme'] if component_options else None
    components_programming_languages = component_options[0][
        'components_programming_languages'] if component_options else None

    # Отримання встановлених компонентів
    components_data = K2.ins_search_comp()
    components_version = []
    components_names = []

    if components_data and 'components' in components_data:
        components_version = [{comp['name']: comp['version']} for comp in components_data['components']]
        components_names = [comp['name'] for comp in components_data['components']]

    # Пошук компонентів для оновлення
    component_server_versions = [
        {comp['name']: comp['latest_version']}
        for comp in component_server or []
        if comp.get('name') and comp.get('latest_version')
    ]

    list_for_update = []
    for server_comp in component_server_versions:
        for name, version in server_comp.items():
            installed_comp = next((c for c in components_version if name in c), None)
            if installed_comp and LooseVersion(version) > LooseVersion(installed_comp[name]):
                list_for_update.append({name: version})

    count_update = len(list_for_update)

    return render_template(
        'dashboard-add.html',
        component_server=filtered_components,
        search_query=search_query,
        components_names=components_names,
        components_version=components_version,
        k2root_version=K2.version,
        component_root=component_root,
        count_update=count_update,
        component_server_category=component_server_category,
        title=gettext('t_components_shop'),
        components_category_app=components_category_app,
        components_category_theme=components_category_theme,
        components_programming_languages=components_programming_languages,
        list_for_update=list_for_update,
        update_avaibility=update_avaibility
    )


@components_bp.route('/components-list')
@login_required
def component_list_dasb_new():
    '''генерація сторінки із списком встановлених компонентів'''
    # Ініціалізація змінних з дефолтними значеннями
    update_avaibility = [{"update_avaible": 0, "expiry_date": None}]
    component_server = None
    component_options = None
    components = []

    try:
        update_avaibility = K2Upd.get_k2update_components_update_avaibility()
    except Exception as e:
        logging.error(f"Failed to get update availability: {str(e)}")

    # Отримання встановлених компонентів
    components_data = K2.ins_search_comp()
    if components_data and 'components' in components_data:
        components = components_data['components']

    try:
        # Отримання інформації про доступні компоненти
        component_server = K2Upd.get_k2update_components()
        component_options = K2Upd.get_k2update_components_options()
    except Exception as e:
        logging.error(f"Update server is not available: {str(e)}")

    # Отримання опцій категорій
    components_category_app = None
    components_category_theme = None
    components_programming_languages = None

    if component_options:
        components_category_app = component_options[0].get('components_category_app')
        components_category_theme = component_options[0].get('components_category_theme')
        components_programming_languages = component_options[0].get('components_programming_languages')

    # Підрахунок доступних оновлень
    count_update = 0
    if component_server:
        # Створення словника {ім'я_компонента: остання_версія} для швидкого пошуку
        latest_versions = {comp['name']: comp['latest_version'] for comp in component_server}

        for component in components:
            comp_name = component['name']
            comp_version = component.get('version')

            if comp_name in latest_versions:
                latest_version = latest_versions[comp_name]
                if (comp_version and latest_version and
                        LooseVersion(latest_version) > LooseVersion(comp_version)):
                    count_update += 1

    return render_template(
        'dashboard-list.html',
        components=components,
        components_names=[comp['name'] for comp in components],
        components_version=[{comp['name']: comp.get('version')} for comp in components],
        k2root_version=K2.version,
        count_update=count_update,
        title=gettext('t_installed_components'),
        components_category_app=components_category_app,
        components_category_theme=components_category_theme,
        components_programming_languages=components_programming_languages,
        update_avaibility=update_avaibility  # Виправлено тут
    )


@components_bp.route('/install-component-progress/<string:component_id>')
# @login_required
def install_component_progress(component_id):
    '''генерація сторінки з прогресбаром встановлення компоненти'''
    try:
        # response = requests.get(f'{K2.update_domain}k2update/api/components')
        json_data = K2Upd.get_k2update_components()
        # json_data = response.json()
        selected_component = next((component for component in json_data if component['id'] == component_id), None)
        if selected_component is None:
            return 'Component not found'
        component_name = selected_component['name']
    except:
        logging.error(f"Update server is not avaible")
    return render_template('install-components.html', component_name=component_name, component_id=component_id)



@components_bp.route('/components-update')
@login_required
def component_upd_list():
    '''генерація сторінки із списком оновлень'''
    try:
        # response = requests.get(f'{K2.update_domain}k2update/api/components')
        json_data = K2Upd.get_k2update_components()
        # response_beta = requests.get(f'{K2.update_domain}k2update/api/components-beta')

        # json_data = response.json()
        # json_data_beta = response_beta.json()
        json_data_beta = K2Upd.get_k2update_components_beta()
        component_server = [item for item in json_data if item['name'] != 'k2root']
        component_server_beta = [item for item in json_data_beta if item['name'] != 'k2root']

        component_root = [item for item in json_data if item['name'] == 'k2root']
        # response = requests.get(f'{K2.update_domain}k2update/api/components-options')
        # json_data = response.json()
        json_data = K2Upd.get_k2update_components_options()
        component_options = [item for item in json_data]
    except:
        component_server = None
        component_server_beta = None
        component_root = None
        component_options = None
        logging.error(f"Update server is not available")

    # Отримання значення пошукового запиту з параметрів URL
    search_query = request.args.get('search_query')
    filtered_components = []
    filtered_components_beta = []
    # список категорій
    if component_options:
        components_category_app = component_options[0]['components_category_app']
        components_category_theme = component_options[0]['components_category_theme']
        components_programming_languages = component_options[0]['components_programming_languages']
    else:
        components_category_app = None
        components_category_theme = None
        components_programming_languages = None

    if search_query:
        filtered_components = [component for component in component_server if
                               (search_query.lower() in component['name'].lower() if component[
                                   'name'] else False) or
                               (search_query.lower() in component['description'].lower() if component[
                                   'description'] else False)]
        filtered_components_beta = [component for component in component_server_beta if
                                    (search_query.lower() in component['name'].lower() if component[
                                        'name'] else False) or
                                    (search_query.lower() in component['description'].lower() if component[
                                        'description'] else False)]
    else:
        filtered_components = component_server
        filtered_components_beta = component_server_beta

    component_server_versions = []
    component_server_versions_beta = []

    if component_server is not None:
        for comp_s in component_server:
            name = comp_s['name']
            version = comp_s['latest_version']
            component_server_versions.append({name: version})

    if component_server_beta is not None:
        for comp_b in component_server_beta:
            name = comp_b['name']
            version = comp_b['latest_version']
            component_server_versions_beta.append({name: version})

    project_folder = 'components'
    components_data = K2.ins_search_comp()
    components_names = []
    components_version = []

    if components_data is not None:
        for component in components_data['components']:
            name = component['name']
            version = component['version']
            components_names.append(name)
            components_version.append({name: version})

    # пошук компонентів, для яких доступні оновлення
    list_for_update = []
    list_for_update_beta = []
    list_for_update_name = []
    list_for_update_name_beta = []

    for component_server in component_server_versions:
        for key, value in component_server.items():
            # Шукаємо відповідний елемент у components_version за ключем
            corresponding_component = next((cmp for cmp in components_version if key in cmp), None)

            if corresponding_component:
                corresponding_value = corresponding_component[key]
                # Порівнюємо версії та додаємо елемент у список, якщо значення більше
                if LooseVersion(value) > LooseVersion(corresponding_value):
                    list_for_update.append({key: value})
                    list_for_update_name.append(key)

    for component_server_beta in component_server_versions_beta:
        for key, value in component_server_beta.items():
            # Шукаємо відповідний елемент у components_version за ключем
            corresponding_component = next((cmp for cmp in components_version if key in cmp), None)

            if corresponding_component:
                corresponding_value = corresponding_component[key]
                # Порівнюємо версії та додаємо елемент у список, якщо значення більше
                if LooseVersion(value) > LooseVersion(corresponding_value):
                    list_for_update_beta.append({key: value})
                    list_for_update_name_beta.append(key)

    count_update = len(list_for_update)
    count_update_beta = len(list_for_update_beta)
    update_avaibility = K2Upd.get_k2update_components_update_avaibility()

    return render_template('update-components-list.html',
                           search_query=search_query, component_server=filtered_components,
                           component_server_beta=filtered_components_beta, components_names=components_names,
                           components_version=components_version, k2root_version=K2.version,
                           component_root=component_root, count_update=count_update,
                           count_update_beta=count_update_beta, list_for_update=list_for_update,
                           list_for_update_beta=list_for_update_beta, list_for_update_name=list_for_update_name,
                           list_for_update_name_beta=list_for_update_name_beta, title=gettext('t_update_component'),
                           components_category_app=components_category_app,
                           components_category_theme=components_category_theme,
                           components_programming_languages=components_programming_languages,
                           update_avaibility=update_avaibility)

