import subprocess
from k2.k2cfg import K2
import sys
import requests
from requests.exceptions import RequestException


# Отримання аргументів командного рядка
if len(sys.argv) < 2:
    print("Component name...")
    sys.exit(1)

component_name = sys.argv[1]
try:
    response = requests.get(f'{K2.update_domain}k2update/api/components')
    json_data = response.json()
    selected_component = next((component for component in json_data if component['name'] == component_name), None)
    # Отримати посилання на архів компоненти та версію
    component_id = selected_component['id']
except:
    pass

# Виклик команди curl для виконання HTTP-запиту
subprocess.call(["curl", f"{K2.domain}install_components-one-request/{component_id}"])