const isMobile = {
    Android: function () {
        return navigator.userAgent.match(/Android/i);
    },
    BlackBerry: function () {
        return navigator.userAgent.match(/BlackBerry/i);
    },
    iOS: function () {
        return navigator.userAgent.match(/iPhone|iPad|iPod/i);
    },
    Opera: function () {
        return navigator.userAgent.match(/Opera Mini/i);
    },
    Windows: function () {
        return navigator.userAgent.match(/IEMobile/i);
    },
    any: function () {
        return (isMobile.Android() || isMobile.BlackBerry() || isMobile.iOS() || isMobile.Opera() || isMobile.Windows());
    }
};

if (isMobile.any()) {
    document.body.classList.add('touch');
} else {
    document.body.classList.add('pc');
}

const iconMenu = document.querySelector('.header-icon');
const menu = document.querySelector('.main__menu-wrapper');

if (iconMenu) {
    iconMenu.addEventListener('click', function (e) {
        document.body.classList.toggle('lock');
        menu.classList.toggle('active-menu');
        iconMenu.classList.toggle('active-menu');
    })
}

const tabsInformationPlugin = document.querySelectorAll('.main-plugin__information-item');
const pluginInformationText = document.querySelectorAll('.main-plugin__information-text');

tabsInformationPlugin.forEach(tab => {
    tab.addEventListener('click',event => {
        tabsInformationPlugin.forEach(item => {
            item.classList.remove('active-tab');
        });
        pluginInformationText.forEach(item => {
            item.classList.remove('active-tab');
        });
        event.target.classList.add('active-tab');
        document.querySelector(`div[data-text="${event.target.id}"]`).classList.add('active-tab');
    })
})

/*slider*/

const sliders = ['img/converted_1.png','img/converted_2.png','img/converted_3.png','img/converted_4.png','img/converted_5.png'];
if(sliders.length > 1) {
    const wrapperSliders = document.querySelector('.main-plugin__wrapper-sliders');
    wrapperSliders.style.display = 'flex';
}

const slider1 = document.getElementById("slider_1");
const slider2 = document.getElementById("slider_2");
const slider3 = document.getElementById("slider_3");
const mainSlider = document.getElementById('main-slider-img');
const sliderArrowLeft = document.querySelector('.slider-arrow-left');
const sliderArrowRight = document.querySelector('.slider-arrow-right');

sliderArrowRight.addEventListener('click', event => {
    mainSlider.style.opacity = '0';
    mainSlider.src = sliders[1];
    mainSlider.style.opacity = '1';
    
    sliders.push(sliders.shift());
    slider1.src = sliders[0];
    slider2.src = sliders[1];
    slider3.src = sliders[2];
})

sliderArrowLeft.addEventListener('click', event => {
    mainSlider.src = sliders[1];
    sliders.unshift(sliders.pop());
    slider1.src = sliders[0];
    slider2.src = sliders[1];
    slider3.src = sliders[2];
})





