const isMobile = {
    Android: function () {
        return navigator.userAgent.match(/Android/i);
    },
    BlackBerry: function () {
        return navigator.userAgent.match(/BlackBerry/i);
    },
    iOS: function () {
        return navigator.userAgent.match(/iPhone|iPad|iPod/i);
    },
    Opera: function () {
        return navigator.userAgent.match(/Opera Mini/i);
    },
    Windows: function () {
        return navigator.userAgent.match(/IEMobile/i);
    },
    any: function () {
        return (isMobile.Android() || isMobile.BlackBerry() || isMobile.iOS() || isMobile.Opera() || isMobile.Windows());
    }
};

if (isMobile.any()) {
    document.body.classList.add('touch');
} else {
    document.body.classList.add('pc');
}

const iconMenu = document.querySelector('.header-icon');
const menu = document.querySelector('.main__menu-wrapper');

if (iconMenu) {
    iconMenu.addEventListener('click', function (e) {
        login.classList.remove('active-login');
        updatesPopUp.classList.remove('active-updates-pop-up');
        document.body.classList.toggle('lock');
        menu.classList.toggle('active-menu');
        iconMenu.classList.toggle('active-menu');
    })
}

const tabsInformationPlugin = document.querySelectorAll('.main-plugin__information-item');
const pluginInformationText = document.querySelectorAll('.main-plugin__information-text');

tabsInformationPlugin.forEach(tab => {
    tab.addEventListener('click', event => {
        tabsInformationPlugin.forEach(item => {
            item.classList.remove('active-tab');
        });
        pluginInformationText.forEach(item => {
            item.classList.remove('active-tab');
        });
        event.target.classList.add('active-tab');
        document.querySelector(`div[data-text="${event.target.id}"]`).classList.add('active-tab');
    })
})

/*slider*/

const sliders = ['/k2site/k2site/static/img/k2cloud.jpg', '/k2site/k2site/static/img/k2cloud.jpg', '/k2site/k2site/static/img/k2cloud.jpg', '/k2site/k2site/static/img/k2cloud.jpg', '/k2site/k2site/static/img/k2cloud.jpg'];

if (sliders.length > 1) {
    if (document.querySelector('.main-plugin__wrapper-sliders')) {
        document.querySelector('.main-plugin__wrapper-sliders').style.display = 'flex';
    }
}

const slider1 = document.getElementById("slider_1");
const slider2 = document.getElementById("slider_2");
const slider3 = document.getElementById("slider_3");
const mainSlider = document.getElementById('main-slider-img');
const sliderArrowLeft = document.querySelector('.slider-arrow-left');
const sliderArrowRight = document.querySelector('.slider-arrow-right');

if (sliderArrowRight) {
    sliderArrowRight.addEventListener('click', event => {
        mainSlider.style.opacity = '0';
        mainSlider.src = sliders[1];
        mainSlider.style.opacity = '1';

        sliders.push(sliders.shift());
        slider1.src = sliders[0];
        slider2.src = sliders[1];
        slider3.src = sliders[2];
    })
}

if (sliderArrowLeft) {
    sliderArrowLeft.addEventListener('click', event => {
        mainSlider.src = sliders[1];
        sliders.unshift(sliders.pop());
        slider1.src = sliders[0];
        slider2.src = sliders[1];
        slider3.src = sliders[2];
    })
}

/*login*/

const iconLogin = document.querySelector('.icons__login-svg');
const iconLogout = document.querySelector('.icons__logout-svg');
const login = document.querySelector('.login');

iconLogin.addEventListener('click', event => {
    document.body.classList.remove('lock');
    menu.classList.remove('active-menu');
    iconMenu.classList.remove('active-menu');
    updatesPopUp.classList.remove('active-updates-pop-up');
    squaresList.classList.remove('active-squares-list');
    login.classList.toggle('active-login');
});

iconLogout.addEventListener('click', function () {
    localStorage.removeItem('token');
    iconLogin.style.display = 'block';
    iconLogout.style.display = 'none';
    document.body.classList.remove('lock');
    menu.classList.remove('active-menu');
    iconMenu.classList.remove('active-menu');
    updatesPopUp.classList.remove('active-updates-pop-up');
    squaresList.classList.remove('active-squares-list');
});

function detectBuyer() {
    const buyer = localStorage.getItem('token') || 'anonymous';

    if (buyer === 'anonymous') {
        iconLogin.style.display = 'block';
        iconLogout.style.display = 'none';
    } else {
        iconLogin.style.display = 'none';
        iconLogout.style.display = 'block';
    }
}
/*Додаю токен для прикладу(зміна іконки логін і логаут)*/
localStorage.setItem('token', 'value');

detectBuyer();

/*updates*/

//const updates = [{}, {}, {}, {}, {}, {}];
//const countUpdates = document.querySelector('.count-updates');

//if (updates.length != 0) {
//    countUpdates.style.display = 'flex';
//    countUpdates.innerText = `${updates.length}`;
//} else {
//    countUpdates.style.display = 'none';
//}

const iconBell = document.querySelector('.icons__bell-svg');
const updatesPopUp = document.querySelector('.updates-pop-up');

iconBell.addEventListener('click', event => {
    document.body.classList.remove('lock');
    menu.classList.remove('active-menu');
    iconMenu.classList.remove('active-menu');
    login.classList.remove('active-login');
    squaresList.classList.remove('active-squares-list');
    updatesPopUp.classList.toggle('active-updates-pop-up');
})

/*squares*/

const iconSquares = document.querySelector('.icons__squares-svg');
const squaresList = document.querySelector('.squares-list');

iconSquares.addEventListener('click', event => {
    document.body.classList.remove('lock');
    menu.classList.remove('active-menu');
    iconMenu.classList.remove('active-menu');
    login.classList.remove('active-login');
    updatesPopUp.classList.remove('active-updates-pop-up');
    squaresList.classList.toggle('active-squares-list');
})

/*const squaresListLink = document.querySelector('.squares-list__link');

squaresListLink.addEventListener('click', event => {
    squaresList.classList.remove('active-squares-list');
})*/

const favoritesIcons = document.querySelectorAll('.favorites-icon');
const headerIconsMenu = document.querySelector('.header__icons-menu');
const favoritesIconsHeader = [];

favoritesIcons.forEach(icon => {
    icon.addEventListener('change', event => {
        if (event.target.checked) {
            const cloneIcon = (document.querySelector(`.squares-list__item[data-name="${event.target.id}"] `)).cloneNode(true);
            while (cloneIcon.firstChild) {
                cloneIcon.removeChild(cloneIcon.firstChild);
            }
            if (favoritesIconsHeader.length < 5) {
                favoritesIconsHeader.push(cloneIcon);
                headerIconsMenu.innerHTML = '';
                favoritesIconsHeader.forEach(icon => {
                    icon.setAttribute('data-delete', `${icon.dataset.name}`);
                    icon.classList.add('header__icon-item');
                    headerIconsMenu.appendChild(icon);
                })
            }
            if (favoritesIconsHeader.length >= 5) {
                favoritesIcons.forEach(icon => {
                    if (!icon.checked) {
                        icon.setAttribute('disabled', 'disabled');
                    }
                })
            }
        } else {
            favoritesIconsHeader.splice(favoritesIconsHeader.findIndex(icon => icon === event.target), 1);
            document.querySelector(`.squares-list__item[data-delete="${event.target.id}"] `).remove();
            favoritesIcons.forEach(icon => {
                icon.removeAttribute('disabled');
            })
        }
    })
})

document.addEventListener('click', event => {
    const squaresList = document.querySelector('.squares-list');
    const iconSquares = document.querySelector('.icons__squares-svg');
    if (!squaresList.contains(event.target) && !iconSquares.contains(event.target)) {
        squaresList.classList.remove('active-squares-list');
    }
})

//Menu-buttons

const menuButtonApps = document.querySelector('.menu-buttons__apps');
const menuButtonThemes = document.querySelector('.menu-buttons__themes');
const appsPluginsNavigation = document.querySelector('.apps-plugins-navigation');
const themesNavigation = document.querySelector('.themes-navigation');

menuButtonApps.addEventListener('click', event => {
    if (!menuButtonApps.classList.contains('active-menu-button')) {
        menuButtonApps.classList.add('active-menu-button');
        menuButtonThemes.classList.remove('active-menu-button');
        appsPluginsNavigation.style.display = 'block';
        themesNavigation.style.display = 'none';
    }
})

menuButtonThemes.addEventListener('click', event => {
    if (!menuButtonThemes.classList.contains('active-menu-button')) {
        menuButtonThemes.classList.add('active-menu-button');
        menuButtonApps.classList.remove('active-menu-button');
        appsPluginsNavigation.style.display = 'none';
        themesNavigation.style.display = 'block';
    }
})

//Installed
const deleteButtons = document.querySelectorAll('.installed__delete');
const switchButtons = document.querySelectorAll('.installed__switch');
const buttonCancellations = document.querySelectorAll('.installed__button-cancellation');


deleteButtons.forEach((button, index) => {
    const popupId = `popup-${button.dataset.componentName}`;
    button.addEventListener('click', event => {
        document.getElementById(popupId).style.display = 'flex';
        document.querySelector('body').classList.add('lock');
    });
});

buttonCancellations.forEach((button, index) => {
    const popupId = `popup-${button.dataset.componentName}`;
    button.addEventListener('click', event => {
        document.getElementById(popupId).style.display = 'none';
        document.querySelector('body').classList.remove('lock');
    });
});

switchButtons.forEach(button => {
    button.addEventListener('click', event => {
        // Отримуємо ім'я компонента з data-атрибута кнопки
        const componentName = button.dataset.componentName;
        const popupId = `popup-${componentName}`;
        if (button.innerText === 'Вимкнути') {
            button.innerText = 'Увімкнути';
        } else {
            button.innerText = 'Вимкнути';
        }
    });
});

const cancellationButtons = document.querySelectorAll('.installed__button-cancellation.pop-up');
cancellationButtons.forEach(button => {
    button.addEventListener('click', event => {
        // Знаходимо попап, до якого належить кнопка "Ні" та приховуємо його
        const popup = button.closest('.installed__delete-pop-up');
        if (popup) {
            popup.style.display = 'none';
            document.querySelector('body').classList.remove('lock');
        }
    });
});

