import os

USE_GEVENT = os.environ.get('USE_GEVENT', True)

bind = "0.0.0.0:8080"

if USE_GEVENT:
    worker_class = 'geventwebsocket.gunicorn.workers.GeventWebSocketWorker'
    workers = 1
    worker_connections = 500
    keepalive = 2
else:
    worker_class = 'gthread'
    workers = 1
    threads = 16

timeout = 60

accesslog = "-"
errorlog = "-"
loglevel = "info"

access_log_format = '%(h)s %(t)s "%(r)s" %(s)s %(b)s %(M)s "%(f)s" "%(a)s"'

if USE_GEVENT:
    from gevent import monkey
    from psycogreen.gevent import patch_psycopg

    def post_fork(server, worker):
        monkey.patch_all()
        worker.log.info("Gevent patched all")
        patch_psycopg()
        worker.log.info("Made Psycopg2 Green")
