from enum import Enum
try:
    # Python 3.11+
    from enum import StrEnum as _BaseStrEnum
except ImportError:
    # Python < 3.11 – робимо свій StrEnum
    class _BaseStrEnum(str, Enum):
        pass

from .cache_manager import CacheManager
from ..k2clients_connection import redis_client

class StrEnum(_BaseStrEnum):
    """Крос-версійний StrEnum."""
    pass


class NS(StrEnum):
    SESSION = "session"
    APP = "app"
    CONFIG = "config"
    HANDBOOK = "handbook"
    GRID = "grid"
    FORM = "form"
    PRESENCE = "presence"

redis_manager = CacheManager(redis_client=redis_client)
