from flask_babel import *
from flask_babel import Babel, Domain
from flask.helpers import locked_cached_property
from flask_login import current_user
from typing import List, Callable, Optional, Union
import logging
import yaml
import gettext
import polib
import json
import yaml
import subprocess
import os
from babel.messages.pofile import read_po
from babel.messages.mofile import write_mo


class K2Lang():
    '''мови перекладу'''


    @classmethod
    def find_language(cls):
        '''Пошук файлів перекладів для встановлених компонент
         Args:
                  None

          Returns:
              Список шляхів до файлів перекладів
        '''
        project_folder = 'components'
        # Зчитати вміст файлу YAML
        try:
            with open(f"{project_folder}/components.yml", 'r') as file:
                components_data = yaml.safe_load(file)
            languages_paths = []
            # Додаємо головну директорію languages
            languages_paths.append('languages')

            # Знаходимо шляхи до директорій languages для кожного компонента з даних YAML
            if components_data is not None:
                for component in components_data['components']:
                    component_languages_directory = f"components/{component['name']}/{component['name']}/languages"
                    languages_paths.append(component_languages_directory)

            result = ';'.join(languages_paths)
            logging.info(f'Language paths find successful!')
        except FileNotFoundError as e:
            logging.error(f"{project_folder}/components.yml {str(e)}")
        return result

    @classmethod
    def po_to_dict(cls, component_name):
        """
        Витягує дані з .po файлів вибраної компоненти і формує з нього словник.

        Args:
            Назва компоненти.

        Returns:
            Список словників, де кожен словник містить інформацію про переклади для різних мов.
        """
        translation_list = []

        # Отримання списку доступних мов з якогось джерела (наприклад, з конфігураційного файлу)
        from .k2cfg import K2
        # available_languages = K2().get_active_lang_list()
        available_languages = []
        for lang in K2().get_active_lang_list():
            po_file_path = f"components/{component_name}/{component_name}/languages/{lang}/LC_MESSAGES/messages.po"
            if os.path.exists(po_file_path):
                available_languages.append(lang)

        try:
            # Створюємо словник для зберігання перекладів кожного msgid для кожної мови
            translations = {lang: {} for lang in available_languages}


            for lang in available_languages:

                po_file_path = f"components/{component_name}/{component_name}/languages/{lang}/LC_MESSAGES/messages.po"
                po = polib.pofile(po_file_path)
                for entry in po:
                    msgid = entry.msgid
                    msgstr = entry.msgstr
                    translations[lang][msgid] = msgstr

            # Перебираємо всі msgid та створюємо словники з перекладами для кожної мови
            for msgid in translations['uk'].keys():  # Починаємо з мови 'uk', але можна вибрати будь-яку доступну мову
                translation_dict = {
                    "id_group": msgid,
                    "msgid": msgid
                }
                # Додаємо переклади для кожної мови
                for lang in available_languages:
                    translation_dict[f"msgstr_{lang}"] = translations[lang][msgid]

                translation_list.append(translation_dict)
        except (IOError, OSError) as e:
            logging.error(f"Помилка при аналізі .po файлу: {e}")
        return translation_list

    @classmethod
    def dict_to_po(cls, component_name, translations):
        """
        Зберігає дані перекладу зі словника у файли .po для вибраної компоненти.

        Args:
            component_name: Назва компоненти.
            translations: Список словників з перекладами для кожної мови.

        Returns:
            None
        """
        # Отримуємо список доступних мов зі словника перекладів
        from .k2cfg import K2
        available_languages = K2().get_active_lang_list()

        try:
            for lang in available_languages:
                # Створюємо папку для мови, якщо вона ще не існує
                lang_dir = f"components/{component_name}/{component_name}/languages/{lang}/LC_MESSAGES"
                if not os.path.exists(lang_dir):
                    os.makedirs(lang_dir)

                # Створюємо об'єкт po файлу
                po = polib.POFile()

                # Додаємо переклади для кожної мови
                for translation in translations:
                    msgid = translation["msgid"]
                    msgstr = translation.get(f"msgstr_{lang}", '')  # Отримуємо значення або порожній рядок, якщо ключ відсутній
                    entry = polib.POEntry(msgid=msgid, msgstr=msgstr)
                    po.append(entry)

                # Зберігаємо po файл
                po_file_path = f"{lang_dir}/messages.po"
                # Створюємо po файл
                po.save(po_file_path)
                cls.generate_mo_files(lang_dir)


        except OSError as e:
            logging.error(f"Помилка при збереженні .po файлу: {e}")

    @classmethod
    def generate_mo_files(cls, po_directory):
        """
        Генерує файли .mo з файлів .po у заданій директорії.

        Args:
            po_directory (str): Шлях до директорії, де розташовані файли .po.

        Returns:
            None
        """
        # Перевіряємо, чи існує директорія для .mo файлів
        mo_directory = os.path.join(po_directory)
        if not os.path.exists(mo_directory):
            os.makedirs(mo_directory)

        # Ітеруємося по всіх файлах у вказаній директорії
        for filename in os.listdir(po_directory):
            if filename.endswith('.po'):
                po_path = os.path.join(po_directory, filename)
                # Зчитуємо .po файл і зберігаємо його у відповідний .mo файл
                with open(po_path, 'rb') as po_file:
                    mo_file_path = os.path.splitext(po_path)[0] + '.mo'
                    with open(mo_file_path, 'wb') as mo_file:
                        po = read_po(po_file)
                        write_mo(mo_file, po)

    @classmethod
    def save_translations_to_json(cls, translation_dict):
        """
        Зберігає словник перекладів у JSON файл.

        Args:
          translation_dict: Словник перекладів, де ключем є оригінальний текст,
                             а значенням - переклад.
          json_file_path: Шлях до JSON файлу.
        """
        from k2.k2cfg import K2
        # json_file_path = 'components/k2adm/k2adm/data/lang_translate.json'
        json_file_path = os.path.join(K2().path.data_path('data'), 'lang_translate.json')
        with open(json_file_path, 'w', encoding='utf-8') as json_file:
            json.dump(translation_dict, json_file, ensure_ascii=False, indent=4)

    @classmethod
    def generate_translate_yml(cls):
        from k2.k2cfg import K2
        import yaml

        lang_list = K2.get_active_lang_list()  # ['en', 'pl', 'uk', 'an']
        # file_path = 'components/k2adm/k2adm/yml/k2component_translate.yml'
        file_path = os.path.join(K2().path.data_path('yml'), 'k2component_translate.yml')
        print('file_path trans',file_path)


        yml_data = {
            "source_data": "lang_translate",
            "caption": "Метадані",
            "fields": {
                "id_group": {
                    "field": "id_group",
                    "caption": "ID Group",
                    "alias": "id_group",
                    "hidden": True,
                    "readonly": True,
                    "align": "left",
                    "type_field": "text",
                    "primary_key": True
                },
                "msgid": {
                    "field": "msgid",
                    "caption": "ID",
                    "alias": "msgid",
                    "align": "left",
                    "type_field": "text",
                    "hidden": True,
                    "readonly": True,
                    "def_value": 0
                },
                "msgstr_uk": {
                    "field": "msgstr_uk",
                    "caption": "UK",
                    "alias": "msgstr_uk",
                    "align": "left",
                    "type_field": "text",
                    "hidden-form": True
                }
            }
        }

        for lang in lang_list:
            if lang != 'uk':
                yml_data["fields"][f"msgstr_{lang}"] = {
                    "field": f"msgstr_{lang}",
                    "caption": lang.upper(),
                    "alias": f"msgstr_{lang}",
                    "align": "left",
                    "type_field": "text",
                    "def_value": 0
                }

        with open(file_path, 'w') as f:
            yaml.dump(yml_data, f, sort_keys=False)

        from .k2upd import reload_app
        reload_app()


#  виникали проблеми з продуктивністю оскільки кожен раз перечитувались .po файли
#  це було потрібно в системі автоматичних перекладів
# class K2Domain(Domain):
#     def get_translations(self):
#         ctx = _get_current_context()
#
#         if ctx is None:
#             return support.NullTranslations()
#
#         cache = self.get_translations_cache(ctx)
#         locale = get_locale()
#         try:
#             cache.clear()
#             self.cache.clear()
#
#             return cache[str(locale), self.domain[0]]
#         except KeyError:
#             translations = support.Translations()
#
#             for index, dirname in enumerate(self.translation_directories):
#
#                 domain = (
#                     self.domain[0]
#                     if len(self.domain) == 1
#                     else self.domain[index]
#                 )
#
#                 catalog = support.Translations.load(
#                     dirname,
#                     [locale],
#                     domain
#                 )
#                 translations.merge(catalog)
#                 # FIXME: Workaround for merge() being really, really stupid. It
#                 # does not copy _info, plural(), or any other instance variables
#                 # populated by GNUTranslations. We probably want to stop using
#                 # `support.Translations.merge` entirely.
#                 if hasattr(catalog, 'plural'):
#                     translations.plural = catalog.plural
#
#             cache[str(locale), self.domain[0]] = translations
#             return translations

class K2Babel(Babel):
    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)

    @locked_cached_property
    def domain_instance(self):
        """The message domain for the translations.
        """
        return Domain(domain=self.domain)



def _get_current_context() -> Optional[SimpleNamespace]:
    if not g:
        return None

    if not hasattr(g, "_flask_babel"):
        g._flask_babel = SimpleNamespace()

    return g._flask_babel  # noqa


def get_domain() -> Domain:
    ctx = _get_current_context()
    if ctx is None:
        # this will use NullTranslations
        return Domain()

    try:
        return ctx.babel_domain
    except AttributeError:
        pass

    ctx.babel_domain = get_babel().instance.domain_instance
    return ctx.babel_domain


# Create shortcuts for the default Flask domain
def gettext(*args, **kwargs) -> str:
    return get_domain().gettext(*args, **kwargs)


_ = gettext


def ngettext(*args, **kwargs) -> str:
    return get_domain().ngettext(*args, **kwargs)


def pgettext(*args, **kwargs) -> str:
    return get_domain().pgettext(*args, **kwargs)


def npgettext(*args, **kwargs) -> str:
    return get_domain().npgettext(*args, **kwargs)


def lazy_gettext(*args, **kwargs) -> LazyString:
    return LazyString(gettext, *args, **kwargs)


def lazy_pgettext(*args, **kwargs) -> LazyString:
    return LazyString(pgettext, *args, **kwargs)


def lazy_ngettext(*args, **kwargs) -> LazyString:
    return LazyString(ngettext, *args, **kwargs)


def lazy_npgettext(*args, **kwargs) -> LazyString:
    return LazyString(npgettext, *args, **kwargs)

