from sqlalchemy import text


class K2GeneralTest:
    error_phrases = [
        'has no attribute',
        'is missing',
        'Error:',
        'Exception:',
        'Traceback',
    ]

    def check_pages(self, client, routes):
        """Перевірка доступності сторінок, з render_template."""
        for route in routes:
            response = client.get(route)
            print(f"Testing route: {route} - Status code: {response.status_code}")

            assert response.status_code == 200
            content = response.data.decode('utf-8')

            for phrase in self.error_phrases:
                assert phrase not in content, f"Found error phrase '{phrase}' in response for {route}"

    @staticmethod
    def create_storage(db_connection, storage_id, storage_name="Тестовий склад"):
        """
        Створює склад у таблиці k2storage.
        """
        db_connection.execute(text("""
            INSERT INTO k2storage (storage_id, storage_name, active)
            VALUES (:storage_id, :storage_name, :active)
        """), {"storage_id": storage_id, "storage_name": storage_name, "active": 1})

    @staticmethod
    def create_nomenclature(db_connection, nomenclature_id, nomenclature_name="Тестова номенклатура",
                            projid="k2_cloud_erp"):
        """
        Створює номенклатуру у таблиці k2nomenclature.
        """
        db_connection.execute(text("""
            INSERT INTO k2nomenclature (nomenclature_id, nomenclature_name, active, projid)
            VALUES (:nomenclature_id, :nomenclature_name, :active, :projid)
        """), {"nomenclature_id": nomenclature_id, "nomenclature_name": nomenclature_name, "active": 1,
               "projid": projid})

    @staticmethod
    def create_document(db_connection, doc_id, storage_id, document_status=0, active=1):
        """
        Створює документ у таблиці k2docs.
        """
        db_connection.execute(text("""
            INSERT INTO k2docs (doc_id, storage_id, document_status, active)
            VALUES (:doc_id, :storage_id, :document_status, :active)
        """), {
            "doc_id": doc_id,
            "storage_id": storage_id,
            "document_status": document_status,
            "active": active
        })

    @staticmethod
    def create_document_rows(db_connection, row_id, doc_id, nomenclature_id, quantity, active=1, inventory_changes="+",
                             projid="k2_cloud_erp", bar_code_quantity="0/1"):
        """
        Створює рядки документа у таблиці k2doc_rows.
        """
        db_connection.execute(text("""
            INSERT INTO k2doc_rows (
                row_id, doc_id, nomenclature_id, quantity, active, inventory_changes, projid, bar_code_quantity
            ) VALUES (
                :row_id, :doc_id, :nomenclature_id, :quantity, :active, :inventory_changes, :projid, :bar_code_quantity
            )
        """), {
            "row_id": row_id,
            "doc_id": doc_id,
            "nomenclature_id": nomenclature_id,
            "quantity": quantity,
            "active": active,
            "inventory_changes": inventory_changes,
            "projid": projid,
            "bar_code_quantity": bar_code_quantity
        })
